/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.completion.completors;

import java.io.IOException;
import java.util.List;
import org.netbeans.editor.TokenItem;
import org.netbeans.modules.spring.beans.completion.CompletionContext;
import org.netbeans.modules.spring.beans.completion.Completor;
import org.netbeans.modules.spring.beans.completion.CompletorUtils;
import org.netbeans.modules.spring.beans.completion.SpringCompletionResult;
import org.netbeans.modules.spring.beans.completion.SpringXMLConfigCompletionItem;
import org.netbeans.modules.spring.beans.completion.completors.BeansRefCompletor;
import org.netbeans.modules.spring.beans.editor.ContextUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PNamespaceBeanRefCompletor
extends Completor {
    public PNamespaceBeanRefCompletor(int n) {
        super(n);
    }

    @Override
    protected int initAnchorOffset(CompletionContext completionContext) {
        return completionContext.getCurrentToken().getOffset() + 1;
    }

    @Override
    protected void compute(CompletionContext completionContext) throws IOException {
        TokenItem tokenItem = ContextUtilities.getAttributeToken(completionContext.getCurrentToken());
        if (tokenItem == null) {
            return;
        }
        String string = tokenItem.getImage();
        if (!ContextUtilities.isPNamespaceName(completionContext.getDocumentContext(), string)) {
            return;
        }
        if (!string.endsWith("-ref")) {
            return;
        }
        BeansRefCompletor beansRefCompletor = new BeansRefCompletor(true, completionContext.getCaretOffset());
        SpringCompletionResult springCompletionResult = beansRefCompletor.complete(completionContext);
        for (SpringXMLConfigCompletionItem springXMLConfigCompletionItem : springCompletionResult.getItems()) {
            this.addCacheItem(springXMLConfigCompletionItem);
        }
    }

    @Override
    public boolean canFilter(CompletionContext completionContext) {
        return CompletorUtils.canFilter(completionContext.getDocument(), this.getInvocationOffset(), completionContext.getCaretOffset(), this.getAnchorOffset(), CompletorUtils.BEAN_NAME_ACCEPTOR);
    }

    @Override
    protected List<SpringXMLConfigCompletionItem> doFilter(CompletionContext completionContext) {
        return CompletorUtils.filter(this.getCacheItems(), completionContext.getDocument(), this.getInvocationOffset(), completionContext.getCaretOffset(), this.getAnchorOffset());
    }
}

