/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.mapping.ejb;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public abstract class AbstractNameMapper {
    public static final int USER_DEFINED_KEY_CLASS = 1;
    public static final int PRIMARY_KEY_FIELD = 2;
    public static final int UNKNOWN_KEY_CLASS = 3;
    public static final String GENERATED_KEY_FIELD_NAME = "generatedPKField";
    public static final String GENERATED_VERSION_FIELD_PREFIX = "thisVersionFieldWasGeneratedByTheNameMapper";
    protected static final String GENERATED_CMR_FIELD_PREFIX = "thisRelationshipFieldWasGeneratedByTheNameMapper";

    protected abstract Map getGeneratedFieldsMap();

    protected abstract Map getInverseFieldsMap();

    public abstract boolean isEjbName(String var1);

    public abstract String getAbstractBeanClassForEjbName(String var1);

    public abstract String getKeyClassForEjbName(String var1);

    public String getKeyClassForPersistenceKeyClass(String className) {
        String ejbName = this.getEjbNameForPersistenceKeyClass(className);
        return ejbName != null ? this.getKeyClassForEjbName(ejbName) : null;
    }

    public String getEjbNameForPersistenceKeyClass(String className) {
        if (className.toUpperCase(Locale.ENGLISH).endsWith("OID")) {
            return this.getEjbNameForPersistenceClass(className.substring(0, className.length() - 4));
        }
        return null;
    }

    public abstract int getKeyClassTypeForEjbName(String var1);

    public abstract String getAbstractSchemaForEjbName(String var1);

    public abstract String getEjbNameForPersistenceClass(String var1);

    public abstract String getPersistenceClassForEjbName(String var1);

    public abstract boolean isLocalInterface(String var1);

    public String getPersistenceClassForLocalInterface(String className, String fieldName, String interfaceName) {
        if (this.isLocalInterface(interfaceName)) {
            String ejbName = this.getEjbNameForPersistenceClass(className);
            String ejbField = this.getEjbFieldForPersistenceField(className, fieldName);
            return this.getPersistenceClassForEjbName(this.getEjbNameForLocalInterface(ejbName, ejbField, interfaceName));
        }
        return null;
    }

    public abstract String getEjbNameForLocalInterface(String var1, String var2, String var3);

    public abstract String getLocalInterfaceForEjbName(String var1);

    public abstract boolean isRemoteInterface(String var1);

    public String getPersistenceClassForRemoteInterface(String className, String fieldName, String interfaceName) {
        if (this.isRemoteInterface(interfaceName)) {
            String ejbName = this.getEjbNameForPersistenceClass(className);
            String ejbField = this.getEjbFieldForPersistenceField(className, fieldName);
            return this.getPersistenceClassForEjbName(this.getEjbNameForRemoteInterface(ejbName, ejbField, interfaceName));
        }
        return null;
    }

    public abstract String getEjbNameForRemoteInterface(String var1, String var2, String var3);

    public abstract String getRemoteInterfaceForEjbName(String var1);

    public abstract String getEjbFieldForPersistenceField(String var1, String var2);

    public abstract String getPersistenceFieldForEjbField(String var1, String var2);

    public boolean isGeneratedField(String name, String fieldName) {
        return this.isGeneratedEjbRelationship(name, fieldName) || fieldName.equals(GENERATED_KEY_FIELD_NAME) || fieldName.startsWith(GENERATED_VERSION_FIELD_PREFIX);
    }

    public boolean isGeneratedEjbRelationship(String name, String fieldName) {
        return this.getGeneratedFieldsMap().keySet().contains(Arrays.asList(name, fieldName));
    }

    public List getGeneratedRelationshipsForEjbName(String name) {
        Map generatedFieldsMap = this.getGeneratedFieldsMap();
        Iterator iterator = generatedFieldsMap.keySet().iterator();
        ArrayList returnList = new ArrayList();
        while (iterator.hasNext()) {
            List nextField = (List)iterator.next();
            if (!nextField.get(0).equals(name)) continue;
            returnList.add(nextField.get(1));
        }
        return returnList;
    }

    public String[] getGeneratedFieldForEjbField(String name, String fieldName) {
        List field = (List)this.getInverseFieldsMap().get(Arrays.asList(name, fieldName));
        return field != null ? field.toArray(new String[2]) : null;
    }

    public String[] getEjbFieldForGeneratedField(String name, String fieldName) {
        List field = (List)this.getGeneratedFieldsMap().get(Arrays.asList(name, fieldName));
        return field != null ? field.toArray(new String[2]) : null;
    }
}

