/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.tax;

import java.beans.PropertyChangeListener;
import org.netbeans.tax.CannotMergeException;
import org.netbeans.tax.ReadOnlyException;
import org.netbeans.tax.TreeAttribute;
import org.netbeans.tax.TreeChild;
import org.netbeans.tax.TreeElement;
import org.netbeans.tax.TreeParentNode;
import org.netbeans.tax.Util;
import org.netbeans.tax.event.TreeEvent;
import org.netbeans.tax.event.TreeEventChangeSupport;
import org.netbeans.tax.event.TreeEventManager;
import org.netbeans.tax.event.TreeEventModel;

public abstract class TreeObject
implements TreeEventModel {
    public static final String PROP_READ_ONLY = "readOnly";
    private boolean readOnly;
    private transient TreeEventChangeSupport eventChangeSupport;

    protected TreeObject() {
        this.readOnly = false;
        this.eventChangeSupport = null;
    }

    protected TreeObject(TreeObject treeObject) {
        this.readOnly = treeObject.readOnly;
        this.eventChangeSupport = null;
    }

    public abstract Object clone();

    protected final boolean isInstance(Object object) {
        return this.getClass().isInstance(object);
    }

    public abstract boolean isInContext();

    public abstract void removeFromContext() throws ReadOnlyException;

    public boolean equals(Object object) {
        return super.equals(object);
    }

    public boolean equals(Object object, boolean bl) {
        if (!this.isInstance(object)) {
            return false;
        }
        TreeObject treeObject = (TreeObject)object;
        return this.readOnly == treeObject.readOnly;
    }

    public void merge(TreeObject treeObject) throws CannotMergeException {
        if (treeObject == this) {
            return;
        }
        this.checkMergeObject(treeObject);
        TreeObject treeObject2 = treeObject;
        this.setReadOnly(treeObject2.isReadOnly());
    }

    protected final void checkMergeObject(TreeObject treeObject) throws CannotMergeException {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("TreeObject::checkMergeObject: this        = " + this);
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("          ::checkMergeObject: treeObject  = " + treeObject);
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("            checkMergeObject: isSameClass ? " + this.isInstance(treeObject));
        }
        if (treeObject == null || !this.isInstance(treeObject)) {
            throw new CannotMergeException(treeObject);
        }
    }

    public final boolean isReadOnly() {
        return this.readOnly;
    }

    protected void setReadOnly(boolean bl) {
        if (this.readOnly == bl) {
            return;
        }
        boolean bl2 = this.readOnly;
        this.readOnly = bl;
        this.firePropertyChange(this.getEventChangeSupport().createEvent(PROP_READ_ONLY, bl2 ? Boolean.TRUE : Boolean.FALSE, bl ? Boolean.TRUE : Boolean.FALSE));
    }

    protected final void checkReadOnly() throws ReadOnlyException {
        if (this.readOnly) {
            throw new ReadOnlyException(this);
        }
    }

    protected final TreeEventChangeSupport getEventChangeSupport() {
        if (this.eventChangeSupport == null) {
            this.eventChangeSupport = new TreeEventChangeSupport(this);
        }
        return this.eventChangeSupport;
    }

    public abstract TreeEventManager getEventManager();

    public final void addReadonlyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getEventChangeSupport().addPropertyChangeListener(PROP_READ_ONLY, propertyChangeListener);
    }

    public final void removeReadonlyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getEventChangeSupport().removePropertyChangeListener(PROP_READ_ONLY, propertyChangeListener);
    }

    public final void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("Tree " + this + "attached listener" + propertyChangeListener);
        }
        this.getEventChangeSupport().addPropertyChangeListener(propertyChangeListener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getEventChangeSupport().removePropertyChangeListener(propertyChangeListener);
    }

    protected final void firePropertyChange(TreeEvent treeEvent) {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("TreeObject firing " + treeEvent);
        }
        this.getEventChangeSupport().firePropertyChange(treeEvent);
        this.bubblePropertyChange(treeEvent);
    }

    public final void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.getEventChangeSupport().addPropertyChangeListener(string, propertyChangeListener);
    }

    public final void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.getEventChangeSupport().removePropertyChangeListener(string, propertyChangeListener);
    }

    public final boolean hasPropertyChangeListeners(String string) {
        return this.getEventChangeSupport().hasPropertyChangeListeners(string);
    }

    protected final void firePropertyChange(String string, Object object, Object object2) {
        this.firePropertyChange(this.getEventChangeSupport().createEvent(string, object, object2));
    }

    protected final void bubblePropertyChange(TreeEvent treeEvent) {
        TreeObject treeObject;
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("\nTreeObject [ " + this + " ]::bubblePropertyChange: origEvt = " + treeEvent.getPropertyName());
        }
        if ((treeObject = (TreeObject)treeEvent.getSource()) instanceof TreeAttribute) {
            TreeAttribute treeAttribute = (TreeAttribute)treeObject;
            TreeElement treeElement = treeAttribute.getOwnerElement();
            if (treeElement != null) {
                treeElement.firePropertyChange("attributes", treeAttribute, null);
            }
        } else if (treeObject instanceof TreeChild) {
            while (treeObject != null) {
                TreeChild treeChild = (TreeChild)treeObject;
                TreeParentNode treeParentNode = treeChild.getParentNode();
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("    ::bubblePropertyChange::parentNode = " + treeParentNode);
                }
                if (treeParentNode != null) {
                    treeParentNode.getEventChangeSupport().firePropertyChange(treeEvent.createBubbling(treeParentNode));
                }
                treeObject = treeParentNode;
            }
        }
    }

    public final String listListeners() {
        return this.getEventChangeSupport().listListeners();
    }
}

