/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.tax;

import java.util.Collection;
import org.netbeans.tax.CannotMergeException;
import org.netbeans.tax.InvalidArgumentException;
import org.netbeans.tax.ReadOnlyException;
import org.netbeans.tax.TreeNodeDecl;
import org.netbeans.tax.TreeObject;
import org.netbeans.tax.TreeUtilities;
import org.netbeans.tax.Util;
import org.netbeans.tax.decl.EMPTYType;
import org.netbeans.tax.decl.parser.ContentSpecParser;
import org.netbeans.tax.decl.parser.ParserReader;
import org.netbeans.tax.spec.ConditionalSection;
import org.netbeans.tax.spec.DTD;
import org.netbeans.tax.spec.DocumentType;
import org.netbeans.tax.spec.ParameterEntityReference;

public class TreeElementDecl
extends TreeNodeDecl
implements DTD.Child,
ParameterEntityReference.Child,
DocumentType.Child,
ConditionalSection.Child {
    public static final String PROP_NAME = "name";
    public static final String PROP_CONTENT_TYPE = "contentType";
    private String name;
    private ContentType contentType;

    public TreeElementDecl(String string, ContentType contentType) throws InvalidArgumentException {
        this.checkName(string);
        this.checkContentType(contentType);
        this.name = string;
        this.contentType = contentType;
        this.contentType.setNodeDecl(this);
    }

    protected TreeElementDecl(TreeElementDecl treeElementDecl) {
        super(treeElementDecl);
        this.name = treeElementDecl.name;
        this.contentType = (ContentType)treeElementDecl.contentType.clone();
    }

    public Object clone() {
        return new TreeElementDecl(this);
    }

    public boolean equals(Object object, boolean bl) {
        if (!super.equals(object, bl)) {
            return false;
        }
        TreeElementDecl treeElementDecl = (TreeElementDecl)object;
        if (!Util.equals(this.getName(), treeElementDecl.getName())) {
            return false;
        }
        return Util.equals(this.contentType, treeElementDecl.contentType);
    }

    public void merge(TreeObject treeObject) throws CannotMergeException {
        super.merge(treeObject);
        TreeElementDecl treeElementDecl = (TreeElementDecl)treeObject;
        this.setNameImpl(treeElementDecl.getName());
        this.setContentTypeImpl(treeElementDecl.getContentType());
    }

    public final String getName() {
        return this.name;
    }

    private final void setNameImpl(String string) {
        String string2 = this.name;
        this.name = string;
        this.firePropertyChange(PROP_NAME, string2, string);
    }

    public final void setName(String string) throws ReadOnlyException, InvalidArgumentException {
        if (Util.equals(this.name, string)) {
            return;
        }
        this.checkReadOnly();
        this.checkName(string);
        this.setNameImpl(string);
    }

    protected final void checkName(String string) throws InvalidArgumentException {
        TreeUtilities.checkElementDeclName(string);
    }

    public final ContentType getContentType() {
        return this.contentType;
    }

    private final void setContentTypeImpl(ContentType contentType) {
        ContentType contentType2 = this.contentType;
        this.contentType = contentType;
        this.firePropertyChange(PROP_CONTENT_TYPE, contentType2, contentType);
    }

    public final void setContentType(ContentType contentType) throws ReadOnlyException, InvalidArgumentException {
        if (Util.equals(this.contentType, contentType)) {
            return;
        }
        this.checkReadOnly();
        this.checkContentType(contentType);
        this.setContentTypeImpl(contentType);
    }

    public final void setContentType(String string) throws ReadOnlyException, InvalidArgumentException {
        this.setContentType(new ContentSpecParser().parseModel(new ParserReader(string)));
    }

    protected final void checkContentType(ContentType contentType) throws InvalidArgumentException {
        TreeUtilities.checkElementDeclContentType(contentType);
    }

    public boolean isMixed() {
        return this.getContentType().isMixed();
    }

    public boolean isEmpty() {
        return !this.allowText() && !this.allowElements();
    }

    public boolean allowText() {
        return this.getContentType().allowText();
    }

    public boolean allowElements() {
        return this.getContentType().allowElements();
    }

    public Collection getAttributeDefs() {
        if (this.getOwnerDTD() == null) {
            return null;
        }
        return this.getOwnerDTD().getAttributeDeclarations(this.getName());
    }

    public static abstract class ContentType
    extends TreeNodeDecl.Content
    implements Comparable {
        private String multiplicity;
        private int index;
        private static int counter = 0;

        protected ContentType(TreeElementDecl treeElementDecl) {
            super(treeElementDecl);
            this.multiplicity = new String();
            this.index = counter++;
        }

        protected ContentType() {
            this((TreeElementDecl)null);
        }

        protected ContentType(ContentType contentType) {
            super(contentType);
            this.multiplicity = contentType.multiplicity;
            this.index = counter++;
        }

        public boolean equals(Object object, boolean bl) {
            if (!super.equals(object, bl)) {
                return false;
            }
            ContentType contentType = (ContentType)object;
            if (this.index != contentType.index) {
                return false;
            }
            return Util.equals(this.getMultiplicity(), contentType.getMultiplicity());
        }

        public void merge(TreeObject treeObject) throws CannotMergeException {
            super.merge(treeObject);
            ContentType contentType = (ContentType)treeObject;
            this.index = contentType.index;
            this.setMultiplicity(contentType.getMultiplicity());
        }

        public final void removeFromContext() throws ReadOnlyException {
            if (this.isInContext()) {
                this.getOwnerElementDecl().setContentTypeImpl(new EMPTYType());
            }
        }

        public final TreeElementDecl getOwnerElementDecl() {
            return (TreeElementDecl)this.getNodeDecl();
        }

        public void setMultiplicity(char c) {
            this.multiplicity = new String(new char[]{c});
        }

        public void setMultiplicity(String string) {
            this.multiplicity = string;
        }

        public void addMultiplicity(String string) {
            if (this.multiplicity.equals(string)) {
                return;
            }
            if ("".equals(this.multiplicity)) {
                this.multiplicity = string;
            } else if (!"".equals(string)) {
                this.multiplicity = "*";
            }
        }

        public String getMultiplicity() {
            return this.multiplicity;
        }

        public boolean isMixed() {
            return this.allowText() && this.allowElements();
        }

        public abstract boolean allowElements();

        public abstract boolean allowText();

        public abstract String toString();

        public int compareTo(Object object) {
            if (this.equals(object)) {
                return 0;
            }
            ContentType contentType = (ContentType)object;
            return this.index - contentType.index;
        }
    }
}

