/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mobility.antext;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.taskdefs.Expand;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.PatternSet;
import org.apache.tools.ant.types.Reference;
import org.netbeans.mobility.antext.Bundle;

public class ExtractTask
extends Task {
    private Path classPath;
    private Path exClassPath;
    private File dir;
    private boolean excludeManifest = false;

    public void execute() throws BuildException {
        Set<Object> set;
        if (this.classPath == null) {
            throw new BuildException(Bundle.getMessage("ERR_MissingAttr", "classPath"));
        }
        if (this.dir == null) {
            throw new BuildException(Bundle.getMessage("ERR_MissingAttr", "dir"));
        }
        if (!this.dir.exists() || !this.dir.isDirectory()) {
            throw new BuildException(Bundle.getMessage("ERR_Extract_InvalidDir", this.dir != null ? this.dir.getAbsolutePath() : null));
        }
        String[] stringArray = this.classPath.list();
        Set<Object> set2 = set = this.exClassPath == null ? Collections.EMPTY_SET : new HashSet<String>(Arrays.asList(this.exClassPath.list()));
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (set.contains(stringArray[i])) continue;
                File file = new File(stringArray[i]);
                this.log(Bundle.getMessage("MSG_Extract_ProcessingPath", file.getAbsolutePath()), 3);
                if (!file.exists()) {
                    this.log(Bundle.getMessage("WARN_Extract_IgnoringPath", file.getAbsolutePath()), 1);
                    continue;
                }
                if (file.isFile()) {
                    String string = file.getName().toLowerCase();
                    if (!string.endsWith(".zip") && !string.endsWith(".jar")) {
                        this.log(Bundle.getMessage("WARN_Extract_IgnoringPath", file.getAbsolutePath()), 1);
                        continue;
                    }
                    this.extractZip(file, this.dir);
                    continue;
                }
                if (!file.isDirectory()) continue;
                this.copyDir(file, this.dir);
            }
        }
    }

    private void extractZip(File file, File file2) throws BuildException {
        Expand expand = new Expand();
        expand.setProject(this.getProject());
        expand.setOverwrite(false);
        if (this.excludeManifest) {
            PatternSet patternSet = new PatternSet();
            patternSet.setExcludes("META-INF,META-INF/MANIFEST.MF");
            expand.addPatternset(patternSet);
        }
        expand.setSrc(file);
        expand.setDest(file2);
        expand.execute();
    }

    private void copyDir(File file, File file2) throws BuildException {
        Copy copy = new Copy();
        copy.setProject(this.getProject());
        copy.setOverwrite(false);
        FileSet fileSet = new FileSet();
        fileSet.setDir(file);
        copy.addFileset(fileSet);
        copy.setTodir(file2);
        copy.execute();
    }

    public void setClassPath(Path path) {
        this.createClassPath().append(path);
    }

    public Path createClassPath() {
        if (this.classPath == null) {
            this.classPath = new Path(this.getProject());
        }
        return this.classPath.createPath();
    }

    public void setExcludeClassPath(Path path) {
        this.createExcludeClassPath().append(path);
    }

    public Path createExcludeClassPath() {
        if (this.exClassPath == null) {
            this.exClassPath = new Path(this.getProject());
        }
        return this.exClassPath.createPath();
    }

    public void setClassPathRef(Reference reference) {
        this.createClassPath().setRefid(reference);
    }

    public void setExcludeClassPathRef(Reference reference) {
        this.createExcludeClassPath().setRefid(reference);
    }

    public void setDir(File file) {
        this.dir = file;
    }

    public void setExcludeManifest(boolean bl) {
        this.excludeManifest = bl;
    }
}

