/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.modules.ruby.rubyproject.RubyBaseProject;
import org.netbeans.modules.ruby.rubyproject.RubyProject;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RubyProjectUtil {
    private RubyProjectUtil() {
    }

    public static Object getEvaluatedProperty(Project project, String string) {
        if (string == null) {
            return null;
        }
        RubyProject rubyProject = (RubyProject)project.getLookup().lookup(RubyProject.class);
        if (rubyProject != null) {
            return rubyProject.evaluator().evaluate(string);
        }
        return null;
    }

    public static boolean hasMainMethod(FileObject fileObject) {
        return true;
    }

    public static List<String> getMainClasses(FileObject[] fileObjectArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < fileObjectArray.length; ++i) {
            RubyProjectUtil.getMainClasses(fileObjectArray[i], arrayList);
        }
        return arrayList;
    }

    public static void getAllScripts(String string, FileObject fileObject, List<String> list) {
        FileObject[] fileObjectArray = fileObject.getChildren();
        if (!"".equals(string)) {
            string = string + "/";
        }
        for (int i = 0; i < fileObjectArray.length; ++i) {
            if (fileObjectArray[i].isData() && fileObjectArray[i].getMIMEType().equals("text/x-ruby")) {
                list.add(string + fileObjectArray[i].getNameExt());
            }
            if (!fileObjectArray[i].isFolder()) continue;
            RubyProjectUtil.getAllScripts(string + fileObjectArray[i].getNameExt(), fileObjectArray[i], list);
        }
    }

    private static void getMainClasses(FileObject fileObject, List<String> list) {
        RubyProjectUtil.getAllScripts("", fileObject, list);
    }

    public static boolean isMainClass(String string, FileObject[] fileObjectArray) {
        if (fileObjectArray == null) {
            return false;
        }
        for (FileObject fileObject : fileObjectArray) {
            if (fileObject.getFileObject(string) == null) continue;
            return true;
        }
        return false;
    }

    public static URL getRootURL(File file, String string) throws MalformedURLException {
        URL uRL = file.toURI().toURL();
        if (FileUtil.isArchiveFile((URL)uRL)) {
            uRL = FileUtil.getArchiveRoot((URL)uRL);
        } else if (!file.exists()) {
            uRL = new URL(uRL.toExternalForm() + "/");
        }
        if (string != null) {
            assert (string.endsWith("/"));
            uRL = new URL(uRL.toExternalForm() + string);
        }
        return uRL;
    }

    public static String getLoadPath(Project project) {
        RubyBaseProject rubyBaseProject = (RubyBaseProject)project.getLookup().lookup(RubyBaseProject.class);
        assert (rubyBaseProject != null) : "No RubyBaseProject found in the project lookup. Project: " + project;
        FileObject[] fileObjectArray = rubyBaseProject.getSourceRootFiles();
        FileObject[] fileObjectArray2 = rubyBaseProject.getTestSourceRootFiles();
        StringBuilder stringBuilder = new StringBuilder();
        for (FileObject fileObject : fileObjectArray) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append("-I\"");
            stringBuilder.append(FileUtil.toFile((FileObject)fileObject).getAbsoluteFile());
            stringBuilder.append("\"");
        }
        for (FileObject fileObject : fileObjectArray2) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append("-I\"");
            stringBuilder.append(FileUtil.toFile((FileObject)fileObject).getAbsoluteFile());
            stringBuilder.append("\"");
        }
        return stringBuilder.toString();
    }
}

