/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.netbeans.api.project.Project;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.rubyproject.RakeParameters;
import org.netbeans.modules.ruby.rubyproject.rake.RakeTask;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Migrations {
    private static final Logger LOGGER = Logger.getLogger(Migrations.class.getName());
    private static final Pattern SEQ_PATTERN = Pattern.compile("^\\d\\d\\d_.*");
    private static final Pattern TIMESTAMP_PATTERN = Pattern.compile("^\\d\\d\\d\\d\\d\\d\\d\\d\\d\\d\\d\\d\\d\\d_.*");
    private static final List<String> MIGRATE_TASKS = Arrays.asList("db:migrate", "db:migrate:down", "db:migrate:up");

    private Migrations() {
    }

    static boolean isMigrateTask(RakeTask rakeTask) {
        if (rakeTask == null) {
            return false;
        }
        return MIGRATE_TASKS.contains(rakeTask.getTask());
    }

    public static List<Migration> getMigrations(Project project) {
        FileObject fileObject = project.getProjectDirectory();
        FileObject fileObject2 = fileObject.getFileObject("db/migrate");
        if (fileObject2 == null) {
            return Collections.emptyList();
        }
        ArrayList<Migration> arrayList = new ArrayList<Migration>();
        for (FileObject fileObject3 : fileObject2.getChildren()) {
            String string = fileObject3.getName();
            if (!fileObject3.getMIMEType().equals("text/x-ruby")) continue;
            Long l = Migrations.getMigrationVersion(string);
            String string2 = Migrations.getMigrationDescription(string);
            if (l != null && string2 != null) {
                arrayList.add(new Migration(l, string2));
                continue;
            }
            LOGGER.finer("Could not parse version and description for: " + string);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    private static boolean isSequentialMigration(String string) {
        return SEQ_PATTERN.matcher(string).matches();
    }

    private static boolean isTimestampMigration(String string) {
        return TIMESTAMP_PATTERN.matcher(string).matches();
    }

    public static Long getMigrationVersion(String string) {
        if (Migrations.isSequentialMigration(string)) {
            return Long.parseLong(string.substring(0, 3));
        }
        if (Migrations.isTimestampMigration(string)) {
            return Long.parseLong(string.substring(0, 14));
        }
        return null;
    }

    public static String getMigrationDescription(String string) {
        if (Migrations.isSequentialMigration(string)) {
            return RubyUtils.underlinedNameToCamel((String)string.substring(4));
        }
        if (Migrations.isTimestampMigration(string)) {
            return RubyUtils.underlinedNameToCamel((String)string.substring(15));
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Migration
    implements RakeParameters.RakeParameter,
    Comparable<Migration> {
        private final Long version;
        private final String description;

        public Migration(Long l, String string) {
            this.version = l;
            this.description = string;
        }

        public String getDescription() {
            return this.description;
        }

        public Long getVersion() {
            return this.version;
        }

        @Override
        public String toRakeParam() {
            return "VERSION=" + this.getVersion();
        }

        private String getDisplayName() {
            return this.toRakeParam() + " (" + this.getDescription() + ")";
        }

        @Override
        public int compareTo(Migration migration) {
            return this.getVersion().compareTo(migration.getVersion());
        }

        public String toString() {
            return this.getDisplayName();
        }
    }
}

