/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.csl.core;

import java.io.IOException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledDocument;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.modules.csl.core.GsfDataNode;
import org.netbeans.modules.csl.core.Language;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.PrintCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.loaders.SaveAsCapable;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DataEditorSupport;
import org.openide.util.Lookup;
import org.openide.windows.CloneableOpenSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GsfDataObject
extends MultiDataObject {
    private static Language templateLanguage;
    private GenericEditorSupport jes;
    private final Language language;

    public GsfDataObject(FileObject fileObject, MultiFileLoader multiFileLoader, Language language) throws DataObjectExistsException {
        super(fileObject, multiFileLoader);
        if (language == null) {
            language = templateLanguage;
        }
        this.language = language;
        this.getCookieSet().assign(SaveAsCapable.class, (Object[])new SaveAsCapable[]{new SaveAsCapable(){

            public void saveAs(FileObject fileObject, String string) throws IOException {
                GsfDataObject.this.createEditorSupport().saveAs(fileObject, string);
            }
        }});
        this.getCookieSet().add((Node.Cookie)this.createEditorSupport());
    }

    public Node createNodeDelegate() {
        return new GsfDataNode(this, this.language);
    }

    public Lookup getLookup() {
        return this.getCookieSet().getLookup();
    }

    public <T extends Node.Cookie> T getCookie(Class<T> clazz) {
        return (T)this.getCookieSet().getCookie(clazz);
    }

    protected DataObject handleCopyRename(DataFolder dataFolder, String string, String string2) throws IOException {
        FileObject fileObject = this.getPrimaryEntry().copyRename(dataFolder.getPrimaryFile(), string, string2);
        DataObject dataObject = DataObject.find((FileObject)fileObject);
        return dataObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataObject handleCreateFromTemplate(DataFolder dataFolder, String string) throws IOException {
        if (string == null && this.language != null && this.language.getGsfLanguage().getPreferredExtension() != null) {
            string = FileUtil.findFreeFileName((FileObject)dataFolder.getPrimaryFile(), (String)this.getPrimaryFile().getName(), (String)this.language.getGsfLanguage().getPreferredExtension());
        }
        try {
            templateLanguage = this.language;
            DataObject dataObject = super.handleCreateFromTemplate(dataFolder, string);
            FileObject fileObject = dataObject.getPrimaryFile();
            assert (fileObject != null);
            DataObject dataObject2 = dataObject;
            return dataObject2;
        }
        finally {
            templateLanguage = null;
        }
    }

    private synchronized GenericEditorSupport createEditorSupport() {
        if (this.jes == null) {
            this.jes = new GenericEditorSupport(this, this.language);
        }
        return this.jes;
    }

    public static final class GenericEditorSupport
    extends DataEditorSupport
    implements OpenCookie,
    EditCookie,
    EditorCookie,
    PrintCookie,
    EditorCookie.Observable {
        private Language language;

        public GenericEditorSupport(GsfDataObject gsfDataObject, Language language) {
            super((DataObject)gsfDataObject, (CloneableEditorSupport.Env)new Environment(gsfDataObject));
            this.setMIMEType(language.getMimeType());
            this.language = language;
        }

        protected boolean notifyModified() {
            if (!super.notifyModified()) {
                return false;
            }
            ((Environment)this.env).addSaveCookie();
            return true;
        }

        protected void notifyUnmodified() {
            super.notifyUnmodified();
            ((Environment)this.env).removeSaveCookie();
        }

        public boolean close(boolean bl) {
            return super.close(bl);
        }

        protected StyledDocument createStyledDocument(EditorKit editorKit) {
            StyledDocument styledDocument = super.createStyledDocument(editorKit);
            InputAttributes inputAttributes = new InputAttributes();
            FileObject fileObject = NbEditorUtilities.getFileObject((Document)styledDocument);
            inputAttributes.setValue(this.language.getGsfLanguage().getLexerLanguage(), FileObject.class, (Object)fileObject, false);
            styledDocument.putProperty(InputAttributes.class, inputAttributes);
            return styledDocument;
        }

        private static class Environment
        extends DataEditorSupport.Env {
            private static final long serialVersionUID = -1L;
            private transient SaveSupport saveCookie = null;

            public Environment(GsfDataObject gsfDataObject) {
                super((DataObject)gsfDataObject);
            }

            protected FileObject getFile() {
                return this.getDataObject().getPrimaryFile();
            }

            protected FileLock takeLock() throws IOException {
                return ((MultiDataObject)this.getDataObject()).getPrimaryEntry().takeLock();
            }

            public CloneableOpenSupport findCloneableOpenSupport() {
                return (CloneableEditorSupport)((GsfDataObject)this.getDataObject()).getCookie(EditorCookie.class);
            }

            public void addSaveCookie() {
                GsfDataObject gsfDataObject = (GsfDataObject)this.getDataObject();
                if (gsfDataObject.getCookie(SaveCookie.class) == null) {
                    if (this.saveCookie == null) {
                        this.saveCookie = new SaveSupport();
                    }
                    gsfDataObject.getCookieSet().add((Node.Cookie)this.saveCookie);
                    gsfDataObject.setModified(true);
                }
            }

            public void removeSaveCookie() {
                GsfDataObject gsfDataObject = (GsfDataObject)this.getDataObject();
                if (gsfDataObject.getCookie(SaveCookie.class) != null) {
                    gsfDataObject.getCookieSet().remove((Node.Cookie)this.saveCookie);
                    gsfDataObject.setModified(false);
                }
            }

            private class SaveSupport
            implements SaveCookie {
                private SaveSupport() {
                }

                public void save() throws IOException {
                    ((GenericEditorSupport)Environment.this.findCloneableOpenSupport()).saveDocument();
                    Environment.this.getDataObject().setModified(false);
                }
            }
        }
    }
}

