/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.nb.javascript;

import org.mozilla.nb.javascript.Context;
import org.mozilla.nb.javascript.Function;
import org.mozilla.nb.javascript.IdFunctionObject;
import org.mozilla.nb.javascript.IdScriptableObject;
import org.mozilla.nb.javascript.NativeJavaClass;
import org.mozilla.nb.javascript.NativeJavaPackage;
import org.mozilla.nb.javascript.ObjArray;
import org.mozilla.nb.javascript.Scriptable;
import org.mozilla.nb.javascript.Undefined;

public class ImporterTopLevel
extends IdScriptableObject {
    static final long serialVersionUID = -9095380847465315412L;
    private static final Object IMPORTER_TAG = "Importer";
    private static final int Id_constructor = 1;
    private static final int Id_importClass = 2;
    private static final int Id_importPackage = 3;
    private static final int MAX_PROTOTYPE_ID = 3;
    private ObjArray importedPackages = new ObjArray();
    private boolean topScopeFlag;

    public ImporterTopLevel() {
    }

    public ImporterTopLevel(Context context) {
        this(context, false);
    }

    public ImporterTopLevel(Context context, boolean bl) {
        this.initStandardObjects(context, bl);
    }

    public String getClassName() {
        return this.topScopeFlag ? "global" : "JavaImporter";
    }

    public static void init(Context context, Scriptable scriptable, boolean bl) {
        ImporterTopLevel importerTopLevel = new ImporterTopLevel();
        importerTopLevel.exportAsJSClass(3, scriptable, bl);
    }

    public void initStandardObjects(Context context, boolean bl) {
        context.initStandardObjects(this, bl);
        this.topScopeFlag = true;
        IdFunctionObject idFunctionObject = this.exportAsJSClass(3, this, false);
        if (bl) {
            idFunctionObject.sealObject();
        }
        this.delete("constructor");
    }

    public boolean has(String string, Scriptable scriptable) {
        return super.has(string, scriptable) || this.getPackageProperty(string, scriptable) != NOT_FOUND;
    }

    public Object get(String string, Scriptable scriptable) {
        Object object = super.get(string, scriptable);
        if (object != NOT_FOUND) {
            return object;
        }
        object = this.getPackageProperty(string, scriptable);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getPackageProperty(String string, Scriptable scriptable) {
        Object[] objectArray;
        Object object = NOT_FOUND;
        ObjArray objArray = this.importedPackages;
        synchronized (objArray) {
            objectArray = this.importedPackages.toArray();
        }
        for (int i = 0; i < objectArray.length; ++i) {
            NativeJavaPackage nativeJavaPackage = (NativeJavaPackage)objectArray[i];
            Object object2 = nativeJavaPackage.getPkgProperty(string, scriptable, false);
            if (object2 == null || object2 instanceof NativeJavaPackage) continue;
            if (object == NOT_FOUND) {
                object = object2;
                continue;
            }
            throw Context.reportRuntimeError2("msg.ambig.import", object.toString(), object2.toString());
        }
        return object;
    }

    public void importPackage(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        this.js_importPackage(objectArray);
    }

    private Object js_construct(Scriptable scriptable, Object[] objectArray) {
        ImporterTopLevel importerTopLevel = new ImporterTopLevel();
        for (int i = 0; i != objectArray.length; ++i) {
            Object object = objectArray[i];
            if (object instanceof NativeJavaClass) {
                importerTopLevel.importClass((NativeJavaClass)object);
                continue;
            }
            if (object instanceof NativeJavaPackage) {
                importerTopLevel.importPackage((NativeJavaPackage)object);
                continue;
            }
            throw Context.reportRuntimeError1("msg.not.class.not.pkg", Context.toString(object));
        }
        importerTopLevel.setParentScope(scriptable);
        importerTopLevel.setPrototype(this);
        return importerTopLevel;
    }

    private Object js_importClass(Object[] objectArray) {
        for (int i = 0; i != objectArray.length; ++i) {
            Object object = objectArray[i];
            if (!(object instanceof NativeJavaClass)) {
                throw Context.reportRuntimeError1("msg.not.class", Context.toString(object));
            }
            this.importClass((NativeJavaClass)object);
        }
        return Undefined.instance;
    }

    private Object js_importPackage(Object[] objectArray) {
        for (int i = 0; i != objectArray.length; ++i) {
            Object object = objectArray[i];
            if (!(object instanceof NativeJavaPackage)) {
                throw Context.reportRuntimeError1("msg.not.pkg", Context.toString(object));
            }
            this.importPackage((NativeJavaPackage)object);
        }
        return Undefined.instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importPackage(NativeJavaPackage nativeJavaPackage) {
        if (nativeJavaPackage == null) {
            return;
        }
        ObjArray objArray = this.importedPackages;
        synchronized (objArray) {
            for (int i = 0; i != this.importedPackages.size(); ++i) {
                if (!nativeJavaPackage.equals(this.importedPackages.get(i))) continue;
                return;
            }
            this.importedPackages.add(nativeJavaPackage);
        }
    }

    private void importClass(NativeJavaClass nativeJavaClass) {
        String string = nativeJavaClass.getClassObject().getName();
        String string2 = string.substring(string.lastIndexOf(46) + 1);
        Object object = this.get(string2, (Scriptable)this);
        if (object != NOT_FOUND && object != nativeJavaClass) {
            throw Context.reportRuntimeError1("msg.prop.defined", string2);
        }
        this.put(string2, (Scriptable)this, (Object)nativeJavaClass);
    }

    protected void initPrototypeId(int n) {
        String string;
        int n2;
        switch (n) {
            case 1: {
                n2 = 0;
                string = "constructor";
                break;
            }
            case 2: {
                n2 = 1;
                string = "importClass";
                break;
            }
            case 3: {
                n2 = 1;
                string = "importPackage";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(n));
            }
        }
        this.initPrototypeMethod(IMPORTER_TAG, n, string, n2);
    }

    public Object execIdCall(IdFunctionObject idFunctionObject, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (!idFunctionObject.hasTag(IMPORTER_TAG)) {
            return super.execIdCall(idFunctionObject, context, scriptable, scriptable2, objectArray);
        }
        int n = idFunctionObject.methodId();
        switch (n) {
            case 1: {
                return this.js_construct(scriptable, objectArray);
            }
            case 2: {
                return this.realThis(scriptable2, idFunctionObject).js_importClass(objectArray);
            }
            case 3: {
                return this.realThis(scriptable2, idFunctionObject).js_importPackage(objectArray);
            }
        }
        throw new IllegalArgumentException(String.valueOf(n));
    }

    private ImporterTopLevel realThis(Scriptable scriptable, IdFunctionObject idFunctionObject) {
        if (this.topScopeFlag) {
            return this;
        }
        if (!(scriptable instanceof ImporterTopLevel)) {
            throw ImporterTopLevel.incompatibleCallError(idFunctionObject);
        }
        return (ImporterTopLevel)scriptable;
    }

    protected int findPrototypeId(String string) {
        int n;
        block6: {
            n = 0;
            String string2 = null;
            int n2 = string.length();
            if (n2 == 11) {
                char c = string.charAt(0);
                if (c == 'c') {
                    string2 = "constructor";
                    n = 1;
                } else if (c == 'i') {
                    string2 = "importClass";
                    n = 2;
                }
            } else if (n2 == 13) {
                string2 = "importPackage";
                n = 3;
            }
            if (string2 == null || string2 == string || string2.equals(string)) break block6;
            n = 0;
        }
        return n;
    }
}

