/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.model.services;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmInheritance;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.services.CsmInheritanceUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmTypeHierarchyResolver;
import org.netbeans.modules.cnd.modelutil.AntiLoop;
import org.netbeans.modules.cnd.utils.cache.CharSequenceKey;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CsmVirtualInfoQuery {
    private static final CsmVirtualInfoQuery EMPTY = new Empty();
    private static CsmVirtualInfoQuery defaultQuery;

    public abstract boolean isVirtual(CsmMethod var1);

    public abstract Collection<CsmMethod> getBaseDeclaration(CsmMethod var1);

    public abstract Collection<CsmMethod> getOverridenMethods(CsmMethod var1, boolean var2);

    protected CsmVirtualInfoQuery() {
    }

    public static CsmVirtualInfoQuery getDefault() {
        if (defaultQuery != null) {
            return defaultQuery;
        }
        defaultQuery = (CsmVirtualInfoQuery)Lookup.getDefault().lookup(CsmVirtualInfoQuery.class);
        return defaultQuery == null ? EMPTY : defaultQuery;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Empty
    extends CsmVirtualInfoQuery {
        private Empty() {
        }

        @Override
        public boolean isVirtual(CsmMethod csmMethod) {
            if (csmMethod.isVirtual()) {
                return true;
            }
            return this.processClass(csmMethod.getSignature(), csmMethod.getContainingClass(), new AntiLoop());
        }

        private boolean processClass(CharSequence charSequence, CsmClass csmClass, AntiLoop antiLoop) {
            if (csmClass == null || antiLoop.contains((CsmClassifier)csmClass)) {
                return false;
            }
            antiLoop.add((CsmClassifier)csmClass);
            for (CsmMember csmMember : csmClass.getMembers()) {
                CsmMethod csmMethod;
                if (!CsmKindUtilities.isMethod((CsmObject)csmMember) || CharSequenceKey.Comparator.compare(charSequence, (csmMethod = (CsmMethod)csmMember).getSignature()) != 0) continue;
                if (!csmMethod.isVirtual()) break;
                return true;
            }
            for (CsmMember csmMember : csmClass.getBaseClasses()) {
                if (!this.processClass(charSequence, CsmInheritanceUtilities.getCsmClass((CsmInheritance)csmMember), antiLoop)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Collection<CsmMethod> getBaseDeclaration(CsmMethod csmMethod) {
            HashSet<CharSequence> hashSet = new HashSet<CharSequence>();
            CharSequence charSequence = csmMethod.getSignature();
            CsmMethod csmMethod2 = this.processMethod(charSequence, csmMethod.getContainingClass(), hashSet);
            if (csmMethod2 != null) {
                CsmMethod csmMethod3 = csmMethod2;
                block0: while (csmMethod3 != null) {
                    csmMethod2 = csmMethod3;
                    CsmClass csmClass = csmMethod3.getContainingClass();
                    csmMethod3 = null;
                    if (csmClass == null) continue;
                    for (CsmInheritance csmInheritance : csmClass.getBaseClasses()) {
                        CsmMethod csmMethod4 = this.processMethod(charSequence, CsmInheritanceUtilities.getCsmClass(csmInheritance), hashSet);
                        if (csmMethod4 == null) continue;
                        csmMethod3 = csmMethod4;
                        continue block0;
                    }
                }
            }
            if (csmMethod2 == null) {
                return Collections.emptyList();
            }
            return Collections.singleton(csmMethod2);
        }

        private CsmMethod processMethod(CharSequence charSequence, CsmClass csmClass, Set<CharSequence> set) {
            CsmMethod csmMethod;
            if (csmClass == null || set.contains(csmClass.getQualifiedName())) {
                return null;
            }
            set.add(csmClass.getQualifiedName());
            for (CsmMember csmMember : csmClass.getMembers()) {
                if (!CsmKindUtilities.isMethod((CsmObject)csmMember) || CharSequenceKey.Comparator.compare(charSequence, (csmMethod = (CsmMethod)csmMember).getSignature()) != 0 || !csmMethod.isVirtual()) continue;
                return csmMethod;
            }
            for (CsmMember csmMember : csmClass.getBaseClasses()) {
                csmMethod = this.processMethod(charSequence, CsmInheritanceUtilities.getCsmClass((CsmInheritance)csmMember), set);
                if (csmMethod == null) continue;
                return csmMethod;
            }
            return null;
        }

        @Override
        public Collection<CsmMethod> getOverridenMethods(CsmMethod csmMethod, boolean bl) {
            CsmClass csmClass;
            Iterator<CsmMethod> iterator;
            HashSet<CsmMethod> hashSet = new HashSet<CsmMethod>();
            if (bl) {
                iterator = this.getBaseDeclaration(csmMethod).iterator();
                if (iterator.hasNext()) {
                    csmMethod = (CsmMethod)iterator.next();
                }
                hashSet.add(csmMethod);
            }
            if ((csmClass = csmMethod.getContainingClass()) != null) {
                iterator = csmMethod.getSignature();
                block0: for (CsmReference csmReference : CsmTypeHierarchyResolver.getDefault().getSubTypes(csmClass, false)) {
                    CsmClass csmClass2 = (CsmClass)csmReference.getOwner();
                    for (CsmMember csmMember : csmClass2.getMembers()) {
                        CsmMethod csmMethod2;
                        if (!CsmKindUtilities.isMethod((CsmObject)csmMember) || CharSequenceKey.Comparator.compare(iterator, (csmMethod2 = (CsmMethod)csmMember).getSignature()) != 0) continue;
                        hashSet.add(csmMethod2);
                        continue block0;
                    }
                }
            }
            return hashSet;
        }
    }
}

