/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.log;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.lib.cvsclient.ClientServices;
import org.netbeans.lib.cvsclient.command.BasicCommand;
import org.netbeans.lib.cvsclient.command.Builder;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.log.LogBuilder;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.request.ArgumentRequest;
import org.netbeans.lib.cvsclient.request.CommandRequest;

public class RlogCommand
extends BasicCommand {
    private final List modules = new LinkedList();
    private boolean defaultBranch;
    private String dateFilter;
    private boolean headerOnly;
    private boolean suppressHeader;
    private boolean noTags;
    private String revisionFilter;
    private String stateFilter;
    private String userFilter;
    private boolean headerAndDescOnly;

    public RlogCommand() {
        this.resetCVSCommand();
    }

    public void setModule(String string) {
        this.modules.add(string);
    }

    public void clearModules() {
        this.modules.clear();
    }

    public void setModules(String[] stringArray) {
        this.clearModules();
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            this.modules.add(string);
        }
    }

    public String[] getModules() {
        String[] stringArray = new String[this.modules.size()];
        stringArray = this.modules.toArray(stringArray);
        return stringArray;
    }

    public boolean isDefaultBranch() {
        return this.defaultBranch;
    }

    public void setDefaultBranch(boolean bl) {
        this.defaultBranch = bl;
    }

    public String getDateFilter() {
        return this.dateFilter;
    }

    public void setDateFilter(String string) {
        this.dateFilter = string;
    }

    public boolean isHeaderOnly() {
        return this.headerOnly;
    }

    public void setHeaderOnly(boolean bl) {
        this.headerOnly = bl;
    }

    public boolean isSuppressHeader() {
        return this.suppressHeader;
    }

    public void setSuppressHeader(boolean bl) {
        this.suppressHeader = bl;
    }

    public boolean isNoTags() {
        return this.noTags;
    }

    public void setNoTags(boolean bl) {
        this.noTags = bl;
    }

    public String getRevisionFilter() {
        return this.revisionFilter;
    }

    public void setRevisionFilter(String string) {
        this.revisionFilter = string;
    }

    public String getStateFilter() {
        return this.stateFilter;
    }

    public void setStateFilter(String string) {
        this.stateFilter = string;
    }

    public String getUserFilter() {
        return this.userFilter;
    }

    public void setUserFilter(String string) {
        this.userFilter = string;
    }

    public boolean isHeaderAndDescOnly() {
        return this.headerAndDescOnly;
    }

    public void setHeaderAndDescOnly(boolean bl) {
        this.headerAndDescOnly = bl;
    }

    public void execute(ClientServices clientServices, EventManager eventManager) throws CommandException, AuthenticationException {
        clientServices.ensureConnection();
        super.execute(clientServices, eventManager);
        if (!this.isRecursive()) {
            this.requests.add(new ArgumentRequest("-l"));
        }
        if (this.defaultBranch) {
            this.requests.add(new ArgumentRequest("-b"));
        }
        if (this.headerAndDescOnly) {
            this.requests.add(new ArgumentRequest("-t"));
        }
        if (this.headerOnly) {
            this.requests.add(new ArgumentRequest("-h"));
        }
        if (this.suppressHeader) {
            this.requests.add(new ArgumentRequest("-S"));
        }
        if (this.noTags) {
            this.requests.add(new ArgumentRequest("-N"));
        }
        if (this.userFilter != null) {
            this.requests.add(new ArgumentRequest("-w" + this.userFilter));
        }
        if (this.revisionFilter != null) {
            this.requests.add(new ArgumentRequest("-r" + this.revisionFilter));
        }
        if (this.stateFilter != null) {
            this.requests.add(new ArgumentRequest("-s" + this.stateFilter));
        }
        if (this.dateFilter != null) {
            this.requests.add(new ArgumentRequest("-d" + this.dateFilter));
        }
        Iterator iterator = this.modules.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.requests.add(new ArgumentRequest(string));
        }
        this.requests.add(CommandRequest.RLOG);
        try {
            clientServices.processRequests(this.requests);
            this.requests.clear();
        }
        catch (CommandException commandException) {
            throw commandException;
        }
        catch (Exception exception) {
            throw new CommandException(exception, exception.getLocalizedMessage());
        }
    }

    protected boolean assumeLocalPathWhenUnspecified() {
        return false;
    }

    public String getCVSCommand() {
        StringBuffer stringBuffer = new StringBuffer("rlog ");
        stringBuffer.append(this.getCVSArguments());
        if (this.modules != null && this.modules.size() > 0) {
            Iterator iterator = this.modules.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                stringBuffer.append(string);
                stringBuffer.append(' ');
            }
        } else {
            String string = CommandException.getLocalMessage("ExportCommand.moduleEmpty.text");
            stringBuffer.append(" ");
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public String getCVSArguments() {
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.isDefaultBranch()) {
            stringBuffer.append("-b ");
        }
        if (this.isHeaderAndDescOnly()) {
            stringBuffer.append("-t ");
        }
        if (this.isHeaderOnly()) {
            stringBuffer.append("-h ");
        }
        if (this.isSuppressHeader()) {
            stringBuffer.append("-S ");
        }
        if (this.isNoTags()) {
            stringBuffer.append("-N ");
        }
        if (!this.isRecursive()) {
            stringBuffer.append("-l ");
        }
        if (this.userFilter != null) {
            stringBuffer.append("-w");
            stringBuffer.append(this.userFilter);
            stringBuffer.append(' ');
        }
        if (this.revisionFilter != null) {
            stringBuffer.append("-r");
            stringBuffer.append(this.revisionFilter);
            stringBuffer.append(' ');
        }
        if (this.stateFilter != null) {
            stringBuffer.append("-s");
            stringBuffer.append(this.stateFilter);
            stringBuffer.append(' ');
        }
        if (this.dateFilter != null) {
            stringBuffer.append("-d");
            stringBuffer.append(this.dateFilter);
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public boolean setCVSCommand(char c, String string) {
        if (c == 'R') {
            this.setRecursive(true);
        } else if (c == 'l') {
            this.setRecursive(false);
        } else if (c == 'b') {
            this.setDefaultBranch(true);
        } else if (c == 'h') {
            this.setHeaderOnly(true);
        } else if (c == 't') {
            this.setHeaderAndDescOnly(true);
        } else if (c == 'S') {
            this.setSuppressHeader(true);
        } else if (c == 'N') {
            this.setNoTags(true);
        } else if (c == 'd') {
            this.setDateFilter(string);
        } else if (c == 'r') {
            this.setRevisionFilter(string == null ? "" : string);
        } else if (c == 's') {
            this.setStateFilter(string);
        } else if (c == 'w') {
            this.setUserFilter(string == null ? "" : string);
        } else {
            return false;
        }
        return true;
    }

    public void resetCVSCommand() {
        this.setRecursive(true);
        this.setDefaultBranch(false);
        this.setHeaderOnly(false);
        this.setHeaderAndDescOnly(false);
        this.setSuppressHeader(false);
        this.setNoTags(false);
        this.setDateFilter(null);
        this.setRevisionFilter(null);
        this.setStateFilter(null);
        this.setUserFilter(null);
    }

    public String getOptString() {
        return "RlbhStNd:r:s:w:";
    }

    public Builder createBuilder(EventManager eventManager) {
        return new LogBuilder(eventManager, this);
    }
}

