/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform.platformdefinition;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import java.util.zip.ZipFile;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    private Util() {
    }

    static ClassPath createClassPath(String string) {
        Parameters.notNull((CharSequence)"classpath", (Object)string);
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        ArrayList<PathResourceImplementation> arrayList = new ArrayList<PathResourceImplementation>();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            File file = FileUtil.normalizeFile((File)new File(string2));
            URL uRL = Util.getRootURL(file);
            if (uRL == null) continue;
            arrayList.add(ClassPathSupport.createResource((URL)uRL));
        }
        return ClassPathSupport.createClassPath(arrayList);
    }

    static URL getRootURL(File file) {
        try {
            URL uRL = file.toURI().toURL();
            if (FileUtil.isArchiveFile((URL)uRL)) {
                uRL = FileUtil.getArchiveRoot((URL)uRL);
            } else if (!file.exists()) {
                String string = uRL.toExternalForm();
                if (!string.endsWith("/")) {
                    uRL = new URL(string + "/");
                }
            } else if (file.isFile()) {
                try {
                    ZipFile zipFile = new ZipFile(file);
                    zipFile.close();
                    uRL = FileUtil.getArchiveRoot((URL)uRL);
                }
                catch (IOException iOException) {
                    uRL = null;
                }
            }
            return uRL;
        }
        catch (MalformedURLException malformedURLException) {
            throw new AssertionError((Object)malformedURLException);
        }
    }

    public static String normalizeName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isJavaIdentifierPart(c) || c == '-' || c == '.') {
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append('_');
        }
        return stringBuffer.toString();
    }

    public static SpecificationVersion getSpecificationVersion(JavaPlatform javaPlatform) {
        String string = (String)javaPlatform.getSystemProperties().get("java.specification.version");
        if (string == null) {
            string = "1.1";
        }
        return Util.makeSpec(string);
    }

    public static FileObject findTool(String string, Collection<FileObject> collection) {
        return Util.findTool(string, collection, null);
    }

    public static FileObject findTool(String string, Collection<FileObject> collection, String string2) {
        assert (string != null);
        for (FileObject fileObject : collection) {
            FileObject fileObject2;
            FileObject fileObject3 = fileObject.getFileObject("bin");
            if (fileObject3 == null || string2 != null && (fileObject3 = fileObject3.getFileObject(string2)) == null || (fileObject2 = fileObject3.getFileObject(string, Utilities.isWindows() ? "exe" : null)) == null) continue;
            return fileObject2;
        }
        return null;
    }

    public static String getExtensions(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            File file = FileUtil.normalizeFile((File)new File(stringTokenizer.nextToken()));
            File[] fileArray = file.listFiles();
            if (fileArray == null) continue;
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                if (!file2.exists()) {
                    ErrorManager.getDefault().log(16, MessageFormat.format(NbBundle.getMessage(Util.class, (String)"MSG_BrokenExtension"), file2, file));
                    continue;
                }
                if (Utilities.isMac() && "._.DS_Store".equals(file2.getName())) continue;
                FileObject fileObject = FileUtil.toFileObject((File)file2);
                if (fileObject == null) {
                    Logger.getLogger(Util.class.getName()).warning("Cannot create FileObject for file: " + file2.getAbsolutePath() + " exists: " + file2.exists());
                    continue;
                }
                if (!FileUtil.isArchiveFile((FileObject)fileObject)) continue;
                stringBuffer.append(File.pathSeparator);
                stringBuffer.append(fileArray[i].getAbsolutePath());
            }
        }
        if (stringBuffer.length() == 0) {
            return null;
        }
        return stringBuffer.substring(File.pathSeparator.length());
    }

    private static SpecificationVersion makeSpec(String string) {
        if (string != null) {
            try {
                return new SpecificationVersion(string);
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("WARNING: invalid specification version: " + string);
                while (true) {
                    string = string.substring(0, string.length() - 1);
                    try {
                        return new SpecificationVersion(string);
                    }
                    catch (NumberFormatException numberFormatException2) {
                        if (string.length() > 0) continue;
                    }
                    break;
                }
            }
        }
        return new SpecificationVersion("0");
    }
}

