/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.wizards;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.hibernate.service.api.HibernateEnvironment;
import org.netbeans.modules.hibernate.util.HibernateUtil;
import org.netbeans.modules.hibernate.wizards.support.SourceGroupUISupport;
import org.netbeans.modules.j2ee.core.api.support.SourceGroups;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public class HibernateCodeGenerationPanel
extends JPanel {
    private Project project;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private JTextComponent packageComboBoxEditor;
    private HibernateEnvironment env;
    List<FileObject> configFileObjects;
    List<FileObject> revengFileObjects;
    private JCheckBox chkDomain;
    private JCheckBox chkEjb;
    private JCheckBox chkHbm;
    private JCheckBox chkJava;
    private JComboBox cmbConf;
    private JComboBox cmbLocation;
    private JComboBox cmbPackage;
    private JComboBox cmbReveng;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JTextField txtProject;

    public HibernateCodeGenerationPanel() {
        this.initComponents();
        this.packageComboBoxEditor = (JTextComponent)this.cmbPackage.getEditor().getEditorComponent();
        Document document = this.packageComboBoxEditor.getDocument();
        document.addDocumentListener(new DocumentListener(){

            public void removeUpdate(DocumentEvent documentEvent) {
                HibernateCodeGenerationPanel.this.packageChanged();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                HibernateCodeGenerationPanel.this.packageChanged();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                HibernateCodeGenerationPanel.this.packageChanged();
            }
        });
    }

    public void initialize(Project project, FileObject fileObject) {
        SourceGroup sourceGroup;
        this.project = project;
        this.env = (HibernateEnvironment)project.getLookup().lookup(HibernateEnvironment.class);
        this.fillConfiguration();
        this.fillRevengFiles();
        this.txtProject.setText(ProjectUtils.getInformation((Project)project).getDisplayName());
        SourceGroup[] sourceGroupArray = SourceGroups.getJavaSourceGroups((Project)project);
        if (sourceGroupArray != null && sourceGroupArray.length == 0) {
            sourceGroupArray = HibernateUtil.getSourceGroups(project);
        }
        SourceGroupUISupport.connect(this.cmbLocation, sourceGroupArray);
        this.cmbPackage.setRenderer(PackageView.listRenderer());
        this.updatePackageComboBox();
        if (fileObject != null && (sourceGroup = SourceGroups.getFolderSourceGroup((SourceGroup[])sourceGroupArray, (FileObject)fileObject)) != null) {
            this.cmbLocation.setSelectedItem(sourceGroup);
            String string = SourceGroups.getPackageForFolder((SourceGroup)sourceGroup, (FileObject)fileObject);
            if (string != null) {
                this.packageComboBoxEditor.setText(string);
            }
        }
    }

    private void fillConfiguration() {
        String[] stringArray = this.getConfigFilesFromProject(this.project);
        this.cmbConf.setModel(new DefaultComboBoxModel<String>(stringArray));
    }

    private void fillRevengFiles() {
        String[] stringArray = this.getRevengFilesFromProject(this.project);
        this.cmbReveng.setModel(new DefaultComboBoxModel<String>(stringArray));
    }

    public String[] getConfigFilesFromProject(Project project) {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.configFileObjects = this.env.getAllHibernateConfigFileObjects();
        for (FileObject fileObject : this.configFileObjects) {
            arrayList.add(fileObject.getNameExt());
        }
        return arrayList.toArray(new String[0]);
    }

    public String[] getRevengFilesFromProject(Project project) {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.revengFileObjects = this.env.getAllHibernateReverseEnggFileObjects();
        for (FileObject fileObject : this.revengFileObjects) {
            arrayList.add(fileObject.getNameExt());
        }
        return arrayList.toArray(new String[0]);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    private void packageChanged() {
        this.changeSupport.fireChange();
    }

    private void updatePackageComboBox() {
        SourceGroup sourceGroup = (SourceGroup)this.cmbLocation.getSelectedItem();
        if (sourceGroup != null) {
            ComboBoxModel comboBoxModel = PackageView.createListView((SourceGroup)sourceGroup);
            if (comboBoxModel.getSelectedItem() != null && comboBoxModel.getSelectedItem().toString().startsWith("META-INF") && comboBoxModel.getSize() > 1) {
                comboBoxModel.setSelectedItem(comboBoxModel.getElementAt(1));
            }
            this.cmbPackage.setModel(comboBoxModel);
        }
    }

    public FileObject getConfigurationFile() {
        if (this.cmbConf.getSelectedIndex() != -1) {
            return this.configFileObjects.get(this.cmbConf.getSelectedIndex());
        }
        return null;
    }

    public FileObject getRevengFile() {
        if (this.cmbReveng.getSelectedIndex() != -1) {
            return this.revengFileObjects.get(this.cmbReveng.getSelectedIndex());
        }
        return null;
    }

    public SourceGroup getLocationValue() {
        return (SourceGroup)this.cmbLocation.getSelectedItem();
    }

    public String getPackageName() {
        return this.packageComboBoxEditor.getText();
    }

    public boolean getChkDomain() {
        return this.chkDomain.isSelected();
    }

    public boolean getChkHbm() {
        return this.chkHbm.isSelected();
    }

    public boolean getChkJava() {
        return this.chkJava.isSelected();
    }

    public boolean getChkEjb() {
        return this.chkEjb.isSelected();
    }

    private void locationChanged() {
        this.updatePackageComboBox();
        this.changeSupport.fireChange();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.chkDomain = new JCheckBox();
        this.chkHbm = new JCheckBox();
        this.jLabel2 = new JLabel();
        this.txtProject = new JTextField();
        this.jLabel3 = new JLabel();
        this.cmbLocation = new JComboBox();
        this.jLabel4 = new JLabel();
        this.cmbPackage = new JComboBox();
        this.jLabel5 = new JLabel();
        this.chkJava = new JCheckBox();
        this.chkEjb = new JCheckBox();
        this.cmbConf = new JComboBox();
        this.cmbReveng = new JComboBox();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.setName(NbBundle.getMessage(HibernateCodeGenerationPanel.class, (String)"LBL_GenerateClasses"));
        this.jLabel1.setText(NbBundle.getMessage(HibernateCodeGenerationPanel.class, (String)"HibernateCodeGenerationPanel.jLabel1.text"));
        this.chkDomain.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.chkDomain, (String)NbBundle.getMessage(HibernateCodeGenerationPanel.class, (String)"HibernateCodeGenerationPanel.chkDomain.text"));
        this.chkHbm.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.chkHbm, (String)NbBundle.getMessage(HibernateCodeGenerationPanel.class, (String)"HibernateCodeGenerationPanel.chkHbm.text"));
        this.jLabel2.setLabelFor(this.txtProject);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(HibernateCodeGenerationPanel.class, (String)"HibernateCodeGenerationPanel.jLabel2.text"));
        this.txtProject.setEditable(false);
        this.txtProject.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HibernateCodeGenerationPanel.this.txtProjectActionPerformed(actionEvent);
            }
        });
        this.jLabel3.setLabelFor(this.cmbLocation);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(HibernateCodeGenerationPanel.class, (String)"HibernateCodeGenerationPanel.jLabel3.text"));
        this.cmbLocation.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cmbLocation.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HibernateCodeGenerationPanel.this.cmbLocationActionPerformed(actionEvent);
            }
        });
        this.jLabel4.setLabelFor(this.cmbPackage);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(HibernateCodeGenerationPanel.class, (String)"HibernateCodeGenerationPanel.jLabel4.text"));
        this.cmbPackage.setEditable(true);
        this.cmbPackage.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jLabel5.setText(NbBundle.getMessage(HibernateCodeGenerationPanel.class, (String)"HibernateCodeGenerationPanel.jLabel5.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.chkJava, (String)NbBundle.getMessage(HibernateCodeGenerationPanel.class, (String)"HibernateCodeGenerationPanel.chkJava.text"));
        this.chkJava.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HibernateCodeGenerationPanel.this.chkJavaActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.chkEjb, (String)NbBundle.getMessage(HibernateCodeGenerationPanel.class, (String)"HibernateCodeGenerationPanel.chkEjb.text"));
        this.cmbConf.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cmbReveng.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jLabel6.setText(NbBundle.getMessage(HibernateCodeGenerationPanel.class, (String)"HibernateCodeGenerationPanel.jLabel6.text"));
        this.jLabel7.setText(NbBundle.getMessage(HibernateCodeGenerationPanel.class, (String)"HibernateCodeGenerationPanel.jLabel7.text"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jLabel6).add((Component)this.jLabel7, -2, 217, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.cmbReveng, 0, 273, Short.MAX_VALUE).add((Component)this.cmbConf, 0, 273, Short.MAX_VALUE))).add((Component)this.jLabel5).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.chkJava).add((Component)this.chkEjb))).add((Component)this.jLabel1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.chkDomain).add((Component)this.chkHbm))).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jLabel2).add((Component)this.jLabel4).add((Component)this.jLabel3, -1, 74, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.txtProject, -1, 416, Short.MAX_VALUE).add((Component)this.cmbPackage, 0, 416, Short.MAX_VALUE).add((Component)this.cmbLocation, 0, 416, Short.MAX_VALUE)))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel6).add((Component)this.cmbConf, -2, -1, -2)).add(9, 9, 9).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel7).add((Component)this.cmbReveng, -2, -1, -2)).addPreferredGap(0).add((Component)this.jLabel5).addPreferredGap(1).add((Component)this.chkJava).addPreferredGap(0).add((Component)this.chkEjb).addPreferredGap(1).add((Component)this.jLabel1).addPreferredGap(1).add((Component)this.chkDomain).addPreferredGap(1).add((Component)this.chkHbm).addPreferredGap(1).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.txtProject, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.cmbLocation, -2, -1, -2).add((Component)this.jLabel3)).add(7, 7, 7).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.cmbPackage, -2, -1, -2).add((Component)this.jLabel4)).addContainerGap()));
    }

    private void cmbLocationActionPerformed(ActionEvent actionEvent) {
        this.locationChanged();
    }

    private void chkJavaActionPerformed(ActionEvent actionEvent) {
    }

    private void txtProjectActionPerformed(ActionEvent actionEvent) {
    }
}

