/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.repository;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.List;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.netbeans.modules.maven.indexer.api.QueryField;
import org.netbeans.modules.maven.indexer.api.RepositoryIndexer;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryPreferences;
import org.netbeans.modules.maven.repository.FindInRepoPanel;
import org.netbeans.modules.maven.repository.FindResultsPanel;
import org.netbeans.modules.maven.repository.RepositoryNode;
import org.netbeans.modules.maven.repository.register.RepositoryRegisterUI;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.Toolbar;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class M2RepositoryBrowserTopComponent
extends TopComponent
implements ExplorerManager.Provider {
    private static M2RepositoryBrowserTopComponent instance;
    static final String ICON_PATH = "org/netbeans/modules/maven/repository/MavenRepoBrowser.png";
    private static final String PREFERRED_ID = "M2RepositoryBrowserTopComponent";
    private BeanTreeView btv;
    private ExplorerManager manager;
    private JButton btnAddRepo;
    private JButton btnFind;
    private JButton btnIndex;
    private JSplitPane jSplitPane1;
    private JToolBar jToolBar1;
    private JPanel pnlBrowse;
    private JPanel pnlExplorer;
    private JPanel pnlFind;

    private M2RepositoryBrowserTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(M2RepositoryBrowserTopComponent.class, (String)"CTL_M2RepositoryBrowserTopComponent"));
        this.setToolTipText(NbBundle.getMessage(M2RepositoryBrowserTopComponent.class, (String)"HINT_M2RepositoryBrowserTopComponent"));
        this.setIcon(ImageUtilities.loadImage((String)ICON_PATH, (boolean)true));
        this.btv = new BeanTreeView();
        this.btv.setRootVisible(false);
        this.btv.getAccessibleContext().setAccessibleName(NbBundle.getMessage(M2RepositoryBrowserTopComponent.class, (String)"A11Y_BrowserName"));
        this.btv.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(M2RepositoryBrowserTopComponent.class, (String)"A11Y_BrowserDescription"));
        this.manager = new ExplorerManager();
        ActionMap actionMap = this.getActionMap();
        actionMap.put("copy-to-clipboard", ExplorerUtils.actionCopy((ExplorerManager)this.manager));
        actionMap.put("cut-to-clipboard", ExplorerUtils.actionCut((ExplorerManager)this.manager));
        actionMap.put("paste-from-clipboard", ExplorerUtils.actionPaste((ExplorerManager)this.manager));
        actionMap.put("delete", ExplorerUtils.actionDelete((ExplorerManager)this.manager, (boolean)true));
        this.associateLookup(ExplorerUtils.createLookup((ExplorerManager)this.manager, (ActionMap)actionMap));
        this.pnlBrowse.add((Component)this.btv, "Center");
        this.hideFind();
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    private void hideFind() {
        this.pnlFind.removeAll();
        this.pnlFind.setVisible(false);
        this.jSplitPane1.setDividerLocation(1.0);
        this.jSplitPane1.setEnabled(false);
    }

    private void showFind(List<QueryField> list, DialogDescriptor dialogDescriptor) {
        FindResultsPanel findResultsPanel = new FindResultsPanel(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                M2RepositoryBrowserTopComponent.this.hideFind();
            }
        }, dialogDescriptor);
        findResultsPanel.find(list);
        this.pnlFind.add(findResultsPanel);
        this.pnlFind.setVisible(true);
        this.jSplitPane1.setEnabled(true);
        this.jSplitPane1.setDividerLocation(0.5);
    }

    private void initComponents() {
        this.pnlExplorer = new JPanel();
        this.jSplitPane1 = new JSplitPane();
        this.pnlBrowse = new JPanel();
        this.pnlFind = new JPanel();
        this.jToolBar1 = new EditorToolbar();
        this.btnIndex = new JButton();
        this.btnAddRepo = new JButton();
        this.btnFind = new JButton();
        this.setLayout(new BorderLayout());
        this.pnlExplorer.setLayout(new BorderLayout());
        this.jSplitPane1.setDividerSize(3);
        this.jSplitPane1.setOrientation(0);
        this.pnlBrowse.setLayout(new BorderLayout());
        this.jSplitPane1.setTopComponent(this.pnlBrowse);
        this.pnlFind.setLayout(new BorderLayout());
        this.jSplitPane1.setRightComponent(this.pnlFind);
        this.pnlExplorer.add((Component)this.jSplitPane1, "Center");
        this.add(this.pnlExplorer, "Center");
        this.jToolBar1.setFloatable(false);
        this.btnIndex.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/org/netbeans/modules/maven/repository/refreshRepo.png")));
        this.btnIndex.setToolTipText(NbBundle.getMessage(M2RepositoryBrowserTopComponent.class, (String)"LBL_REPO_Update_Indexes"));
        this.btnIndex.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                M2RepositoryBrowserTopComponent.this.btnIndexActionPerformed(actionEvent);
            }
        });
        this.jToolBar1.add(this.btnIndex);
        this.btnIndex.getAccessibleContext().setAccessibleName(NbBundle.getMessage(M2RepositoryBrowserTopComponent.class, (String)"M2RepositoryBrowserTopComponent.btnIndex.AccessibleContext.accessibleName"));
        this.btnIndex.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(M2RepositoryBrowserTopComponent.class, (String)"M2RepositoryBrowserTopComponent.btnIndex.AccessibleContext.accessibleDescription"));
        this.btnAddRepo.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/org/netbeans/modules/maven/repository/AddRepo.png")));
        this.btnAddRepo.setToolTipText(NbBundle.getMessage(M2RepositoryBrowserTopComponent.class, (String)"LBL_Add_Repo", (Object[])new Object[0]));
        this.btnAddRepo.setHorizontalTextPosition(0);
        this.btnAddRepo.setVerticalTextPosition(3);
        this.btnAddRepo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                M2RepositoryBrowserTopComponent.this.btnAddRepoActionPerformed(actionEvent);
            }
        });
        this.jToolBar1.add(this.btnAddRepo);
        this.btnAddRepo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(M2RepositoryBrowserTopComponent.class, (String)"M2RepositoryBrowserTopComponent.btnAddRepo.AccessibleContext.accessibleName"));
        this.btnAddRepo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(M2RepositoryBrowserTopComponent.class, (String)"M2RepositoryBrowserTopComponent.btnAddRepo.AccessibleContext.accessibleDescription"));
        this.btnFind.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/org/netbeans/modules/maven/repository/FindInRepo.png")));
        this.btnFind.setToolTipText(NbBundle.getMessage(M2RepositoryBrowserTopComponent.class, (String)"LBL_REPO_Find"));
        this.btnFind.setHorizontalTextPosition(0);
        this.btnFind.setVerticalTextPosition(3);
        this.btnFind.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                M2RepositoryBrowserTopComponent.this.btnFindActionPerformed(actionEvent);
            }
        });
        this.jToolBar1.add(this.btnFind);
        this.btnFind.getAccessibleContext().setAccessibleName(NbBundle.getMessage(M2RepositoryBrowserTopComponent.class, (String)"M2RepositoryBrowserTopComponent.btnFind.AccessibleContext.accessibleName"));
        this.btnFind.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(M2RepositoryBrowserTopComponent.class, (String)"M2RepositoryBrowserTopComponent.btnFind.AccessibleContext.accessibleDescription"));
        this.add(this.jToolBar1, "First");
    }

    private void btnIndexActionPerformed(ActionEvent actionEvent) {
        this.btnIndex.setEnabled(false);
        new RequestProcessor("Maven Repo Index Transfer/Scan").post(new Runnable(){

            public void run() {
                List list = RepositoryPreferences.getInstance().getRepositoryInfos();
                for (RepositoryInfo repositoryInfo : list) {
                    RepositoryIndexer.indexRepo((RepositoryInfo)repositoryInfo);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        M2RepositoryBrowserTopComponent.this.btnIndex.setEnabled(true);
                    }
                });
            }
        });
    }

    private void btnAddRepoActionPerformed(ActionEvent actionEvent) {
        RepositoryRegisterUI repositoryRegisterUI = new RepositoryRegisterUI();
        repositoryRegisterUI.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(M2RepositoryBrowserTopComponent.class, (String)"LBL_Add_Repo"));
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)repositoryRegisterUI, NbBundle.getMessage(M2RepositoryBrowserTopComponent.class, (String)"LBL_Add_Repo"));
        dialogDescriptor.setClosingOptions(new Object[]{repositoryRegisterUI.getButton(), DialogDescriptor.CANCEL_OPTION});
        dialogDescriptor.setOptions(new Object[]{repositoryRegisterUI.getButton(), DialogDescriptor.CANCEL_OPTION});
        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (repositoryRegisterUI.getButton() == object) {
            final RepositoryInfo repositoryInfo = repositoryRegisterUI.getRepositoryInfo();
            RepositoryPreferences.getInstance().addOrModifyRepositoryInfo(repositoryInfo);
            this.manager.setRootContext(this.createRootNode());
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    RepositoryIndexer.indexRepo((RepositoryInfo)repositoryInfo);
                }
            });
        }
    }

    private void btnFindActionPerformed(ActionEvent actionEvent) {
        this.hideFind();
        FindInRepoPanel findInRepoPanel = new FindInRepoPanel();
        findInRepoPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(M2RepositoryBrowserTopComponent.class, (String)"ACSD_Find_In_Repositories"));
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)findInRepoPanel, NbBundle.getMessage(M2RepositoryBrowserTopComponent.class, (String)"TIT_Find_In_Repositories"));
        findInRepoPanel.attachDesc(dialogDescriptor);
        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (object == DialogDescriptor.OK_OPTION) {
            this.showFind(findInRepoPanel.getQuery(), dialogDescriptor);
        }
    }

    public static synchronized M2RepositoryBrowserTopComponent getDefault() {
        if (instance == null) {
            instance = new M2RepositoryBrowserTopComponent();
        }
        return instance;
    }

    public static synchronized M2RepositoryBrowserTopComponent findInstance() {
        TopComponent topComponent = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (topComponent == null) {
            ErrorManager.getDefault().log(16, "Cannot find MyWindow component. It will not be located properly in the window system.");
            return M2RepositoryBrowserTopComponent.getDefault();
        }
        if (topComponent instanceof M2RepositoryBrowserTopComponent) {
            return (M2RepositoryBrowserTopComponent)topComponent;
        }
        ErrorManager.getDefault().log(16, "There seem to be multiple components with the 'M2RepositoryBrowserTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return M2RepositoryBrowserTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    public void componentOpened() {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                final Node node = M2RepositoryBrowserTopComponent.this.createRootNode();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        M2RepositoryBrowserTopComponent.this.manager.setRootContext(node);
                    }
                });
            }
        });
        this.manager.setRootContext((Node)new AbstractNode(Children.LEAF));
    }

    public void componentClosed() {
        this.manager.setRootContext((Node)new AbstractNode(Children.LEAF));
    }

    protected void componentActivated() {
        ExplorerUtils.activateActions((ExplorerManager)this.manager, (boolean)true);
    }

    protected void componentDeactivated() {
        ExplorerUtils.activateActions((ExplorerManager)this.manager, (boolean)false);
    }

    public boolean requestFocusInWindow() {
        return this.btv.requestFocusInWindow();
    }

    public void requestFocus() {
        this.btv.requestFocus();
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    private Node createRootNode() {
        Children.Array array = new Children.Array();
        List list = RepositoryPreferences.getInstance().getRepositoryInfos();
        for (RepositoryInfo repositoryInfo : list) {
            if (!repositoryInfo.isRemoteDownloadable() && !repositoryInfo.isLocal()) continue;
            array.add(new Node[]{new RepositoryNode(repositoryInfo)});
        }
        return new AbstractNode((Children)array);
    }

    private static class EditorToolbar
    extends Toolbar {
        public EditorToolbar() {
            Border border = UIManager.getBorder("Nb.Editor.Toolbar.border");
            this.setBorder(border);
            if ("Aqua".equals(UIManager.getLookAndFeel().getID())) {
                this.setBackground(UIManager.getColor("NbExplorerView.background"));
            }
        }

        public String getUIClassID() {
            if (UIManager.get("Nb.Toolbar.ui") != null) {
                return "Nb.Toolbar.ui";
            }
            return super.getUIClassID();
        }

        public String getName() {
            return "editorToolbar";
        }
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return M2RepositoryBrowserTopComponent.getDefault();
        }
    }
}

