/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.project.connections.ConfigManager;
import org.netbeans.modules.php.project.connections.RemoteConnections;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotificationLineSupport;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class NewRemoteConnectionPanel
extends JPanel {
    private static final long serialVersionUID = 2806958431387531044L;
    private final ConfigManager configManager;
    private DialogDescriptor descriptor;
    private NotificationLineSupport notificationLineSupport;
    private JLabel connectionNameLabel;
    private JTextField connectionNameTextField;
    private JComboBox connectionTypeComboBox;
    private JLabel connectionTypeLabel;

    public NewRemoteConnectionPanel(ConfigManager configManager) {
        this.configManager = configManager;
        this.initComponents();
        this.connectionTypeComboBox.setModel(new DefaultComboBoxModel<String>(new Vector<String>(RemoteConnections.get().getRemoteConnectionTypes())));
        this.registerListeners();
    }

    public boolean open() {
        this.descriptor = new DialogDescriptor((Object)this, NbBundle.getMessage(NewRemoteConnectionPanel.class, (String)"LBL_CreateNewConnection"), true, 2, DialogDescriptor.OK_OPTION, null);
        this.descriptor.setValid(false);
        this.notificationLineSupport = this.descriptor.createNotificationLineSupport();
        this.notificationLineSupport.setInformationMessage(NbBundle.getMessage(NewRemoteConnectionPanel.class, (String)"TXT_ProvideConnectionName"));
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)this.descriptor) == NotifyDescriptor.OK_OPTION;
    }

    public String getConnectionName() {
        return this.connectionNameTextField.getText().trim();
    }

    public String getConfigName() {
        return this.getConnectionName().replaceAll("[^a-zA-Z0-9_.-]", "_");
    }

    public String getConnectionType() {
        return (String)this.connectionTypeComboBox.getSelectedItem();
    }

    void validateFields() {
        String string = this.getConnectionName();
        String string2 = this.getConfigName();
        String string3 = this.getConnectionType();
        String string4 = null;
        if (string.length() == 0) {
            string4 = NbBundle.getMessage(NewRemoteConnectionPanel.class, (String)"MSG_EmptyConnectionName");
        } else if (string3.length() == 0) {
            string4 = NbBundle.getMessage(NewRemoteConnectionPanel.class, (String)"MSG_EmptyConnectionType");
        } else if (this.configManager.exists(string2)) {
            string4 = NbBundle.getMessage(NewRemoteConnectionPanel.class, (String)"MSG_ConnectionExists", (Object)string2);
        }
        this.setError(string4);
    }

    private void registerListeners() {
        this.connectionNameTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                this.processUpdate();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.processUpdate();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.processUpdate();
            }

            private void processUpdate() {
                NewRemoteConnectionPanel.this.validateFields();
            }
        });
        this.connectionTypeComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NewRemoteConnectionPanel.this.validateFields();
            }
        });
    }

    private void setError(String string) {
        assert (this.descriptor != null);
        assert (this.notificationLineSupport != null);
        if (StringUtils.hasText((String)string)) {
            this.notificationLineSupport.setErrorMessage(string);
            this.descriptor.setValid(false);
        } else {
            this.notificationLineSupport.clearMessages();
            this.descriptor.setValid(true);
        }
    }

    private void initComponents() {
        this.connectionNameLabel = new JLabel();
        this.connectionNameTextField = new JTextField();
        this.connectionTypeLabel = new JLabel();
        this.connectionTypeComboBox = new JComboBox();
        this.setFocusTraversalPolicy(new FocusTraversalPolicy(){

            public Component getDefaultComponent(Container container) {
                return NewRemoteConnectionPanel.this.connectionTypeComboBox;
            }

            public Component getFirstComponent(Container container) {
                return NewRemoteConnectionPanel.this.connectionTypeComboBox;
            }

            public Component getLastComponent(Container container) {
                return NewRemoteConnectionPanel.this.connectionTypeComboBox;
            }

            public Component getComponentAfter(Container container, Component component) {
                if (component == NewRemoteConnectionPanel.this.connectionNameTextField) {
                    return NewRemoteConnectionPanel.this.connectionTypeComboBox;
                }
                return NewRemoteConnectionPanel.this.connectionTypeComboBox;
            }

            public Component getComponentBefore(Container container, Component component) {
                if (component == NewRemoteConnectionPanel.this.connectionTypeComboBox) {
                    return NewRemoteConnectionPanel.this.connectionNameTextField;
                }
                return NewRemoteConnectionPanel.this.connectionTypeComboBox;
            }
        });
        this.connectionNameLabel.setLabelFor(this.connectionNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.connectionNameLabel, (String)NbBundle.getMessage(NewRemoteConnectionPanel.class, (String)"NewRemoteConnectionPanel.connectionNameLabel.text"));
        this.connectionNameTextField.setText(NbBundle.getMessage(NewRemoteConnectionPanel.class, (String)"NewRemoteConnectionPanel.connectionNameTextField.text"));
        this.connectionTypeLabel.setLabelFor(this.connectionTypeComboBox);
        Mnemonics.setLocalizedText((JLabel)this.connectionTypeLabel, (String)NbBundle.getMessage(NewRemoteConnectionPanel.class, (String)"NewRemoteConnectionPanel.connectionTypeLabel.text"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.connectionNameLabel).add((Component)this.connectionTypeLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((Component)this.connectionTypeComboBox, 0, 221, Short.MAX_VALUE).add(1, (Component)this.connectionNameTextField, -1, 221, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.connectionNameLabel).add((Component)this.connectionNameTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.connectionTypeLabel).add((Component)this.connectionTypeComboBox, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.connectionNameLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewRemoteConnectionPanel.class, (String)"NewRemoteConnectionPanel.connectionNameLabel.AccessibleContext.accessibleName"));
        this.connectionNameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewRemoteConnectionPanel.class, (String)"NewRemoteConnectionPanel.connectionNameLabel.AccessibleContext.accessibleDescription"));
        this.connectionNameTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewRemoteConnectionPanel.class, (String)"NewRemoteConnectionPanel.connectionNameTextField.AccessibleContext.accessibleName"));
        this.connectionNameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewRemoteConnectionPanel.class, (String)"NewRemoteConnectionPanel.connectionNameTextField.AccessibleContext.accessibleDescription"));
        this.connectionTypeLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewRemoteConnectionPanel.class, (String)"NewRemoteConnectionPanel.connectionTypeLabel.AccessibleContext.accessibleName"));
        this.connectionTypeLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewRemoteConnectionPanel.class, (String)"NewRemoteConnectionPanel.connectionTypeLabel.AccessibleContext.accessibleDescription"));
        this.connectionTypeComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewRemoteConnectionPanel.class, (String)"NewRemoteConnectionPanel.connectionTypeComboBox.AccessibleContext.accessibleName"));
        this.connectionTypeComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewRemoteConnectionPanel.class, (String)"NewRemoteConnectionPanel.connectionTypeComboBox.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewRemoteConnectionPanel.class, (String)"NewRemoteConnectionPanel.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewRemoteConnectionPanel.class, (String)"NewRemoteConnectionPanel.AccessibleContext.accessibleDescription"));
    }
}

