/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.classpath;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.php.project.classpath.BasePathSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseProjectPathSupport
extends BasePathSupport {
    private final PropertyEvaluator evaluator;
    private final ReferenceHelper referenceHelper;
    private final AntProjectHelper antProjectHelper;

    public BaseProjectPathSupport(PropertyEvaluator propertyEvaluator, ReferenceHelper referenceHelper, AntProjectHelper antProjectHelper) {
        assert (propertyEvaluator != null);
        assert (referenceHelper != null);
        assert (antProjectHelper != null);
        this.evaluator = propertyEvaluator;
        this.referenceHelper = referenceHelper;
        this.antProjectHelper = antProjectHelper;
    }

    protected abstract boolean isWellKnownPath(String var1);

    public Iterator<BasePathSupport.Item> itemsIterator(String string) {
        return this.itemsList(string).iterator();
    }

    public List<BasePathSupport.Item> itemsList(String string) {
        String[] stringArray = PropertyUtils.tokenizePath((String)(string == null ? "" : string));
        ArrayList<BasePathSupport.Item> arrayList = new ArrayList<BasePathSupport.Item>(stringArray.length);
        for (String string2 : stringArray) {
            BasePathSupport.Item item = null;
            if (this.isWellKnownPath(string2)) {
                item = BasePathSupport.Item.create(string2);
            } else {
                File file = null;
                String string3 = this.evaluator.evaluate(string2);
                if (string3 != null) {
                    file = this.antProjectHelper.resolveFile(string3);
                }
                item = file == null || !file.exists() ? BasePathSupport.Item.createBroken(string3, string2) : BasePathSupport.Item.create(string3, string2);
            }
            arrayList.add(item);
        }
        return arrayList;
    }

    public String[] encodeToStrings(Iterator<BasePathSupport.Item> iterator) {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        while (iterator.hasNext()) {
            stringArray = iterator.next();
            String string = stringArray.getReference();
            switch (stringArray.getType()) {
                case FOLDER: {
                    if (string != null) break;
                    File file = new File(stringArray.getFilePath());
                    stringArray.property = string = this.referenceHelper.createForeignFileReference(file, null);
                }
            }
            if (string == null) continue;
            arrayList.add(string);
        }
        stringArray = new String[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            stringArray[i] = i < arrayList.size() - 1 ? (String)arrayList.get(i) + ":" : (String)arrayList.get(i);
        }
        return stringArray;
    }
}

