/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.php.api.phpmodule.PhpFrameworks;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.project.PhpActionProvider;
import org.netbeans.modules.php.project.PhpConfigurationProvider;
import org.netbeans.modules.php.project.PhpEditorExtender;
import org.netbeans.modules.php.project.PhpModuleImpl;
import org.netbeans.modules.php.project.PhpProjectEncodingQueryImpl;
import org.netbeans.modules.php.project.PhpProjectOperations;
import org.netbeans.modules.php.project.PhpSharabilityQuery;
import org.netbeans.modules.php.project.PhpSources;
import org.netbeans.modules.php.project.PhpTemplates;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.SourceRoots;
import org.netbeans.modules.php.project.TemplateAttributesProviderImpl;
import org.netbeans.modules.php.project.UpdateHelper;
import org.netbeans.modules.php.project.UpdateImplementation;
import org.netbeans.modules.php.project.api.PhpSeleniumProvider;
import org.netbeans.modules.php.project.classpath.BasePathSupport;
import org.netbeans.modules.php.project.classpath.ClassPathProviderImpl;
import org.netbeans.modules.php.project.classpath.IncludePathClassPathProvider;
import org.netbeans.modules.php.project.copysupport.CopySupport;
import org.netbeans.modules.php.project.phpunit.PhpUnit;
import org.netbeans.modules.php.project.ui.actions.support.CommandUtils;
import org.netbeans.modules.php.project.ui.actions.support.ConfigAction;
import org.netbeans.modules.php.project.ui.codecoverage.PhpCoverageProvider;
import org.netbeans.modules.php.project.ui.customizer.CustomizerProviderImpl;
import org.netbeans.modules.php.project.ui.customizer.IgnorePathSupport;
import org.netbeans.modules.php.project.ui.logicalview.PhpLogicalViewProvider;
import org.netbeans.modules.php.project.util.PhpProjectUtils;
import org.netbeans.modules.php.spi.phpmodule.PhpFrameworkProvider;
import org.netbeans.modules.php.spi.phpmodule.PhpModuleIgnoredFilesExtender;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.FilterPropertyProvider;
import org.netbeans.spi.project.support.ant.ProjectXmlSavedHook;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyProvider;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhpProject
implements Project {
    private static final Icon PROJECT_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/php/project/ui/resources/phpProject.png", (boolean)false);
    static final Logger LOGGER = Logger.getLogger(PhpProject.class.getName());
    final AntProjectHelper helper;
    final UpdateHelper updateHelper;
    private final ReferenceHelper refHelper;
    private final PropertyEvaluator eval;
    private final Lookup lookup;
    private final SourceRoots sourceRoots;
    private final SourceRoots testRoots;
    private final SourceRoots seleniumRoots;
    volatile FileObject sourcesDirectory;
    volatile FileObject testsDirectory;
    volatile FileObject seleniumDirectory;
    volatile String name;
    private final AntProjectListener phpAntProjectListener = new PhpAntProjectListener();
    volatile Set<BasePathSupport.Item> ignoredFolders;
    final Object ignoredFoldersLock = new Object();
    final ChangeSupport ignoredFoldersChangeSupport = new ChangeSupport((Object)this);
    private final PropertyChangeListener ignoredFoldersListener = new IgnoredFoldersListener();
    final Object frameworksLock = new Object();
    List<PhpFrameworkProvider> frameworks;
    private final FileChangeListener sourceDirectoryFileChangeListener = new SourceDirectoryFileChangeListener();
    private final LookupListener frameworksListener = new FrameworksListener();

    public PhpProject(AntProjectHelper antProjectHelper) {
        assert (antProjectHelper != null);
        this.helper = antProjectHelper;
        this.updateHelper = new UpdateHelper(UpdateImplementation.NULL, antProjectHelper);
        AuxiliaryConfiguration auxiliaryConfiguration = antProjectHelper.createAuxiliaryConfiguration();
        this.eval = this.createEvaluator();
        this.refHelper = new ReferenceHelper(antProjectHelper, auxiliaryConfiguration, this.getEvaluator());
        this.sourceRoots = SourceRoots.create(this.updateHelper, this.eval, this.refHelper, SourceRoots.Type.SOURCES);
        this.testRoots = SourceRoots.create(this.updateHelper, this.eval, this.refHelper, SourceRoots.Type.TESTS);
        this.seleniumRoots = SourceRoots.create(this.updateHelper, this.eval, this.refHelper, SourceRoots.Type.SELENIUM);
        this.lookup = this.createLookup(auxiliaryConfiguration);
        this.addWeakPropertyEvaluatorListener(this.ignoredFoldersListener);
        antProjectHelper.addAntProjectListener((AntProjectListener)WeakListeners.create(AntProjectListener.class, (EventListener)this.phpAntProjectListener, (Object)antProjectHelper));
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    PropertyEvaluator getEvaluator() {
        return this.eval;
    }

    void addWeakPropertyEvaluatorListener(PropertyChangeListener propertyChangeListener) {
        this.eval.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)propertyChangeListener, (Object)this.eval));
    }

    void addWeakIgnoredFilesListener(ChangeListener changeListener) {
        this.ignoredFoldersChangeSupport.addChangeListener(WeakListeners.change((ChangeListener)changeListener, (Object)this.ignoredFoldersChangeSupport));
        VisibilityQuery visibilityQuery = VisibilityQuery.getDefault();
        visibilityQuery.addChangeListener(WeakListeners.change((ChangeListener)changeListener, (Object)visibilityQuery));
    }

    private PropertyEvaluator createEvaluator() {
        PropertyEvaluator propertyEvaluator = PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)this.helper.getStockPropertyPreprovider(), (PropertyProvider[])new PropertyProvider[]{this.helper.getPropertyProvider("nbproject/private/config.properties")});
        PropertyEvaluator propertyEvaluator2 = PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)this.helper.getStockPropertyPreprovider(), (PropertyProvider[])new PropertyProvider[]{this.helper.getPropertyProvider("nbproject/private/private.properties")});
        return PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)this.helper.getStockPropertyPreprovider(), (PropertyProvider[])new PropertyProvider[]{this.helper.getPropertyProvider("nbproject/private/config.properties"), new ConfigPropertyProvider(propertyEvaluator, "nbproject/private/configs", this.helper), this.helper.getPropertyProvider("nbproject/private/private.properties"), this.helper.getProjectLibrariesPropertyProvider(), PropertyUtils.userPropertiesProvider((PropertyEvaluator)propertyEvaluator2, (String)"user.properties.file", (File)FileUtil.toFile((FileObject)this.getProjectDirectory())), new ConfigPropertyProvider(propertyEvaluator, "nbproject/configs", this.helper), this.helper.getPropertyProvider("nbproject/project.properties")});
    }

    public FileObject getProjectDirectory() {
        return this.getHelper().getProjectDirectory();
    }

    public SourceRoots getSourceRoots() {
        return this.sourceRoots;
    }

    public SourceRoots getTestRoots() {
        return this.testRoots;
    }

    public SourceRoots getSeleniumRoots() {
        return this.seleniumRoots;
    }

    FileObject getSourcesDirectory() {
        if (this.sourcesDirectory == null) {
            ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Void run() {
                    PhpProject phpProject = PhpProject.this;
                    synchronized (phpProject) {
                        if (PhpProject.this.sourcesDirectory == null) {
                            PhpProject.this.sourcesDirectory = PhpProject.this.resolveSourcesDirectory();
                            PhpProject.this.sourcesDirectory.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)PhpProject.this.sourceDirectoryFileChangeListener, (Object)PhpProject.this.sourcesDirectory));
                        }
                    }
                    return null;
                }
            });
        }
        assert (this.sourcesDirectory != null) : "Sources directory cannot be null";
        return this.sourcesDirectory;
    }

    private FileObject resolveSourcesDirectory() {
        String string = this.eval.getProperty("src.dir");
        if (string == null) {
            FileObject fileObject = this.helper.getProjectDirectory().getFileObject("nbproject/project.properties");
            boolean bl = fileObject != null;
            StringBuilder stringBuilder = new StringBuilder(2000);
            stringBuilder.append("Property 'src.dir' was not found in 'nbproject/project.properties' (NB metadata corrupted?)\n");
            stringBuilder.append("diagnostics:\n");
            stringBuilder.append("project.properties exists: ");
            stringBuilder.append(bl);
            if (bl) {
                boolean bl2 = fileObject.canRead();
                stringBuilder.append("\nproject.properties valid: ");
                stringBuilder.append(fileObject.isValid());
                stringBuilder.append("\nproject.properties can read: ");
                stringBuilder.append(bl2);
                if (bl2) {
                    stringBuilder.append("\nproject.properties content: [");
                    try {
                        stringBuilder.append(fileObject.asText());
                    }
                    catch (IOException iOException) {
                        stringBuilder.append(iOException.getMessage());
                    }
                    stringBuilder.append("]");
                }
            }
            stringBuilder.append("\nproperties (helper): ");
            stringBuilder.append(this.helper.getProperties("nbproject/project.properties"));
            stringBuilder.append("\nproperties (evaluator): ");
            stringBuilder.append(this.eval.getProperties());
            throw new IllegalStateException(stringBuilder.toString());
        }
        FileObject fileObject = this.helper.resolveFileObject(string);
        if (fileObject != null) {
            return fileObject;
        }
        return this.restoreDirectory("src.dir", "MSG_SourcesFolderRestored", "MSG_SourcesFolderTemporaryToProjectDirectory");
    }

    FileObject getTestsDirectory() {
        if (this.testsDirectory == null) {
            ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Void run() {
                    PhpProject phpProject = PhpProject.this;
                    synchronized (phpProject) {
                        if (PhpProject.this.testsDirectory == null) {
                            PhpProject.this.testsDirectory = PhpProject.this.resolveTestsDirectory();
                        }
                    }
                    return null;
                }
            });
        }
        return this.testsDirectory;
    }

    void setTestsDirectory(FileObject fileObject) {
        assert (this.testsDirectory == null) : "Project test directory already set to " + this.testsDirectory;
        assert (fileObject != null && fileObject.isValid());
        this.testsDirectory = fileObject;
    }

    private FileObject resolveTestsDirectory() {
        String string = this.eval.getProperty("test.src.dir");
        if (string == null) {
            return null;
        }
        FileObject fileObject = this.helper.resolveFileObject(string);
        if (fileObject != null) {
            return fileObject;
        }
        return this.restoreDirectory("test.src.dir", "MSG_TestsFolderRestored", "MSG_TestsFolderTemporaryToProjectDirectory");
    }

    FileObject getSeleniumDirectory() {
        if (this.seleniumDirectory == null) {
            ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Void run() {
                    PhpProject phpProject = PhpProject.this;
                    synchronized (phpProject) {
                        if (PhpProject.this.seleniumDirectory == null) {
                            PhpProject.this.seleniumDirectory = PhpProject.this.resolveSeleniumDirectory();
                        }
                    }
                    return null;
                }
            });
        }
        return this.seleniumDirectory;
    }

    void setSeleniumDirectory(FileObject fileObject) {
        assert (this.seleniumDirectory == null) : "Project selenium directory already set to " + this.seleniumDirectory;
        assert (fileObject != null && fileObject.isValid());
        this.seleniumDirectory = fileObject;
    }

    private FileObject resolveSeleniumDirectory() {
        String string = this.eval.getProperty("selenium.src.dir");
        if (string == null) {
            return null;
        }
        FileObject fileObject = this.helper.resolveFileObject(string);
        if (fileObject != null) {
            return fileObject;
        }
        return this.restoreDirectory("selenium.src.dir", "MSG_SeleniumFolderRestored", "MSG_SeleniumFolderTemporaryToProjectDirectory");
    }

    private FileObject restoreDirectory(String string, String string2, String string3) {
        String string4 = this.getName();
        File file = FileUtil.normalizeFile((File)new File(this.helper.resolvePath(this.eval.getProperty(string))));
        if (file.mkdirs()) {
            this.informUser(string4, NbBundle.getMessage(PhpProject.class, (String)string2, (Object)file.getAbsolutePath()), 1);
            return FileUtil.toFileObject((File)file);
        }
        this.informUser(string4, NbBundle.getMessage(PhpProject.class, (String)string3, (Object)file.getAbsolutePath()), 0);
        return this.helper.getProjectDirectory();
    }

    private void informUser(String string, String string2, int n) {
        DialogDisplayer.getDefault().notify(new NotifyDescriptor((Object)string2, string, -1, n, new Object[]{NotifyDescriptor.OK_OPTION}, NotifyDescriptor.OK_OPTION));
    }

    public PhpModule getPhpModule() {
        PhpModule phpModule = (PhpModule)this.getLookup().lookup(PhpModule.class);
        assert (phpModule != null);
        return phpModule;
    }

    boolean isVisible(File file) {
        if (this.getIgnoredFiles().contains(file)) {
            return false;
        }
        return VisibilityQuery.getDefault().isVisible(file);
    }

    boolean isVisible(FileObject fileObject) {
        File file = FileUtil.toFile((FileObject)fileObject);
        if (file == null) {
            if (this.getIgnoredFileObjects().contains(fileObject)) {
                return false;
            }
            return VisibilityQuery.getDefault().isVisible(fileObject);
        }
        return this.isVisible(file);
    }

    public Set<File> getIgnoredFiles() {
        HashSet<File> hashSet = new HashSet<File>();
        this.putIgnoredProjectFiles(hashSet);
        this.putIgnoredFrameworkFiles(hashSet);
        return hashSet;
    }

    public Set<FileObject> getIgnoredFileObjects() {
        HashSet<FileObject> hashSet = new HashSet<FileObject>();
        for (File file : this.getIgnoredFiles()) {
            FileObject fileObject = FileUtil.toFileObject((File)file);
            if (fileObject == null) continue;
            hashSet.add(fileObject);
        }
        return hashSet;
    }

    private void putIgnoredProjectFiles(Set<File> set) {
        if (this.ignoredFolders == null) {
            ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Void run() {
                    Object object = PhpProject.this.ignoredFoldersLock;
                    synchronized (object) {
                        if (PhpProject.this.ignoredFolders == null) {
                            PhpProject.this.ignoredFolders = PhpProject.this.resolveIgnoredFolders();
                        }
                    }
                    return null;
                }
            });
        }
        assert (this.ignoredFolders != null) : "Ignored folders cannot be null";
        File file = FileUtil.toFile((FileObject)this.getProjectDirectory());
        for (BasePathSupport.Item item : this.ignoredFolders) {
            if (item.isBroken()) continue;
            File file2 = new File(item.getFilePath());
            if (!file2.isAbsolute()) {
                file2 = PropertyUtils.resolveFile((File)file, (String)item.getFilePath());
            }
            set.add(file2);
        }
    }

    private void putIgnoredFrameworkFiles(Set<File> set) {
        PhpModule phpModule = this.getPhpModule();
        for (PhpFrameworkProvider phpFrameworkProvider : this.getFrameworks()) {
            PhpModuleIgnoredFilesExtender phpModuleIgnoredFilesExtender = phpFrameworkProvider.getIgnoredFilesExtender(phpModule);
            if (phpModuleIgnoredFilesExtender == null) continue;
            for (File file : phpModuleIgnoredFilesExtender.getIgnoredFiles()) {
                assert (file != null) : "Ignored file = null found in " + phpFrameworkProvider.getName();
                assert (file.isAbsolute()) : "Not absolute file found in " + phpFrameworkProvider.getName();
                set.add(file);
            }
        }
    }

    private Set<BasePathSupport.Item> resolveIgnoredFolders() {
        IgnorePathSupport ignorePathSupport = new IgnorePathSupport(this.eval, this.refHelper, this.helper);
        HashSet<BasePathSupport.Item> hashSet = new HashSet<BasePathSupport.Item>();
        EditableProperties editableProperties = this.helper.getProperties("nbproject/project.properties");
        Iterator<BasePathSupport.Item> iterator = ignorePathSupport.itemsIterator(editableProperties.getProperty("ignore.path"));
        while (iterator.hasNext()) {
            hashSet.add(iterator.next());
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PhpFrameworkProvider> getFrameworks() {
        Object object = this.frameworksLock;
        synchronized (object) {
            if (this.frameworks == null) {
                this.frameworks = new LinkedList<PhpFrameworkProvider>();
                PhpModule phpModule = this.getPhpModule();
                for (PhpFrameworkProvider phpFrameworkProvider : PhpFrameworks.getFrameworks()) {
                    if (!phpFrameworkProvider.isInPhpModule(phpModule)) continue;
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine(String.format("Adding framework %s for project %s", phpFrameworkProvider.getName(), this.getSourcesDirectory()));
                    }
                    this.frameworks.add(phpFrameworkProvider);
                }
            }
            return new ArrayList<PhpFrameworkProvider>(this.frameworks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetFrameworks() {
        Object object = this.frameworksLock;
        synchronized (object) {
            this.frameworks = null;
        }
    }

    public String getName() {
        if (this.name == null) {
            ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Void run() {
                    5 var1_1 = this;
                    synchronized (var1_1) {
                        Element element;
                        NodeList nodeList;
                        if (PhpProject.this.name == null && (nodeList = (element = PhpProject.this.getHelper().getPrimaryConfigurationData(true)).getElementsByTagNameNS("http://www.netbeans.org/ns/php-project/1", "name")).getLength() == 1 && (nodeList = nodeList.item(0).getChildNodes()).getLength() == 1 && nodeList.item(0).getNodeType() == 3) {
                            PhpProject.this.name = ((Text)nodeList.item(0)).getNodeValue();
                        }
                        if (PhpProject.this.name == null) {
                            PhpProject.this.name = "???";
                        }
                    }
                    return null;
                }
            });
        }
        assert (this.name != null);
        return this.name;
    }

    public void setName(final String string) {
        ProjectManager.mutex().writeAccess(new Runnable(){

            public void run() {
                Element element;
                Element element2 = PhpProject.this.getHelper().getPrimaryConfigurationData(true);
                NodeList nodeList = element2.getElementsByTagNameNS("http://www.netbeans.org/ns/php-project/1", "name");
                if (nodeList.getLength() == 1) {
                    element = (Element)nodeList.item(0);
                    NodeList nodeList2 = element.getChildNodes();
                    while (nodeList2.getLength() > 0) {
                        element.removeChild(nodeList2.item(0));
                    }
                } else {
                    element = element2.getOwnerDocument().createElementNS("http://www.netbeans.org/ns/php-project/1", "name");
                    element2.insertBefore(element, element2.getChildNodes().item(0));
                }
                element.appendChild(element2.getOwnerDocument().createTextNode(string));
                PhpProject.this.getHelper().putPrimaryConfigurationData(element2, true);
            }
        });
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append(" [ project directory: ");
        stringBuilder.append(this.getProjectDirectory());
        stringBuilder.append(", source directory: ");
        stringBuilder.append(this.sourcesDirectory);
        stringBuilder.append(" ]");
        return stringBuilder.toString();
    }

    public AntProjectHelper getHelper() {
        return this.helper;
    }

    CopySupport getCopySupport() {
        return (CopySupport)this.getLookup().lookup(CopySupport.class);
    }

    private Lookup createLookup(AuxiliaryConfiguration auxiliaryConfiguration) {
        PhpProjectEncodingQueryImpl phpProjectEncodingQueryImpl = new PhpProjectEncodingQueryImpl(this.getEvaluator());
        return Lookups.fixed((Object[])new Object[]{this, CopySupport.getInstance(this), new SeleniumProvider(), new PhpCoverageProvider(this), new Info(), auxiliaryConfiguration, new PhpOpenedHook(), new PhpProjectXmlSavedHook(), new PhpActionProvider(this), new PhpConfigurationProvider(this), new PhpModuleImpl(this), new PhpEditorExtender(this), this.helper.createCacheDirectoryProvider(), this.helper.createAuxiliaryProperties(), new ClassPathProviderImpl(this, this.getSourceRoots(), this.getTestRoots(), this.getSeleniumRoots()), new PhpLogicalViewProvider(this), new CustomizerProviderImpl(this), new PhpSharabilityQuery(this.helper, this.getEvaluator(), this.getSourceRoots(), this.getTestRoots(), this.getSeleniumRoots()), new PhpProjectOperations(this), phpProjectEncodingQueryImpl, new TemplateAttributesProviderImpl(this.getHelper(), phpProjectEncodingQueryImpl), new PhpTemplates(), new PhpSources(this, this.getHelper(), this.getEvaluator(), this.getSourceRoots(), this.getTestRoots(), this.getSeleniumRoots()), this.getHelper(), this.getEvaluator()});
    }

    public ReferenceHelper getRefHelper() {
        return this.refHelper;
    }

    private final class PhpAntProjectListener
    implements AntProjectListener {
        private PhpAntProjectListener() {
        }

        public void configurationXmlChanged(AntProjectEvent antProjectEvent) {
            PhpProject.this.name = null;
        }

        public void propertiesChanged(AntProjectEvent antProjectEvent) {
        }
    }

    private final class FrameworksListener
    implements LookupListener {
        private FrameworksListener() {
        }

        public void resultChanged(LookupEvent lookupEvent) {
            LOGGER.fine("frameworks change, frameworks back to null");
            PhpProject.this.resetFrameworks();
        }
    }

    private final class SourceDirectoryFileChangeListener
    implements FileChangeListener {
        private SourceDirectoryFileChangeListener() {
        }

        public void fileFolderCreated(FileEvent fileEvent) {
            this.processFileChange();
        }

        public void fileDataCreated(FileEvent fileEvent) {
            this.processFileChange();
        }

        public void fileChanged(FileEvent fileEvent) {
        }

        public void fileDeleted(FileEvent fileEvent) {
            this.processFileChange();
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            this.processFileChange();
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        }

        void processFileChange() {
            LOGGER.fine("file change, frameworks back to null");
            PhpProject.this.resetFrameworks();
        }
    }

    private final class IgnoredFoldersListener
    implements PropertyChangeListener {
        private IgnoredFoldersListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("ignore.path".equals(propertyChangeEvent.getPropertyName())) {
                PhpProject.this.ignoredFolders = null;
                PhpProject.this.ignoredFoldersChangeSupport.fireChange();
            }
        }
    }

    private final class SeleniumProvider
    implements PhpSeleniumProvider {
        private SeleniumProvider() {
        }

        public FileObject getTestDirectory(boolean bl) {
            return ProjectPropertiesSupport.getSeleniumDirectory(PhpProject.this, bl);
        }

        public void runAllTests() {
            ConfigAction.get(ConfigAction.Type.SELENIUM, PhpProject.this).runProject();
        }
    }

    public final class PhpProjectXmlSavedHook
    extends ProjectXmlSavedHook {
        protected void projectXmlSaved() throws IOException {
            Info info = (Info)PhpProject.this.getLookup().lookup(Info.class);
            assert (info != null);
            info.firePropertyChange("name");
            info.firePropertyChange("displayName");
        }
    }

    private static final class ConfigPropertyProvider
    extends FilterPropertyProvider
    implements PropertyChangeListener {
        private final PropertyEvaluator baseEval;
        private final String prefix;
        private final AntProjectHelper helper;

        public ConfigPropertyProvider(PropertyEvaluator propertyEvaluator, String string, AntProjectHelper antProjectHelper) {
            super(ConfigPropertyProvider.computeDelegate(propertyEvaluator, string, antProjectHelper));
            this.baseEval = propertyEvaluator;
            this.prefix = string;
            this.helper = antProjectHelper;
            propertyEvaluator.addPropertyChangeListener((PropertyChangeListener)this);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("config".equals(propertyChangeEvent.getPropertyName())) {
                this.setDelegate(ConfigPropertyProvider.computeDelegate(this.baseEval, this.prefix, this.helper));
            }
        }

        private static PropertyProvider computeDelegate(PropertyEvaluator propertyEvaluator, String string, AntProjectHelper antProjectHelper) {
            String string2 = propertyEvaluator.getProperty("config");
            if (string2 != null) {
                return antProjectHelper.getPropertyProvider(string + "/" + string2 + ".properties");
            }
            return PropertyUtils.fixedPropertyProvider(Collections.emptyMap());
        }
    }

    private final class PhpOpenedHook
    extends ProjectOpenedHook {
        private PhpOpenedHook() {
        }

        protected void projectOpened() {
            PhpProject.this.sourcesDirectory = null;
            PhpProject.this.testsDirectory = null;
            PhpProject.this.seleniumDirectory = null;
            PhpProject.this.ignoredFolders = null;
            PhpProject.this.resetFrameworks();
            PhpProject.this.getSourcesDirectory();
            LOGGER.fine("Adding frameworks listener for " + PhpProject.this.sourcesDirectory);
            PhpFrameworks.addFrameworksListener((LookupListener)PhpProject.this.frameworksListener);
            PhpProject.this.getIgnoredFiles();
            List<PhpFrameworkProvider> list = PhpProject.this.getFrameworks();
            PhpProject.this.getName();
            ClassPathProviderImpl classPathProviderImpl = (ClassPathProviderImpl)PhpProject.this.lookup.lookup(ClassPathProviderImpl.class);
            ClassPath[] classPathArray = classPathProviderImpl.getProjectClassPaths("classpath/php-boot");
            GlobalPathRegistry.getDefault().register("classpath/php-boot", classPathArray);
            GlobalPathRegistry.getDefault().register("classpath/php-source", classPathProviderImpl.getProjectClassPaths("classpath/php-source"));
            for (ClassPath classPath : classPathArray) {
                IncludePathClassPathProvider.addProjectIncludePath(classPath);
            }
            PhpCoverageProvider phpCoverageProvider = (PhpCoverageProvider)PhpProject.this.getLookup().lookup(PhpCoverageProvider.class);
            if (phpCoverageProvider.isEnabled()) {
                PhpCoverageProvider.notifyProjectOpened(PhpProject.this);
            }
            PhpProject.this.getCopySupport().projectOpened();
            PhpUnit.validateVersion(CommandUtils.getPhpUnit(false));
            StringBuilder stringBuilder = new StringBuilder(200);
            for (PhpFrameworkProvider phpFrameworkProvider : list) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append("|");
                }
                stringBuilder.append(phpFrameworkProvider.getName());
            }
            PhpProjectUtils.logUsage(PhpProject.class, "USG_PROJECT_OPEN_PHP", Arrays.asList(stringBuilder.toString()));
        }

        protected void projectClosed() {
            assert (PhpProject.this.sourcesDirectory != null);
            PhpProject.this.sourcesDirectory.removeFileChangeListener(PhpProject.this.sourceDirectoryFileChangeListener);
            LOGGER.fine("Removing frameworks listener for " + PhpProject.this.sourcesDirectory);
            PhpFrameworks.removeFrameworksListener((LookupListener)PhpProject.this.frameworksListener);
            ClassPathProviderImpl classPathProviderImpl = (ClassPathProviderImpl)PhpProject.this.lookup.lookup(ClassPathProviderImpl.class);
            GlobalPathRegistry.getDefault().unregister("classpath/php-boot", classPathProviderImpl.getProjectClassPaths("classpath/php-boot"));
            GlobalPathRegistry.getDefault().unregister("classpath/php-source", classPathProviderImpl.getProjectClassPaths("classpath/php-source"));
            PhpProject.this.getCopySupport().projectClosed();
        }
    }

    private final class Info
    implements ProjectInformation {
        private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

        private Info() {
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
        }

        public String getDisplayName() {
            return PhpProject.this.getName();
        }

        public Icon getIcon() {
            return PROJECT_ICON;
        }

        public String getName() {
            return PropertyUtils.getUsablePropertyName((String)this.getDisplayName());
        }

        public Project getProject() {
            return PhpProject.this;
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
        }

        void firePropertyChange(String string) {
            this.propertyChangeSupport.firePropertyChange(string, null, null);
        }
    }
}

