/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.retriever.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.netbeans.modules.xml.retriever.impl.CertificationPanel;
import org.netbeans.modules.xml.retriever.impl.URLResourceRetriever;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecureURLResourceRetriever
extends URLResourceRetriever {
    private static Set<X509Certificate> acceptedCertificates;
    private static final String URI_SCHEME = "https";

    @Override
    public boolean accept(String string, String string2) throws URISyntaxException {
        URI uRI;
        URI uRI2 = new URI(string2);
        if (uRI2.isAbsolute() && uRI2.getScheme().equalsIgnoreCase(URI_SCHEME)) {
            return true;
        }
        return string != null && (uRI = new URI(string)).getScheme().equalsIgnoreCase(URI_SCHEME);
    }

    @Override
    public HashMap<String, InputStream> retrieveDocument(String string, String string2) throws IOException, URISyntaxException {
        String string3 = this.getEffectiveAddress(string, string2);
        if (string3 == null) {
            return null;
        }
        URI uRI = new URI(string3);
        HashMap<String, InputStream> hashMap = null;
        if (acceptedCertificates == null) {
            acceptedCertificates = new HashSet<X509Certificate>();
        }
        this.setRetrieverTrustManager();
        InputStream inputStream = this.getInputStreamOfURL(uRI.toURL(), ProxySelector.getDefault().select(uRI).get(0));
        hashMap = new HashMap<String, InputStream>();
        hashMap.put(this.effectiveURL.toString(), inputStream);
        return hashMap;
    }

    private void setRetrieverTrustManager() {
        TrustManager[] trustManagerArray = new TrustManager[]{new X509TrustManager(){

            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
            }

            public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
                if (x509CertificateArray != null) {
                    for (int i = 0; i < x509CertificateArray.length; ++i) {
                        if (acceptedCertificates.contains(x509CertificateArray[i])) continue;
                        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)new CertificationPanel(x509CertificateArray[i]), NbBundle.getMessage(SecureURLResourceRetriever.class, (String)"TTL_CertifiedWebSite"), true, 0, DialogDescriptor.YES_OPTION, null);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
                        if (DialogDescriptor.YES_OPTION.equals(dialogDescriptor.getValue())) {
                            acceptedCertificates.add(x509CertificateArray[i]);
                            continue;
                        }
                        throw new CertificateException(NbBundle.getMessage(SecureURLResourceRetriever.class, (String)"ERR_NotTrustedCertificate"));
                    }
                }
            }
        }};
        try {
            SSLContext sSLContext = SSLContext.getInstance("SSL");
            sSLContext.init(null, trustManagerArray, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sSLContext.getSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

                public boolean verify(String string, SSLSession sSLSession) {
                    return true;
                }
            });
        }
        catch (GeneralSecurityException generalSecurityException) {
            ErrorManager.getDefault().notify((Throwable)generalSecurityException);
        }
    }

    @Override
    public String getEffectiveAddress(String string, String string2) throws IOException, URISyntaxException {
        URI uRI = new URI(string2);
        String string3 = null;
        if (uRI.isAbsolute()) {
            string3 = uRI.toString();
            return string3;
        }
        if (string != null) {
            URI uRI2 = new URI(string);
            URI uRI3 = uRI2.resolve(uRI);
            string3 = uRI3.toString();
            return string3;
        }
        return null;
    }
}

