/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.retriever.catalog.model.impl;

import org.netbeans.modules.xml.retriever.catalog.model.Catalog;
import org.netbeans.modules.xml.retriever.catalog.model.CatalogComponent;
import org.netbeans.modules.xml.retriever.catalog.model.CatalogComponentFactory;
import org.netbeans.modules.xml.retriever.catalog.model.CatalogQNames;
import org.netbeans.modules.xml.retriever.catalog.model.CatalogVisitor;
import org.netbeans.modules.xml.retriever.catalog.model.NextCatalog;
import org.netbeans.modules.xml.retriever.catalog.model.System;
import org.netbeans.modules.xml.retriever.catalog.model.impl.CatalogImpl;
import org.netbeans.modules.xml.retriever.catalog.model.impl.CatalogModelImpl;
import org.netbeans.modules.xml.retriever.catalog.model.impl.NextCatalogImpl;
import org.netbeans.modules.xml.retriever.catalog.model.impl.SystemImpl;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentComponent;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CatalogComponentFactoryImpl
implements CatalogComponentFactory {
    private CatalogModelImpl model;

    public CatalogComponentFactoryImpl(CatalogModelImpl catalogModelImpl) {
        this.model = catalogModelImpl;
    }

    public CatalogComponent create(Element element, CatalogComponent catalogComponent) {
        if (catalogComponent == null) {
            if (CatalogComponentFactoryImpl.areSameQName(CatalogQNames.CATALOG, element)) {
                return new CatalogImpl(this.model, element);
            }
            return null;
        }
        return new CreateVisitor().create(element, catalogComponent);
    }

    public NextCatalog createNextCatalog() {
        return new NextCatalogImpl(this.model);
    }

    public System createSystem() {
        return new SystemImpl(this.model);
    }

    public Catalog createCatalog() {
        return new CatalogImpl(this.model);
    }

    public static boolean areSameQName(CatalogQNames catalogQNames, Element element) {
        return catalogQNames.getQName().equals(AbstractDocumentComponent.getQName((Node)element));
    }

    public static class CreateVisitor
    extends CatalogVisitor.Default {
        Element element;
        CatalogComponent created;

        CatalogComponent create(Element element, CatalogComponent catalogComponent) {
            this.element = element;
            catalogComponent.accept(this);
            return this.created;
        }

        private boolean isElementQName(CatalogQNames catalogQNames) {
            return CatalogComponentFactoryImpl.areSameQName(catalogQNames, this.element);
        }

        public void visit(Catalog catalog) {
            if (this.isElementQName(CatalogQNames.SYSTEM)) {
                this.created = new SystemImpl((CatalogModelImpl)catalog.getModel(), this.element);
            }
            if (this.isElementQName(CatalogQNames.NEXTCATALOG)) {
                this.created = new NextCatalogImpl((CatalogModelImpl)catalog.getModel(), this.element);
            }
        }

        public void visit(System system) {
        }

        public void visit(NextCatalog nextCatalog) {
        }
    }
}

