/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.microedition.databinding.lcdui;

import java.util.Date;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.DateField;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;
import javax.microedition.lcdui.ItemStateListener;
import org.netbeans.microedition.databinding.DataBinder;
import org.netbeans.microedition.databinding.lcdui.ItemBindingProvider;

public class DateFieldBindingProvider
extends ItemBindingProvider
implements ItemCommandListener,
ItemStateListener {
    private static final Command COMMIT_COMMAND = new Command("OK", "OK", 4, 1);
    public static final String FEATURE_DATETIME = "dateTime";
    public static final String FEATURE_INPUTMODE = "inputMode";
    private FeatureInputDateTime featureInputDateTime;
    private DateField dateField;
    private String elPointer;

    public void notifyBind(String elPointer, Object consumer, Object feature) {
        this.elPointer = elPointer;
        if (consumer instanceof DateField && this.dateField == null) {
            this.dateField = (DateField)consumer;
            if (feature instanceof FeatureInputDateTime) {
                this.featureInputDateTime = (FeatureInputDateTime)feature;
                if (this.featureInputDateTime.parentForm != null) {
                    this.featureInputDateTime.parentForm.setItemStateListener((ItemStateListener)this);
                } else if (this.featureInputDateTime.commitCommand != null) {
                    this.dateField.addCommand(this.featureInputDateTime.commitCommand);
                    this.dateField.setItemCommandListener((ItemCommandListener)this);
                }
            }
        }
    }

    public void notifyUnbind(String elPointer, Object consumer, Object feature) {
        if (consumer == this.dateField) {
            if (this.featureInputDateTime.commitCommand != null) {
                this.dateField.removeCommand(this.featureInputDateTime.commitCommand);
                this.dateField.setItemCommandListener(null);
            } else if (this.featureInputDateTime.parentForm != null) {
                this.featureInputDateTime.parentForm.setItemStateListener(null);
            }
        }
    }

    public Object pullDataFromConsumer(String elPointer, Object consumer, Object feature) {
        if (consumer == this.dateField) {
            return this.dateField.getDate();
        }
        return null;
    }

    public void pushDataToConsumer(String elPointer, Object consumer, Object feature, Object value) {
        if (consumer instanceof DateField) {
            DateField dateField = (DateField)consumer;
            if (FEATURE_DATETIME.equals(feature)) {
                this.updateDateField(value);
            } else if (feature instanceof FeatureInputDateTime) {
                this.updateDateField(value);
            } else if (FEATURE_INPUTMODE.equals(feature)) {
                if (value instanceof Integer) {
                    dateField.setInputMode(((Integer)value).intValue());
                }
            } else {
                super.pushDataToConsumer(elPointer, consumer, feature, value);
            }
        }
    }

    private void updateDateField(Object value) {
        if (value instanceof Date) {
            this.dateField.setDate((Date)value);
        } else if (value instanceof Long) {
            this.dateField.setDate(new Date((Long)value));
        } else if (value == null) {
            this.dateField.setDate(null);
        }
    }

    public void commandAction(Command command, Item item) {
        if (item == this.dateField && command == COMMIT_COMMAND && this.featureInputDateTime != null) {
            DataBinder.updateDataSet(this.elPointer, this, this.dateField, this.featureInputDateTime);
        }
    }

    public void itemStateChanged(Item item) {
        if (item == this.dateField && this.featureInputDateTime != null) {
            DataBinder.updateDataSet(this.elPointer, this, this.dateField, this.featureInputDateTime);
        }
    }

    public static final class FeatureInputDateTime {
        private Form parentForm;
        private Command commitCommand;

        public FeatureInputDateTime(String elExpression) {
            this(COMMIT_COMMAND);
        }

        public FeatureInputDateTime(Form parentForm) {
            this.parentForm = parentForm;
        }

        public FeatureInputDateTime(Command commitCommand) {
            this.commitCommand = commitCommand;
        }

        public FeatureInputDateTime(boolean attacheCommand) {
            if (attacheCommand) {
                this.commitCommand = COMMIT_COMMAND;
            }
        }
    }
}

