/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.completion;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.xml.text.completion.XMLCompletionResultItemPaintComponent;
import org.netbeans.modules.xml.text.syntax.XMLSyntaxSupport;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionTask;

class XMLResultItem
implements CompletionItem {
    private static final int XML_ITEMS_SORT_PRIORITY = 20;
    public String displayText;
    private String replacementText;
    public Icon icon;
    public Color foreground = Color.black;
    public Color background = Color.white;
    public Color selectionForeground = Color.black;
    public Color selectionBackground = new Color(204, 204, 255);
    private static JLabel rubberStamp = new JLabel();
    private XMLCompletionResultItemPaintComponent component;
    private boolean shift = false;
    static int substituteOffset;

    public XMLResultItem(String string) {
        this(string, null);
    }

    public XMLResultItem(String string, String string2) {
        this.replacementText = string;
        this.displayText = string2 != null ? string2 : string;
    }

    public XMLResultItem(String string, Icon icon, Color color, Color color2, Color color3, Color color4) {
        this.displayText = string;
        this.icon = icon;
        this.foreground = color;
        this.background = color2;
        this.selectionForeground = color3;
        this.selectionBackground = color4;
    }

    public String getReplacementText(int n) {
        return this.displayText;
    }

    protected Icon getIcon() {
        return this.icon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean replaceText(JTextComponent jTextComponent, String string, int n, int n2) {
        BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
        baseDocument.atomicLock();
        int n3 = string.length();
        try {
            String string2 = baseDocument.getText(n, baseDocument.getLength() - n < n3 ? baseDocument.getLength() - n : n3);
            if (("<" + string2 + ">").equals("</" + string)) {
                boolean bl = true;
                return bl;
            }
            if (!string.equals(string2)) {
                String string3 = baseDocument.getText(n - 1, 1);
                if (string3 != null && string3.equals("&")) {
                    string2 = baseDocument.getText(n, baseDocument.getLength() - --n < n3 ? baseDocument.getLength() - n : n3);
                }
                if ((n2 = this.getFirstDiffPosition(string2, string)) == n3) {
                    jTextComponent.setCaretPosition(n + n2);
                } else {
                    if (this.isTextRemovingAllowable(jTextComponent, baseDocument, string, n)) {
                        baseDocument.remove(n, n2);
                    }
                    baseDocument.insertString(n, string, null);
                }
            } else {
                int n4 = jTextComponent.getCaret().getDot() + n3 - n2;
                jTextComponent.setCaretPosition(n4 < baseDocument.getLength() ? n4 : baseDocument.getLength());
            }
        }
        catch (BadLocationException badLocationException) {
            boolean bl = false;
            return bl;
        }
        finally {
            baseDocument.atomicUnlock();
        }
        return true;
    }

    private boolean isTextRemovingAllowable(JTextComponent jTextComponent, BaseDocument baseDocument, String string, int n) throws BadLocationException {
        String string2;
        boolean bl;
        XMLSyntaxSupport xMLSyntaxSupport = (XMLSyntaxSupport)Utilities.getSyntaxSupport((JTextComponent)jTextComponent);
        TokenItem tokenItem = xMLSyntaxSupport.getTokenChain(n, baseDocument.getLength());
        boolean bl2 = bl = tokenItem == null;
        if (!bl && (string2 = tokenItem.getImage()) != null && string2.length() > 0) {
            int n2 = this.getFirstDiffPosition(string2, string);
            int n3 = n2 = n2 == 0 ? 1 : n2;
            if (n2 > -1 && n2 <= Math.min(string2.length(), string.length())) {
                int n4;
                String string3 = string2.length() >= n2 ? string2.substring(0, n2) : string2;
                String string4 = string.length() >= n2 ? string.substring(0, n2) : string;
                TokenID tokenID = tokenItem.getTokenID();
                int n5 = n4 = tokenID != null ? tokenID.getNumericID() : -1;
                bl = n4 == 4 ? !string3.startsWith(string4) : string3.startsWith(string4);
            }
        }
        return bl;
    }

    private int getFirstDiffPosition(String string, String string2) {
        int n = Math.min(string.length(), string2.length());
        for (int i = 0; i < n; ++i) {
            if (string.charAt(i) == string2.charAt(i)) continue;
            return i;
        }
        return n;
    }

    public boolean substituteCommonText(JTextComponent jTextComponent, int n, int n2, int n3) {
        return this.replaceText(jTextComponent, this.getReplacementText(0).substring(0, n3), n, n2);
    }

    public final boolean substituteText(JTextComponent jTextComponent, int n, int n2, boolean bl) {
        int n3 = bl ? 1 : 0;
        return this.substituteText(jTextComponent, n, n2, n3);
    }

    public boolean substituteText(JTextComponent jTextComponent, int n, int n2, int n3) {
        return this.replaceText(jTextComponent, this.getReplacementText(n3), n, n2);
    }

    public Component getPaintComponent(JList jList, boolean bl, boolean bl2) {
        if (this.getIcon() != null) {
            rubberStamp.setIcon(this.getIcon());
        }
        rubberStamp.setText(this.displayText);
        if (bl) {
            rubberStamp.setBackground(this.selectionBackground);
            rubberStamp.setForeground(this.selectionForeground);
        } else {
            rubberStamp.setBackground(this.background);
            rubberStamp.setForeground(this.foreground);
        }
        return rubberStamp;
    }

    public final String getItemText() {
        return this.replacementText;
    }

    public String toString() {
        return this.getItemText();
    }

    Color getPaintColor() {
        return Color.BLUE;
    }

    public CompletionTask createDocumentationTask() {
        return null;
    }

    public CompletionTask createToolTipTask() {
        return null;
    }

    public void defaultAction(JTextComponent jTextComponent) {
        int n = this.getSubstituteOffset();
        if (n == -1) {
            n = jTextComponent.getCaretPosition();
        }
        if (!this.shift) {
            Completion.get().hideAll();
        }
        this.substituteText(jTextComponent, n, jTextComponent.getCaretPosition() - n, this.shift);
    }

    public int getSubstituteOffset() {
        return substituteOffset;
    }

    public CharSequence getInsertPrefix() {
        return this.getItemText();
    }

    public Component getPaintComponent(boolean bl) {
        XMLCompletionResultItemPaintComponent.StringPaintComponent stringPaintComponent = new XMLCompletionResultItemPaintComponent.StringPaintComponent(this.getPaintColor());
        stringPaintComponent.setSelected(bl);
        stringPaintComponent.setString(this.getItemText());
        return stringPaintComponent;
    }

    public int getPreferredWidth(Graphics graphics, Font font) {
        Component component = this.getPaintComponent(false);
        return component.getPreferredSize().width;
    }

    public int getSortPriority() {
        return 20;
    }

    public CharSequence getSortText() {
        return this.getItemText();
    }

    public boolean instantSubstitution(JTextComponent jTextComponent) {
        this.defaultAction(jTextComponent);
        return true;
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        this.shift = keyEvent.getKeyCode() == 10 && keyEvent.getID() == 401 && keyEvent.isShiftDown();
    }

    public void render(Graphics graphics, Font font, Color color, Color color2, int n, int n2, boolean bl) {
        Component component = this.getPaintComponent(bl);
        component.setFont(font);
        component.setForeground(color);
        component.setBackground(color2);
        component.setBounds(0, 0, n, n2);
        XMLCompletionResultItemPaintComponent xMLCompletionResultItemPaintComponent = (XMLCompletionResultItemPaintComponent)component;
        xMLCompletionResultItemPaintComponent.setIcon(this.icon);
        xMLCompletionResultItemPaintComponent.paintComponent(graphics);
    }

    static {
        rubberStamp.setOpaque(true);
        substituteOffset = -1;
    }
}

