/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.search;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.javadoc.search.IndexBuilder;
import org.netbeans.modules.javadoc.search.JavadocURLMapper;
import org.netbeans.modules.javadoc.search.ReferencesPanel;
import org.openide.ErrorManager;
import org.openide.awt.DynamicMenuContent;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;

public final class IndexOverviewAction
extends SystemAction
implements Presenter.Menu {
    private static final ErrorManager err = ErrorManager.getDefault().getInstance("org.netbeans.modules.javadoc.search.IndexOverviewAction.IndexMenu");

    public IndexOverviewAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    public String getName() {
        return NbBundle.getMessage(IndexOverviewAction.class, (String)"CTL_INDICES_MenuItem");
    }

    protected String iconResource() {
        return null;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("javadoc.search");
    }

    public JMenuItem getMenuPresenter() {
        return new IndexMenu();
    }

    private static final class MoreReferencesMenuItem
    extends JMenuItem
    implements ActionListener {
        public MoreReferencesMenuItem() {
            Mnemonics.setLocalizedText((AbstractButton)this, (String)NbBundle.getMessage(IndexOverviewAction.class, (String)"CTL_MORE_INDICES_MenuItem"));
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FileObject fileObject = ReferencesPanel.showInWindow();
            URL uRL = null;
            if (fileObject != null) {
                uRL = JavadocURLMapper.findURL(fileObject);
            }
            if (uRL != null) {
                HtmlBrowser.URLDisplayer.getDefault().showURL(uRL);
            }
        }
    }

    private final class IndexMenuItem
    extends JMenuItem
    implements ActionListener,
    HelpCtx.Provider {
        private URL u;
        private final FileObject fsRef;

        public IndexMenuItem(String string, FileObject fileObject) {
            super(string);
            this.fsRef = fileObject;
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            URL uRL = this.getURL();
            HtmlBrowser.URLDisplayer.getDefault().showURL(uRL);
        }

        private URL getURL() {
            if (this.u == null) {
                this.u = JavadocURLMapper.findURL(this.fsRef);
            }
            return this.u;
        }

        public HelpCtx getHelpCtx() {
            return IndexOverviewAction.this.getHelpCtx();
        }
    }

    private final class IndexMenu
    extends JMenu
    implements HelpCtx.Provider,
    DynamicMenuContent {
        private static final int MAX_ITEMS = 20;
        private int itemHash = 0;

        public IndexMenu() {
            Mnemonics.setLocalizedText((AbstractButton)this, (String)IndexOverviewAction.this.getName());
            this.getModel().addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    if (IndexMenu.this.getModel().isSelected()) {
                        IndexMenu.this.getPopupMenu2();
                    }
                }
            });
        }

        public HelpCtx getHelpCtx() {
            return IndexOverviewAction.this.getHelpCtx();
        }

        public JComponent[] getMenuPresenters() {
            return new JComponent[]{this};
        }

        public JComponent[] synchMenuPresenters(JComponent[] jComponentArray) {
            return jComponentArray;
        }

        public void getPopupMenu2() {
            List[] listArray = IndexBuilder.getDefault().getIndices(false);
            if (listArray == null) {
                this.itemHash = 0;
                this.removeAll();
                this.add(new MoreReferencesMenuItem());
                return;
            }
            int n = this.computeDataHash(listArray);
            if (n != this.itemHash) {
                if (err.isLoggable(1)) {
                    err.log("recreating popup menu (" + this.itemHash + " -> " + n + ")");
                }
                this.itemHash = n;
                this.removeAll();
                List list = listArray[0];
                List list2 = listArray[1];
                int n2 = list.size();
                if (n2 != list2.size()) {
                    throw new IllegalStateException();
                }
                if (n2 > 0) {
                    for (int i = 0; i < n2 && i < 20; ++i) {
                        this.add(new IndexMenuItem((String)list.get(i), (FileObject)list2.get(i)));
                    }
                    this.add(new MoreReferencesMenuItem());
                } else {
                    JMenuItem jMenuItem = new JMenuItem(NbBundle.getMessage(IndexOverviewAction.class, (String)"CTL_no_indices_found"));
                    jMenuItem.setEnabled(false);
                    this.add(jMenuItem);
                }
            }
        }

        private int computeDataHash(List[] listArray) {
            int n = ((Object)listArray[0]).hashCode();
            for (FileObject fileObject : listArray[1]) {
                n += fileObject.hashCode();
            }
            return n;
        }
    }
}

