/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.debugger;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Lookup;
import org.netbeans.spi.debugger.ContextProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Session
implements ContextProvider {
    public static final String PROP_CURRENT_LANGUAGE = "currentLanguage";
    public static final String PROP_SUPPORTED_LANGUAGES = "supportedLanguages";
    private String name;
    private String locationName;
    private DebuggerEngine currentDebuggerEngine;
    private String currentLanguage;
    private String[] languages;
    private DebuggerEngine[] engines;
    private PropertyChangeSupport pcs;
    private Lookup lookup;
    Lookup privateLookup;
    private Map<DebuggerEngine, Lookup> enginesLookups = new HashMap<DebuggerEngine, Lookup>();

    Session(String string, String string2, String string3, Object[] objectArray, Lookup lookup) {
        this.name = string;
        this.locationName = string2;
        this.languages = new String[0];
        this.engines = new DebuggerEngine[0];
        this.pcs = new PropertyChangeSupport(this);
        Object[] objectArray2 = new Object[objectArray.length + 1];
        System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
        objectArray2[objectArray2.length - 1] = this;
        this.privateLookup = new Lookup.Compound(new Lookup.Instance(objectArray2), new Lookup.MetaInf(string3));
        this.lookup = new Lookup.Compound(lookup, this.privateLookup);
    }

    public String getName() {
        return this.name;
    }

    public String getLocationName() {
        return this.locationName;
    }

    public DebuggerEngine getCurrentEngine() {
        return this.currentDebuggerEngine;
    }

    public String getCurrentLanguage() {
        return this.currentLanguage;
    }

    public String[] getSupportedLanguages() {
        return this.languages;
    }

    @Override
    public <T> List<? extends T> lookup(String string, Class<T> clazz) {
        return this.lookup.lookup(string, clazz);
    }

    @Override
    public <T> T lookupFirst(String string, Class<T> clazz) {
        return this.lookup.lookupFirst(string, clazz);
    }

    public void kill() {
        DebuggerEngine[] debuggerEngineArray;
        for (DebuggerEngine debuggerEngine : debuggerEngineArray = this.engines) {
            debuggerEngine.getActionsManager().postAction(ActionsManager.ACTION_KILL);
        }
    }

    public synchronized DebuggerEngine getEngineForLanguage(String string) {
        int n = this.languages.length;
        for (int i = 0; i < n; ++i) {
            if (!this.languages[i].equals(string)) continue;
            return this.engines[i];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentLanguage(String string) {
        int n;
        int n2;
        String string2 = null;
        Session session = this;
        synchronized (session) {
            if (string.equals(this.currentLanguage)) {
                return;
            }
            n2 = this.languages.length;
            for (n = 0; n < n2; ++n) {
                if (!string.equals(this.languages[n])) continue;
                string2 = this.currentLanguage;
                this.currentLanguage = string;
                this.currentDebuggerEngine = this.engines[n];
                break;
            }
        }
        if (n < n2) {
            this.pcs.firePropertyChange(PROP_CURRENT_LANGUAGE, string2, string);
        }
    }

    Lookup getLookup() {
        return this.lookup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addLanguage(String string, DebuggerEngine debuggerEngine) {
        String[] stringArray;
        String[] stringArray2;
        boolean bl = false;
        Session session = this;
        synchronized (session) {
            int n = this.languages.length;
            for (int i = 0; i < n; ++i) {
                if (!string.equals(this.languages[i])) continue;
                this.engines[i] = debuggerEngine;
                return;
            }
            stringArray2 = new String[this.languages.length + 1];
            DebuggerEngine[] debuggerEngineArray = new DebuggerEngine[this.engines.length + 1];
            System.arraycopy(this.languages, 0, stringArray2, 0, this.languages.length);
            System.arraycopy(this.engines, 0, debuggerEngineArray, 0, this.engines.length);
            stringArray2[this.languages.length] = string;
            debuggerEngineArray[this.engines.length] = debuggerEngine;
            stringArray = this.languages;
            this.languages = stringArray2;
            this.engines = debuggerEngineArray;
            if (!this.enginesLookups.containsKey(debuggerEngine)) {
                Lookup.Compound compound = new Lookup.Compound(this.lookup, debuggerEngine.getPrivateLookup());
                this.lookup = compound;
                this.enginesLookups.put(debuggerEngine, debuggerEngine.getPrivateLookup());
            }
            if (this.currentLanguage == null) {
                this.currentLanguage = string;
                this.currentDebuggerEngine = debuggerEngine;
                bl = true;
            }
        }
        DebuggerManager.getDebuggerManager().addEngine(debuggerEngine);
        this.pcs.firePropertyChange(PROP_SUPPORTED_LANGUAGES, stringArray, stringArray2);
        if (bl) {
            this.pcs.firePropertyChange(PROP_CURRENT_LANGUAGE, null, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeEngine(DebuggerEngine debuggerEngine) {
        String[] stringArray;
        String[] stringArray2;
        String string = null;
        String string2 = null;
        Session session = this;
        synchronized (session) {
            int n;
            if (this.engines.length == 0) {
                return;
            }
            int n2 = this.engines.length;
            int n3 = 0;
            for (n = 0; n < n2; ++n) {
                if (!debuggerEngine.equals(this.engines[n])) continue;
                ++n3;
            }
            if (n3 == 0) {
                return;
            }
            stringArray2 = new String[n2 - n3];
            DebuggerEngine[] debuggerEngineArray = new DebuggerEngine[n2 - n3];
            int n4 = 0;
            for (n = 0; n < n2; ++n) {
                if (!debuggerEngine.equals(this.engines[n])) {
                    stringArray2[n4] = this.languages[n];
                    debuggerEngineArray[n4] = this.engines[n];
                    ++n4;
                    continue;
                }
                if (!this.languages[n].equals(this.currentLanguage)) continue;
                string = this.currentLanguage;
                this.currentLanguage = n > 0 ? this.languages[0] : (n < n2 - 1 ? this.languages[n + 1] : null);
                string2 = this.currentLanguage;
            }
            this.removeFromLookup(this.enginesLookups.remove(debuggerEngine));
            stringArray = this.languages;
            this.languages = stringArray2;
            this.engines = debuggerEngineArray;
        }
        DebuggerManager.getDebuggerManager().removeEngine(debuggerEngine);
        this.pcs.firePropertyChange(PROP_SUPPORTED_LANGUAGES, stringArray, stringArray2);
        if (string != string2) {
            this.pcs.firePropertyChange(PROP_CURRENT_LANGUAGE, string, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeLanguage(String string, DebuggerEngine debuggerEngine) {
        String[] stringArray;
        String[] stringArray2;
        Session session = this;
        synchronized (session) {
            int n;
            int n2 = this.languages.length;
            for (n = 0; n < n2; ++n) {
                if (!string.equals(this.languages[n])) continue;
                if (this.engines[n] == debuggerEngine) break;
                throw new IllegalArgumentException();
            }
            if (n >= n2) {
                return;
            }
            stringArray2 = new String[n2 - 1];
            DebuggerEngine[] debuggerEngineArray = new DebuggerEngine[n2 - 1];
            if (n > 0) {
                System.arraycopy(this.languages, 0, stringArray2, 0, n);
                System.arraycopy(this.engines, 0, debuggerEngineArray, 0, n);
            }
            System.arraycopy(this.languages, n + 1, stringArray2, n, n2 - n - 1);
            System.arraycopy(this.engines, n + 1, debuggerEngineArray, n, n2 - n - 1);
            stringArray = this.languages;
            this.languages = stringArray2;
            this.engines = debuggerEngineArray;
            n2 = this.engines.length;
            for (n = 0; n < n2; ++n) {
                if (this.engines[n] != debuggerEngine) continue;
                debuggerEngine = null;
                break;
            }
        }
        this.pcs.firePropertyChange(PROP_SUPPORTED_LANGUAGES, stringArray, stringArray2);
        if (debuggerEngine != null) {
            DebuggerManager.getDebuggerManager().removeEngine(debuggerEngine);
        }
    }

    private void removeFromLookup(Lookup lookup) {
        boolean[] blArray = new boolean[]{false};
        Lookup lookup2 = this.removeFromLookup(this.lookup, lookup, blArray);
        if (blArray[0]) {
            this.lookup = lookup2;
        }
    }

    private Lookup removeFromLookup(Lookup lookup, Lookup lookup2, boolean[] blArray) {
        if (lookup2 == null || !(lookup instanceof Lookup.Compound)) {
            return lookup;
        }
        Lookup.Compound compound = (Lookup.Compound)lookup;
        if (compound.l2 == lookup2) {
            blArray[0] = true;
            return (Lookup)compound.l1;
        }
        if (!(compound.l1 instanceof Lookup) || !(compound.l2 instanceof Lookup)) {
            return lookup;
        }
        Lookup lookup3 = this.removeFromLookup((Lookup)compound.l1, lookup2, blArray);
        Lookup lookup4 = this.removeFromLookup((Lookup)compound.l2, lookup2, blArray);
        if (blArray[0]) {
            return new Lookup.Compound(lookup3, lookup4);
        }
        return lookup;
    }

    public String toString() {
        return "" + this.getClass().getName() + " " + this.getLocationName() + ":" + this.getName();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(string, propertyChangeListener);
    }
}

