/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.client.cli;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.client.cli.SvnCommand;

class Commandline {
    private Process cli;
    private BufferedReader ctOutput;
    private BufferedReader ctError;
    private String executable = SvnModuleConfig.getDefault().getExecutableBinaryPath();
    private boolean canceled = false;

    Commandline() {
        if (this.executable == null || this.executable.trim().equals("")) {
            this.executable = "svn";
        } else {
            File file = new File(this.executable);
            if (file.isDirectory()) {
                this.executable = this.executable + "/svn";
            }
        }
    }

    public void interrupt() {
        try {
            this.destroy();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void destroy() throws IOException {
        this.canceled = true;
        if (this.cli != null) {
            try {
                this.cli.getErrorStream().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.cli.getInputStream().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.cli.getOutputStream().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.cli.destroy();
        }
        Subversion.LOG.fine("cli: Process destroyed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void exec(SvnCommand svnCommand) throws IOException {
        block78: {
            Object object;
            this.canceled = false;
            svnCommand.prepareCommand();
            String string = this.executable + " " + svnCommand.getStringCommand();
            Subversion.LOG.fine("cli: Executing \"" + string + "\"");
            Subversion.LOG.fine("cli: Creating process...");
            svnCommand.commandStarted();
            try {
                this.cli = Runtime.getRuntime().exec(svnCommand.getCliArguments(this.executable), this.getEnvVar());
                if (this.canceled) {
                    return;
                }
                this.ctError = new BufferedReader(new InputStreamReader(this.cli.getErrorStream()));
                Subversion.LOG.fine("cli: process created");
                String string2 = null;
                if (svnCommand.hasBinaryOutput()) {
                    object = new ByteArrayOutputStream();
                    int n = -1;
                    if (this.canceled) {
                        return;
                    }
                    Subversion.LOG.fine("cli: ready for binary OUTPUT \"");
                    while (!this.canceled && (n = this.cli.getInputStream().read()) != -1) {
                        ((ByteArrayOutputStream)object).write(n);
                    }
                    if (Subversion.LOG.isLoggable(Level.FINER)) {
                        Subversion.LOG.finer("cli: BIN OUTPUT \"" + new String(((ByteArrayOutputStream)object).toByteArray()) + "\"");
                    }
                    svnCommand.output(((ByteArrayOutputStream)object).toByteArray());
                }
                while (!this.canceled && (string2 = this.ctError.readLine()) != null) {
                    Subversion.LOG.info("cli: ERROR \"" + string2 + "\"");
                    svnCommand.errorText(string2);
                }
                if (this.canceled) {
                    return;
                }
                this.cli.waitFor();
                svnCommand.commandCompleted(this.cli.exitValue());
            }
            catch (InterruptedException interruptedException) {
                Subversion.LOG.log(Level.INFO, " command interrupted: [" + svnCommand.getStringCommand() + "]", interruptedException);
            }
            catch (InterruptedIOException interruptedIOException) {
                Subversion.LOG.log(Level.INFO, " command interrupted: [" + svnCommand.getStringCommand() + "]", interruptedIOException);
            }
            catch (Throwable throwable) {
                if (this.canceled) {
                    Subversion.LOG.fine(throwable.getMessage());
                    break block78;
                }
                if (throwable instanceof IOException) {
                    throw (IOException)throwable;
                }
                object = new IOException();
                ((Throwable)object).initCause(throwable);
                throw object;
            }
            finally {
                if (this.cli != null) {
                    try {
                        this.cli.getErrorStream().close();
                    }
                    catch (IOException iOException) {}
                    try {
                        this.cli.getInputStream().close();
                    }
                    catch (IOException iOException) {}
                    try {
                        this.cli.getOutputStream().close();
                    }
                    catch (IOException iOException) {}
                }
                this.ctError = null;
                this.ctOutput = null;
                Subversion.LOG.fine("cli: process finnished");
                svnCommand.commandFinished();
            }
        }
    }

    private String[] getEnvVar() {
        Map<String, String> map = System.getenv();
        ArrayList<String> arrayList = new ArrayList<String>(map.keySet().size());
        for (String string : map.keySet()) {
            if (string.equals("LC_ALL")) {
                arrayList.add("LC_ALL=");
                continue;
            }
            if (string.equals("LC_MESSAGES")) {
                arrayList.add("LC_MESSAGES=C");
                continue;
            }
            if (string.equals("LC_TIME")) {
                arrayList.add("LC_TIME=C");
                continue;
            }
            arrayList.add(string + "=" + map.get(string));
        }
        if (!map.containsKey("LC_ALL")) {
            arrayList.add("LC_ALL=");
        }
        if (!map.containsKey("LC_MESSAGES")) {
            arrayList.add("LC_MESSAGES=C");
        }
        if (!map.containsKey("LC_TIME")) {
            arrayList.add("LC_TIME=C");
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

