/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midpnb.screen.display;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.microedition.m2g.SVGImage;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.mobility.svgcore.util.Util;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.screen.display.ScreenDeviceInfo;
import org.netbeans.modules.vmd.api.screen.display.ScreenDisplayPresenter;
import org.netbeans.modules.vmd.api.screen.display.ScreenPropertyDescriptor;
import org.netbeans.modules.vmd.api.screen.display.ScreenPropertyEditor;
import org.netbeans.modules.vmd.midp.components.MidpProjectSupport;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.screen.display.DisplayableDisplayPresenter;
import org.netbeans.modules.vmd.midp.screen.display.ScreenFileObjectListener;
import org.netbeans.modules.vmd.midp.screen.display.property.ResourcePropertyEditor;
import org.netbeans.modules.vmd.midpnb.screen.display.SVGImageComponent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SVGPlayerDisplayPresenter
extends DisplayableDisplayPresenter {
    private JLabel stringLabel;
    private SVGImageComponent imageView = new SVGImageComponent();
    private ScreenFileObjectListener imageFileListener;
    private FileObject svgFileObject;
    private boolean useFileListener;

    public SVGPlayerDisplayPresenter() {
        JPanel jPanel = this.getPanel().getContentPanel();
        jPanel.setLayout(new BorderLayout());
        this.stringLabel = new JLabel();
        this.stringLabel.setHorizontalAlignment(0);
    }

    public SVGPlayerDisplayPresenter(boolean bl) {
        this();
        this.useFileListener = bl;
    }

    public void reload(ScreenDeviceInfo screenDeviceInfo) {
        super.reload(screenDeviceInfo);
        JPanel jPanel = this.getPanel().getContentPanel();
        jPanel.removeAll();
        DesignComponent designComponent = this.getComponent();
        PropertyValue propertyValue = designComponent.readProperty("svgImage");
        if (!PropertyValue.Kind.USERCODE.equals((Object)propertyValue.getKind())) {
            PropertyValue propertyValue2;
            DesignComponent designComponent2 = propertyValue.getComponent();
            DesignComponent designComponent3 = null;
            boolean bl = false;
            if (designComponent2 != null && (propertyValue2 = designComponent2.readProperty("resourcePath")).getKind() == PropertyValue.Kind.VALUE) {
                Map map = MidpProjectSupport.getFileObjectsForRelativeResourcePath((DesignDocument)designComponent.getDocument(), (String)MidpTypes.getString((PropertyValue)propertyValue2));
                Iterator iterator = map.keySet().iterator();
                FileObject fileObject = this.svgFileObject = iterator.hasNext() ? (FileObject)iterator.next() : null;
                if (this.svgFileObject != null) {
                    try {
                        designComponent3 = Util.createSVGImage((FileObject)this.svgFileObject, (boolean)true);
                        if (this.svgFileObject != null && this.useFileListener) {
                            this.svgFileObject.removeFileChangeListener((FileChangeListener)this.imageFileListener);
                            this.imageFileListener = new ScreenFileObjectListener(this.getRelatedComponent(), designComponent2, "resourcePath");
                            this.svgFileObject.addFileChangeListener((FileChangeListener)this.imageFileListener);
                        }
                    }
                    catch (IOException iOException) {
                        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, null, iOException);
                        bl = true;
                    }
                }
            }
            this.imageView.setImage((SVGImage)designComponent3);
            if (designComponent3 != null) {
                jPanel.add((Component)this.imageView, "Center");
            } else if (bl) {
                this.stringLabel.setText(NbBundle.getMessage(SVGPlayerDisplayPresenter.class, (String)"DISP_svg_image_not_svg_tiny"));
                jPanel.add((Component)this.stringLabel, "Center");
            } else {
                this.stringLabel.setText(NbBundle.getMessage(SVGPlayerDisplayPresenter.class, (String)"DISP_svg_image_not_specified"));
                jPanel.add((Component)this.stringLabel, "Center");
            }
        } else {
            this.stringLabel.setText(NbBundle.getMessage(SVGPlayerDisplayPresenter.class, (String)"DISP_svg_image_is_usercode"));
            jPanel.add((Component)this.stringLabel, "Center");
        }
        for (DesignComponent designComponent3 : this.getChildren()) {
            ScreenDisplayPresenter screenDisplayPresenter = (ScreenDisplayPresenter)designComponent3.getPresenter(ScreenDisplayPresenter.class);
            if (screenDisplayPresenter == null) continue;
            screenDisplayPresenter.reload(screenDeviceInfo);
            jPanel.add((Component)screenDisplayPresenter.getView(), "Last");
        }
    }

    public Collection<ScreenPropertyDescriptor> getPropertyDescriptors() {
        ArrayList<ScreenPropertyDescriptor> arrayList = new ArrayList<ScreenPropertyDescriptor>(super.getPropertyDescriptors());
        ResourcePropertyEditor resourcePropertyEditor = new ResourcePropertyEditor("svgImage", this.getComponent());
        if (this.stringLabel.getParent() != null) {
            arrayList.add(new ScreenPropertyDescriptor(this.getComponent(), (JComponent)this.stringLabel, (ScreenPropertyEditor)resourcePropertyEditor));
        } else {
            arrayList.add(new ScreenPropertyDescriptor(this.getComponent(), (JComponent)this.imageView, (ScreenPropertyEditor)resourcePropertyEditor));
        }
        return arrayList;
    }

    public Collection<DesignComponent> getChildren() {
        return this.getComponent().getComponents();
    }

    protected void notifyDetached(DesignComponent designComponent) {
        if (this.svgFileObject != null && this.imageFileListener != null) {
            this.svgFileObject.removeFileChangeListener((FileChangeListener)this.imageFileListener);
        }
        this.svgFileObject = null;
        this.imageFileListener = null;
    }

    protected float getScaleX() {
        return this.imageView.getScaleX();
    }

    protected float getScaleY() {
        return this.imageView.getScaleY();
    }

    protected int getCorrectionX() {
        return this.imageView.getCorrectionX();
    }

    protected int getCorrectionY() {
        return this.imageView.getCorrectionY();
    }

    protected SVGImage getSVGImage() {
        return this.imageView.getImage();
    }
}

