/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midpnb.propertyeditors.table;

import java.util.Vector;
import javax.swing.table.DefaultTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CustomEditorTableModel
extends DefaultTableModel {
    private Vector<String> header = new Vector();
    private boolean hasHeader;

    CustomEditorTableModel() {
    }

    public void removeLastColumn() {
        int n;
        if (this.hasHeader && this.header.size() > 0) {
            this.header.remove(this.header.size() - 1);
        }
        if ((n = this.getColumnCount()) > 0) {
            int n2 = this.dataVector.size();
            for (int i = 0; i < n2; ++i) {
                Vector vector = (Vector)this.dataVector.elementAt(i);
                vector.remove(n - 1);
            }
        }
        this.fireTableStructureChanged();
    }

    @Override
    public void removeRow(int n) {
        this.dataVector.removeElementAt(n);
        this.fireTableStructureChanged();
    }

    @Override
    public void addRow(Object[] objectArray) {
        this.dataVector.addElement(CustomEditorTableModel.convertToVector(objectArray));
        this.fireTableStructureChanged();
    }

    public void addColumn(String string, boolean bl) {
        if (this.hasHeader) {
            this.header.addElement(string);
        }
        if (this.dataVector.size() > 0) {
            for (int i = 0; i < this.dataVector.size(); ++i) {
                Vector vector = (Vector)this.dataVector.elementAt(i);
                vector.addElement(string);
            }
        } else if (bl) {
            Vector<String> vector = new Vector<String>(1);
            vector.add(string);
            this.dataVector.addElement(vector);
        }
        this.fireTableStructureChanged();
    }

    @Override
    public int getRowCount() {
        return this.dataVector.size() + (this.hasHeader ? 1 : 0);
    }

    @Override
    public int getColumnCount() {
        if (this.hasHeader) {
            return this.header.size();
        }
        if (this.dataVector.size() > 0) {
            return ((Vector)this.dataVector.get(0)).size();
        }
        return 0;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Object object = this.hasHeader ? (n == 0 ? this.header.elementAt(n2) : super.getValueAt(n - 1, n2)) : super.getValueAt(n, n2);
        return object;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (this.hasHeader) {
            if (n == 0) {
                this.header.setElementAt((String)object, n2);
                this.fireTableStructureChanged();
            } else {
                super.setValueAt(object, n - 1, n2);
            }
        } else {
            super.setValueAt(object, n, n2);
        }
    }

    @Override
    public void setDataVector(Object[][] objectArray, Object[] objectArray2) {
        if (this.hasHeader) {
            this.header.clear();
            for (int i = 0; i < objectArray2.length; ++i) {
                this.header.addElement((String)objectArray2[i]);
            }
        }
        this.dataVector = CustomEditorTableModel.nonNullVector(CustomEditorTableModel.convertToVector(objectArray));
        this.fireTableStructureChanged();
    }

    private static Vector nonNullVector(Vector vector) {
        return vector != null ? vector : new Vector();
    }

    public void clear() {
        this.dataVector.clear();
        this.fireTableStructureChanged();
    }

    public void setUseHeader(boolean bl) {
        if (bl && this.header.size() != this.getColumnCount()) {
            this.header.clear();
            for (int i = 0; i < this.getColumnCount(); ++i) {
                this.header.addElement("");
            }
        }
        this.hasHeader = bl;
        this.fireTableStructureChanged();
    }

    public boolean hasHeader() {
        return this.hasHeader;
    }

    public Vector<String> getHeader() {
        return this.header;
    }
}

