/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midpnb.propertyeditors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorElement;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorUserCode;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGButtonGroupCD;
import org.netbeans.modules.vmd.midpnb.propertyeditors.PropertyEditorSpinnerModel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class PropertyEditorButtonGroup
extends PropertyEditorUserCode
implements PropertyEditorElement {
    private CustomEditor myCustomEditor;
    private JRadioButton myRadioButton;

    private PropertyEditorButtonGroup() {
        super(NbBundle.getMessage(PropertyEditorButtonGroup.class, (String)"LBL_ButtonGroup"));
    }

    public static PropertyEditorButtonGroup createInstance() {
        return new PropertyEditorButtonGroup();
    }

    public void cleanUp(DesignComponent designComponent) {
        super.cleanUp(designComponent);
        if (this.myCustomEditor != null) {
            this.myCustomEditor.cleanUp();
            this.myCustomEditor = null;
        }
        this.myRadioButton = null;
    }

    public Boolean canEditAsText() {
        return false;
    }

    public String getAsText() {
        return NbBundle.getMessage(PropertyEditorSpinnerModel.class, (String)"TXT_ButtonGroup");
    }

    public Component getCustomEditor() {
        if (this.myCustomEditor == null) {
            this.initComponents();
            this.initElements(Collections.singleton(this));
        }
        return super.getCustomEditor();
    }

    public JComponent getCustomEditorComponent() {
        return this.myCustomEditor;
    }

    public JRadioButton getRadioButton() {
        return this.myRadioButton;
    }

    public String getTextForPropertyValue() {
        return null;
    }

    public boolean isInitiallySelected() {
        return true;
    }

    public boolean isVerticallyResizable() {
        return false;
    }

    public void setTextForPropertyValue(String string) {
        this.saveValue(string);
    }

    public void updateState(PropertyValue propertyValue) {
        if (propertyValue != null) {
            this.myCustomEditor.setValue(propertyValue);
        }
        this.myRadioButton.setSelected(!this.isCurrentValueAUserCodeType());
    }

    public void customEditorOKButtonPressed() {
        super.customEditorOKButtonPressed();
        if (this.myRadioButton.isSelected()) {
            this.saveValue(this.myCustomEditor.getValue());
        }
    }

    private void initComponents() {
        this.myRadioButton = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.myRadioButton, (String)NbBundle.getMessage(PropertyEditorButtonGroup.class, (String)"LBL_ButtonGroupList"));
        this.myRadioButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PropertyEditorButtonGroup.class, (String)"ACSN_ButtonGroupList"));
        this.myRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PropertyEditorButtonGroup.class, (String)"ACSD_ButtonGroupList"));
        this.myCustomEditor = new CustomEditor();
        this.myCustomEditor.updateModel();
    }

    private void saveValue(final String string) {
        if (this.component == null || this.component.get() == null) {
            return;
        }
        final DesignComponent designComponent = (DesignComponent)this.component.get();
        final PropertyValue[] propertyValueArray = new PropertyValue[1];
        designComponent.getDocument().getTransactionManager().readAccess(new Runnable(){

            public void run() {
                propertyValueArray[0] = designComponent.readProperty("buttonGroup");
            }
        });
        if (string != null && string.equals(propertyValueArray[0].getPrimitiveValue())) {
            return;
        }
        designComponent.getDocument().getTransactionManager().writeAccess(new Runnable(){

            public void run() {
                List list = designComponent.getParentComponent().readProperty("components").getArray();
                for (PropertyValue propertyValue : list) {
                    DesignComponent designComponent2;
                    if (!propertyValue.getComponent().getType().equals((Object)SVGButtonGroupCD.TYPEID) || !(designComponent2 = propertyValue.getComponent()).readProperty("instanceName").getPrimitiveValue().toString().equals(string)) continue;
                    PropertyEditorButtonGroup.super.setValue(PropertyValue.createComponentReference((DesignComponent)designComponent2));
                    return;
                }
                PropertyEditorButtonGroup.super.setValue(PropertyValue.createNull());
            }
        });
    }

    private class CustomEditor
    extends JPanel
    implements ActionListener {
        private static final long serialVersionUID = 7734641168584954536L;
        private JComboBox myCombobox;

        CustomEditor() {
            this.initComponents();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PropertyEditorButtonGroup.this.myRadioButton.setSelected(true);
        }

        void cleanUp() {
            if (this.myCombobox != null) {
                this.myCombobox.removeActionListener(this);
                this.myCombobox = null;
            }
            this.removeAll();
        }

        void updateModel() {
            final DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.myCombobox.getModel();
            defaultComboBoxModel.removeAllElements();
            final DesignComponent designComponent = (DesignComponent)PropertyEditorButtonGroup.this.component.get();
            designComponent.getDocument().getTransactionManager().readAccess(new Runnable(){

                public void run() {
                    List list = designComponent.getParentComponent().readProperty("components").getArray();
                    for (PropertyValue propertyValue : list) {
                        if (!propertyValue.getComponent().getType().equals((Object)SVGButtonGroupCD.TYPEID)) continue;
                        defaultComboBoxModel.addElement(propertyValue.getComponent().readProperty("instanceName").getPrimitiveValue().toString());
                    }
                }
            });
        }

        void setValue(final PropertyValue propertyValue) {
            if (propertyValue.getComponent() == null) {
                return;
            }
            propertyValue.getComponent().getDocument().getTransactionManager().readAccess(new Runnable(){

                public void run() {
                    String string = propertyValue.getComponent().readProperty("instanceName").toString();
                    CustomEditor.this.myCombobox.setSelectedItem(string);
                }
            });
        }

        String getValue() {
            return this.myCombobox.getSelectedItem().toString();
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.myCombobox = new JComboBox();
            this.myCombobox.setModel(new DefaultComboBoxModel());
            this.myCombobox.addActionListener(this);
            this.myCombobox.getAccessibleContext().setAccessibleName(PropertyEditorButtonGroup.this.myRadioButton.getAccessibleContext().getAccessibleName());
            this.myCombobox.getAccessibleContext().setAccessibleDescription(PropertyEditorButtonGroup.this.myRadioButton.getAccessibleContext().getAccessibleDescription());
            this.add((Component)this.myCombobox, "Center");
        }
    }
}

