/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.mysql.nodes;

import javax.swing.Action;
import org.netbeans.modules.db.mysql.Database;
import org.netbeans.modules.db.mysql.DatabaseServer;
import org.netbeans.modules.db.mysql.actions.ConnectAction;
import org.openide.actions.DeleteAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.actions.SystemAction;

class DatabaseNode
extends AbstractNode
implements Comparable {
    private static final String ICON_BASE = "org/netbeans/modules/db/mysql/resources/database.gif";
    private final Database model;

    public DatabaseNode(Database database) {
        super(Children.LEAF);
        this.model = database;
        this.setDisplayName(database.getDisplayName());
        this.setShortDescription(database.getShortDescription());
        this.setIconBaseWithExtension(ICON_BASE);
    }

    public Action[] getActions(boolean bl) {
        if (bl) {
            return super.getActions(bl);
        }
        return new SystemAction[]{SystemAction.get(ConnectAction.class), SystemAction.get(DeleteAction.class)};
    }

    public boolean canDestroy() {
        return true;
    }

    public void destroy() {
        DatabaseServer databaseServer = this.model.getServer();
        String string = this.model.getDbName();
        databaseServer.dropDatabase(string);
    }

    public Node.Cookie getCookie(Class clazz) {
        if (clazz == Database.class) {
            return this.model;
        }
        return super.getCookie(clazz);
    }

    public int compareTo(Object object) {
        Node node = (Node)object;
        return this.getDisplayName().compareTo(node.getDisplayName());
    }
}

