/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.diff;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import org.netbeans.api.diff.Difference;
import org.netbeans.modules.versioning.diff.DiffSidebar;
import org.netbeans.modules.versioning.diff.DiffTooltipActionsPanel;
import org.netbeans.modules.versioning.diff.DiffTooltipContentPanel;

class DiffActionTooltipWindow
implements AWTEventListener,
WindowFocusListener {
    private static final int SCREEN_BORDER = 20;
    private JWindow actionsWindow;
    private JWindow contentWindow;
    private final DiffSidebar master;
    private final Difference diff;

    public DiffActionTooltipWindow(DiffSidebar diffSidebar, Difference difference) {
        this.master = diffSidebar;
        this.diff = difference;
        Window window = SwingUtilities.windowForComponent(diffSidebar.getTextComponent());
        this.actionsWindow = new JWindow(window);
        if (difference.getType() != 1) {
            this.contentWindow = new JWindow(window);
        }
    }

    DiffSidebar getMaster() {
        return this.master;
    }

    public void show(Point point) {
        DiffTooltipActionsPanel diffTooltipActionsPanel = new DiffTooltipActionsPanel(this, this.diff);
        this.actionsWindow.add(diffTooltipActionsPanel);
        this.actionsWindow.pack();
        this.actionsWindow.setLocation(point);
        if (this.contentWindow != null) {
            GraphicsDevice graphicsDevice;
            GraphicsConfiguration graphicsConfiguration;
            GraphicsDevice[] graphicsDeviceArray;
            DiffTooltipContentPanel diffTooltipContentPanel = new DiffTooltipContentPanel(this.master.getTextComponent(), this.master.getMimeType(), this.diff);
            this.contentWindow.add(diffTooltipContentPanel);
            this.contentWindow.pack();
            Dimension dimension = this.contentWindow.getSize();
            Rectangle rectangle = null;
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice[] graphicsDeviceArray2 = graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
            int n = graphicsDeviceArray2.length;
            for (int i = 0; i < n && !(rectangle = (graphicsConfiguration = (graphicsDevice = graphicsDeviceArray2[i]).getDefaultConfiguration()).getBounds()).contains(point); ++i) {
            }
            if (point.y + dimension.height + 20 > rectangle.y + rectangle.height) {
                dimension.height = rectangle.y + rectangle.height - (point.y + 20);
            }
            if (point.x + dimension.width + 20 > rectangle.x + rectangle.width) {
                dimension.width = rectangle.x + rectangle.width - (point.x + 20);
            }
            if (dimension.width < this.actionsWindow.getWidth()) {
                dimension.width = this.actionsWindow.getWidth();
            }
            this.contentWindow.setSize(dimension);
            this.contentWindow.setLocation(point.x, point.y + this.actionsWindow.getHeight() - 1);
            this.contentWindow.setVisible(true);
        }
        this.actionsWindow.setVisible(true);
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 16L);
        this.actionsWindow.addWindowFocusListener(this);
        this.actionsWindow.getOwner().addWindowFocusListener(this);
    }

    public void eventDispatched(AWTEvent aWTEvent) {
        if (aWTEvent.getID() == 501) {
            this.onClick(aWTEvent);
        }
    }

    private void onClick(AWTEvent aWTEvent) {
        Component component = (Component)aWTEvent.getSource();
        Window window = SwingUtilities.windowForComponent(component);
        if (window != this.actionsWindow && (this.contentWindow == null || window != this.contentWindow)) {
            this.shutdown();
        }
    }

    public void windowGainedFocus(WindowEvent windowEvent) {
    }

    public void windowLostFocus(WindowEvent windowEvent) {
        if (this.actionsWindow != null && windowEvent.getOppositeWindow() != this.actionsWindow && windowEvent.getOppositeWindow() != this.actionsWindow.getOwner() && windowEvent.getOppositeWindow() != this.contentWindow) {
            this.shutdown();
        }
    }

    void shutdown() {
        Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        this.actionsWindow.getOwner().removeWindowFocusListener(this);
        this.actionsWindow.removeWindowFocusListener(this);
        this.actionsWindow.dispose();
        if (this.contentWindow != null) {
            this.contentWindow.dispose();
        }
    }
}

