/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.modules.versioning.Accessor;
import org.netbeans.modules.versioning.FlatFolder;
import org.netbeans.modules.versioning.VersioningManager;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.spi.VersioningSupport;
import org.netbeans.modules.versioning.spi.VersioningSystem;
import org.openide.awt.Actions;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.actions.Presenter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    private static final RequestProcessor vcsBlockingRequestProcessor = new RequestProcessor("Versioning long tasks", 1);
    private static FileSystem filesystem;

    public static VCSContext contextForLookup(Lookup lookup) {
        Lookup.Result result = lookup.lookup(new Lookup.Template(Node.class));
        Collection collection = result.allInstances();
        return VCSContext.forNodes(collection.toArray(new Node[collection.size()]));
    }

    public static VCSContext contextForFileObjects(Set<? extends FileObject> set) {
        HashSet<File> hashSet = new HashSet<File>(set.size());
        if (set instanceof NonRecursiveFolder) {
            FileObject fileObject = ((NonRecursiveFolder)set).getFolder();
            hashSet.add(new FlatFolder(FileUtil.toFile((FileObject)fileObject).getAbsolutePath()));
        } else {
            for (FileObject fileObject : set) {
                hashSet.add(FileUtil.toFile((FileObject)fileObject));
            }
        }
        return Accessor.VCSContextAccessor.createContextForFiles(hashSet, set);
    }

    public static boolean isAncestorOrEqual(File file, File file2) {
        if (VersioningSupport.isFlat(file)) {
            return file.equals(file2) || file.equals(file2.getParentFile()) && !file2.isDirectory();
        }
        String string = file2.getAbsolutePath();
        String string2 = file.getAbsolutePath();
        if (Utilities.isWindows() ? string.indexOf("~") < 0 && string2.indexOf("~") < 0 && string.length() < string2.length() : (Utilities.isMac() ? string.length() < string2.length() : !string.startsWith(string2))) {
            return false;
        }
        while (file2 != null) {
            if (file2.equals(file)) {
                return true;
            }
            file2 = file2.getParentFile();
        }
        return false;
    }

    public static JMenuItem toMenuItem(Action action) {
        JMenuItem jMenuItem;
        if (action instanceof Presenter.Menu) {
            jMenuItem = ((Presenter.Menu)action).getMenuPresenter();
        } else {
            jMenuItem = new JMenuItem();
            Actions.connect((JMenuItem)jMenuItem, (Action)action, (boolean)false);
        }
        return jMenuItem;
    }

    public static File getTempFolder() {
        File file;
        File file2 = new File(System.getProperty("java.io.tmpdir"));
        while ((file = new File(file2, "vcs-" + Long.toString(System.currentTimeMillis()))).exists() || !file.mkdirs()) {
        }
        file.deleteOnExit();
        return FileUtil.normalizeFile((File)file);
    }

    public static void deleteRecursively(File file) {
        Utils.deleteRecursively(file, Level.WARNING);
    }

    public static void deleteRecursively(File file, Level level) {
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject == null) {
            return;
        }
        try {
            fileObject.delete();
        }
        catch (IOException iOException) {
            Logger.getLogger(Utils.class.getName()).log(level, "", iOException);
        }
    }

    public static boolean isLocalHistory(VersioningSystem versioningSystem) {
        return versioningSystem.getProperty("Boolean VCS.LocalHistory") != null;
    }

    public static Reader getDocumentReader(final Document document) {
        final String[] stringArray = new String[1];
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    stringArray[0] = document.getText(0, document.getLength());
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
        };
        document.render(runnable);
        return new StringReader(stringArray[0]);
    }

    public static RequestProcessor.Task createTask(Runnable runnable) {
        return vcsBlockingRequestProcessor.create(runnable);
    }

    public static String getDisplayName(VersioningSystem versioningSystem) {
        return (String)versioningSystem.getProperty("String VCS.DisplayName");
    }

    public static String getMenuLabel(VersioningSystem versioningSystem) {
        return (String)versioningSystem.getProperty("String VCS.MenuLabel");
    }

    public static JSeparator createJSeparator() {
        JMenu jMenu = new JMenu();
        jMenu.addSeparator();
        return (JSeparator)jMenu.getPopupMenu().getComponent(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isFile(File file) {
        long l = System.currentTimeMillis();
        try {
            boolean bl = file.isFile();
            return bl;
        }
        finally {
            Utils.logLasting(file, System.currentTimeMillis() - l, "Utils.isFile: java.io.File.isFile takes too much time ({0} ms): {1}, stacktrace:");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean exists(File file) {
        long l = System.currentTimeMillis();
        try {
            boolean bl = file.exists();
            return bl;
        }
        finally {
            Utils.logLasting(file, System.currentTimeMillis() - l, "Utils.exists: java.io.File.exists takes too much time ({0} ms): {1}, stacktrace:");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canWrite(File file) {
        long l = System.currentTimeMillis();
        try {
            boolean bl = file.canWrite();
            return bl;
        }
        finally {
            Utils.logLasting(file, System.currentTimeMillis() - l, "Utils.canWrite: java.io.File.canWrite takes too much time ({0} ms): {1}, stacktrace:");
        }
    }

    static FileSystem getRootFilesystem() {
        if (filesystem == null) {
            try {
                String string = System.getProperty("netbeans.user");
                FileObject fileObject = FileUtil.toFileObject((File)new File(string));
                filesystem = fileObject.getFileSystem();
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                VersioningManager.LOG.log(Level.WARNING, null, fileStateInvalidException);
            }
        }
        return filesystem;
    }

    private static void logLasting(File file, long l, String string) {
        boolean bl = false;
        if (!$assertionsDisabled) {
            bl = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (bl && l > 1500L) {
            StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
            StringBuilder stringBuilder = new StringBuilder();
            int n = 0;
            for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                if (n++ <= 1) continue;
                if (n == 8) {
                    stringBuilder.append("...\n");
                    break;
                }
                stringBuilder.append(stackTraceElement.toString() + "\n");
            }
            Logger.getLogger(Utils.class.getName()).log(Level.INFO, string, new String[]{Long.toString(l), file.getAbsolutePath()});
            Logger.getLogger(Utils.class.getName()).log(Level.INFO, stringBuilder.toString());
        }
    }
}

