/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.earproject.ui;

import java.awt.Image;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.j2ee.spi.ejbjar.support.J2eeProjectView;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.actions.FindAction;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.ChangeableDataFilter;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.ChangeSupport;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

class ArchiveViews {
    private ArchiveViews() {
    }

    private static final class DocBaseNode
    extends FilterNode {
        private static final DataFilter VISIBILITY_QUERY_FILTER = new VisibilityQueryDataFilter();
        private final Image CONFIGURATION_FILES_BADGE = ImageUtilities.loadImage((String)"org/netbeans/modules/j2ee/earproject/ui/resources/archive.gif", (boolean)true);

        public DocBaseNode(DataFolder dataFolder) {
            super(dataFolder.getNodeDelegate(), dataFolder.createNodeChildren(VISIBILITY_QUERY_FILTER));
        }

        public Image getIcon(int n) {
            return this.computeIcon(false, n);
        }

        public Image getOpenedIcon(int n) {
            return this.computeIcon(true, n);
        }

        private Image computeIcon(boolean bl, int n) {
            Node node = this.getOriginal();
            Image image = bl ? node.getOpenedIcon(n) : node.getIcon(n);
            return ImageUtilities.mergeImages((Image)image, (Image)this.CONFIGURATION_FILES_BADGE, (int)7, (int)7);
        }

        public boolean canCopy() {
            return false;
        }

        public boolean canCut() {
            return false;
        }

        public boolean canRename() {
            return false;
        }

        public boolean canDestroy() {
            return false;
        }

        public Action[] getActions(boolean bl) {
            return new Action[]{SystemAction.get(FindAction.class)};
        }

        public String getDisplayName() {
            return NbBundle.getMessage(ArchiveViews.class, (String)"LBL_Node_DocBase");
        }
    }

    private static final class VisibilityQueryDataFilter
    implements ChangeListener,
    ChangeableDataFilter {
        private static final long serialVersionUID = 1L;
        final ChangeSupport changeSupport = new ChangeSupport((Object)this);

        public VisibilityQueryDataFilter() {
            VisibilityQuery.getDefault().addChangeListener((ChangeListener)this);
        }

        public boolean acceptDataObject(DataObject dataObject) {
            FileObject fileObject = dataObject.getPrimaryFile();
            return VisibilityQuery.getDefault().isVisible(fileObject);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            this.changeSupport.fireChange();
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.changeSupport.addChangeListener(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.changeSupport.removeChangeListener(changeListener);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class LogicalViewChildren
    extends Children.Keys<String>
    implements FileChangeListener {
        private static final String KEY_DOC_BASE = "docBase";
        private static final String KEY_SETUP_DIR = "setupDir";
        private final Project project;
        private final AntProjectHelper helper;
        private final PropertyEvaluator evaluator;
        private final FileObject projectDir;

        public LogicalViewChildren(Project project, AntProjectHelper antProjectHelper, PropertyEvaluator propertyEvaluator) {
            assert (project != null);
            this.project = project;
            assert (antProjectHelper != null);
            this.helper = antProjectHelper;
            this.projectDir = antProjectHelper.getProjectDirectory();
            this.evaluator = propertyEvaluator;
        }

        protected void addNotify() {
            super.addNotify();
            this.projectDir.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this, (Object)this.projectDir));
            this.createNodes();
        }

        private void createNodes() {
            ArrayList<String> arrayList = new ArrayList<String>();
            DataFolder dataFolder = this.getFolder("meta.inf");
            if (dataFolder != null) {
                arrayList.add(KEY_DOC_BASE);
            }
            arrayList.add(KEY_SETUP_DIR);
            this.setKeys(arrayList);
        }

        protected void removeNotify() {
            this.setKeys(Collections.emptySet());
            this.projectDir.removeFileChangeListener((FileChangeListener)this);
            super.removeNotify();
        }

        protected Node[] createNodes(String string) {
            Node[] nodeArray;
            DocBaseNode docBaseNode = null;
            if (string == KEY_DOC_BASE) {
                docBaseNode = new DocBaseNode(this.getFolder("meta.inf"));
            } else if (string == KEY_SETUP_DIR) {
                docBaseNode = J2eeProjectView.createServerResourcesNode((Project)this.project);
            }
            if (docBaseNode == null) {
                nodeArray = new Node[]{};
            } else {
                Node[] nodeArray2 = new Node[1];
                nodeArray = nodeArray2;
                nodeArray2[0] = docBaseNode;
            }
            return nodeArray;
        }

        private DataFolder getFolder(String string) {
            FileObject fileObject;
            String string2 = this.evaluator.getProperty(string);
            if (string2 != null && (fileObject = this.helper.resolveFileObject(string2)) != null && fileObject.isValid() && fileObject.isFolder()) {
                DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
                return dataFolder;
            }
            return null;
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        }

        public void fileChanged(FileEvent fileEvent) {
        }

        public void fileDataCreated(FileEvent fileEvent) {
        }

        public void fileDeleted(FileEvent fileEvent) {
            this.createNodes();
        }

        public void fileFolderCreated(FileEvent fileEvent) {
            this.createNodes();
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            this.createNodes();
        }
    }
}

