/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.spi.AbstractHint;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyncOnNonFinal
extends AbstractHint {
    public SyncOnNonFinal() {
        super(true, false, AbstractHint.HintSeverity.WARNING, new String[0]);
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(SyncOnNonFinal.class, (String)"DSC_SynchronizationOnNonFinalField");
    }

    @Override
    public Set<Tree.Kind> getTreeKinds() {
        return EnumSet.of(Tree.Kind.SYNCHRONIZED);
    }

    @Override
    public List<ErrorDescription> run(CompilationInfo compilationInfo, TreePath treePath) {
        if (!this.getTreeKinds().contains((Object)treePath.getLeaf().getKind())) {
            return null;
        }
        ExpressionTree expressionTree = ((SynchronizedTree)treePath.getLeaf()).getExpression();
        Element element = compilationInfo.getTrees().getElement(new TreePath(treePath, expressionTree));
        if (element == null || element.getKind() != ElementKind.FIELD || element.getModifiers().contains((Object)Modifier.FINAL)) {
            return null;
        }
        int n = (int)compilationInfo.getTrees().getSourcePositions().getStartPosition(compilationInfo.getCompilationUnit(), expressionTree);
        int n2 = (int)compilationInfo.getTrees().getSourcePositions().getEndPosition(compilationInfo.getCompilationUnit(), expressionTree);
        String string = NbBundle.getMessage(SyncOnNonFinal.class, (String)"ERR_SynchronizationOnNonFinalField");
        return Collections.singletonList(ErrorDescriptionFactory.createErrorDescription((Severity)this.getSeverity().toEditorSeverity(), (String)string, (FileObject)compilationInfo.getFileObject(), (int)n, (int)n2));
    }

    @Override
    public String getId() {
        return SyncOnNonFinal.class.getName();
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(SyncOnNonFinal.class, (String)"DN_SynchronizationOnNonFinalField");
    }

    @Override
    public void cancel() {
    }
}

