/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.editor.codegen.GeneratorUtils;
import org.netbeans.modules.java.hints.spi.AbstractHint;
import org.netbeans.modules.java.hints.spi.support.FixFactory;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerialVersionUID
extends AbstractHint {
    private static final String SIMPLE_SERIALIZABLE = "Serializable";
    private static final Set<Tree.Kind> TREE_KINDS = EnumSet.of(Tree.Kind.CLASS);
    private static final String SERIAL = "serial";
    private static final String SVUID = "serialVersionUID";
    private static final String SERIALIZABLE = "java.io.Serializable";
    private final AtomicBoolean cancel = new AtomicBoolean();

    public SerialVersionUID() {
        super(false, false, AbstractHint.HintSeverity.WARNING, new String[0]);
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(this.getClass(), (String)"DSC_SerialVersionUID");
    }

    @Override
    public Set<Tree.Kind> getTreeKinds() {
        return TREE_KINDS;
    }

    @Override
    public List<ErrorDescription> run(CompilationInfo compilationInfo, TreePath treePath) {
        if (treePath == null || treePath.getLeaf().getKind() != Tree.Kind.CLASS) {
            return null;
        }
        this.cancel.set(false);
        TypeElement typeElement = (TypeElement)compilationInfo.getTrees().getElement(treePath);
        if (typeElement == null || typeElement.getKind() == ElementKind.INTERFACE || typeElement.getKind() == ElementKind.ENUM || !this.isSerializable(typeElement) || this.hasSerialVersionUID(typeElement) || SerialVersionUID.hasSuppressWarning(typeElement, SERIAL)) {
            return null;
        }
        ArrayList<Fix> arrayList = new ArrayList<Fix>();
        arrayList.add(new FixImpl(TreePathHandle.create((TreePath)treePath, (CompilationInfo)compilationInfo), false));
        ErrorDescription errorDescription = null;
        String string = NbBundle.getMessage(this.getClass(), (String)"ERR_SerialVersionUID");
        if (typeElement.getNestingKind().equals((Object)NestingKind.ANONYMOUS)) {
            SourcePositions sourcePositions = compilationInfo.getTrees().getSourcePositions();
            ExpressionTree expressionTree = null;
            for (Tree tree : treePath) {
                if (!tree.getKind().equals((Object)Tree.Kind.NEW_CLASS)) continue;
                expressionTree = ((NewClassTree)tree).getIdentifier();
                break;
            }
            if (expressionTree == null) {
                return null;
            }
            long l = sourcePositions.getStartPosition(compilationInfo.getCompilationUnit(), expressionTree);
            long l2 = sourcePositions.getEndPosition(compilationInfo.getCompilationUnit(), expressionTree);
            errorDescription = ErrorDescriptionFactory.createErrorDescription((Severity)this.getSeverity().toEditorSeverity(), (String)string, arrayList, (FileObject)compilationInfo.getFileObject(), (int)((int)l), (int)((int)l2));
        } else {
            arrayList.addAll(FixFactory.createSuppressWarnings(compilationInfo, treePath, SERIAL));
            int[] nArray = compilationInfo.getTreeUtilities().findNameSpan((ClassTree)treePath.getLeaf());
            if (nArray == null) {
                return null;
            }
            errorDescription = ErrorDescriptionFactory.createErrorDescription((Severity)this.getSeverity().toEditorSeverity(), (String)string, arrayList, (FileObject)compilationInfo.getFileObject(), (int)nArray[0], (int)nArray[1]);
        }
        if (this.cancel.get()) {
            return null;
        }
        return Collections.singletonList(errorDescription);
    }

    @Override
    public String getId() {
        return this.getClass().getName();
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(this.getClass(), (String)"DN_SerialVersionUID");
    }

    @Override
    public void cancel() {
        this.cancel.set(true);
    }

    private boolean isSerializable(TypeElement typeElement) {
        if (typeElement.getNestingKind().equals((Object)NestingKind.ANONYMOUS) && ((Object)typeElement.getSuperclass()).toString().equals(SIMPLE_SERIALIZABLE)) {
            return true;
        }
        for (TypeElement typeElement2 : GeneratorUtils.getAllParents((TypeElement)typeElement)) {
            if (typeElement2.getKind() != ElementKind.INTERFACE || !typeElement2.getQualifiedName().contentEquals(SERIALIZABLE)) continue;
            return true;
        }
        return false;
    }

    private boolean hasSerialVersionUID(TypeElement typeElement) {
        for (VariableElement variableElement : ElementFilter.fieldsIn(typeElement.getEnclosedElements())) {
            TypeMirror typeMirror;
            Set<Modifier> set;
            if (!variableElement.getSimpleName().contentEquals(SVUID) || !(set = variableElement.getModifiers()).containsAll(EnumSet.of(Modifier.STATIC, Modifier.FINAL)) || (typeMirror = variableElement.asType()).getKind() == null || typeMirror.getKind() != TypeKind.LONG) continue;
            return true;
        }
        return false;
    }

    private static boolean hasSuppressWarning(TypeElement typeElement, String string) {
        SuppressWarnings suppressWarnings = typeElement.getAnnotation(SuppressWarnings.class);
        if (suppressWarnings != null) {
            for (String string2 : suppressWarnings.value()) {
                if (!string2.equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FixImpl
    implements Fix,
    Task<WorkingCopy> {
        private static final int ENUM_FLAG = 16384;
        private final TreePathHandle handle;
        private final boolean generated;

        public FixImpl(TreePathHandle treePathHandle, boolean bl) {
            this.handle = treePathHandle;
            this.generated = bl;
            if (bl) {
                throw new UnsupportedOperationException("TODO: implement");
            }
        }

        public String getText() {
            if (this.generated) {
                return NbBundle.getMessage(this.getClass(), (String)"HINT_SerialVersionUID_Generated");
            }
            return NbBundle.getMessage(this.getClass(), (String)"HINT_SerialVersionUID");
        }

        public ChangeInfo implement() throws Exception {
            JavaSource javaSource = JavaSource.forFileObject((FileObject)this.handle.getFileObject());
            javaSource.runModificationTask((Task)this).commit();
            return null;
        }

        public void run(WorkingCopy workingCopy) throws Exception {
            if (workingCopy.toPhase(JavaSource.Phase.RESOLVED).compareTo((Enum)JavaSource.Phase.RESOLVED) < 0) {
                return;
            }
            TreePath treePath = this.handle.resolve((CompilationInfo)workingCopy);
            if (treePath == null || treePath.getLeaf().getKind() != Tree.Kind.CLASS) {
                return;
            }
            ClassTree classTree = (ClassTree)treePath.getLeaf();
            TreeMaker treeMaker = workingCopy.getTreeMaker();
            EnumSet<Modifier> enumSet = EnumSet.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL);
            VariableTree variableTree = treeMaker.Variable(treeMaker.Modifiers(enumSet), (CharSequence)SerialVersionUID.SVUID, (Tree)treeMaker.Identifier((CharSequence)"long"), (ExpressionTree)treeMaker.Literal((Object)1L));
            ClassTree classTree2 = GeneratorUtilities.get((WorkingCopy)workingCopy).insertClassMember(classTree, (Tree)variableTree);
            workingCopy.rewrite((Tree)classTree, (Tree)classTree2);
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            FixImpl fixImpl = (FixImpl)object;
            if (!(this.handle == fixImpl.handle || this.handle != null && this.handle.equals((Object)fixImpl.handle))) {
                return false;
            }
            return this.generated == fixImpl.generated;
        }

        public int hashCode() {
            int n = 5;
            n = 41 * n + (this.handle != null ? this.handle.hashCode() : 0);
            n = 41 * n + (this.generated ? 1 : 0);
            return n;
        }
    }
}

