/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.catalog;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import org.netbeans.modules.xml.catalog.CatalogPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.cookies.ViewCookie;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CatalogAction
extends CallableSystemAction {
    private Reference<Dialog> dialogWRef = new WeakReference<Object>(null);

    public CatalogAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public void performAction() {
        Dialog dialog = this.dialogWRef.get();
        if (dialog == null || !dialog.isShowing()) {
            CatalogPanel catalogPanel = new CatalogPanel();
            JButton jButton = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)jButton, (String)NbBundle.getMessage(CatalogAction.class, (String)"BTN_CatalogPanel_CloseButton"));
            JButton jButton2 = new JButton();
            jButton2.setEnabled(false);
            OpenInEditorListener openInEditorListener = new OpenInEditorListener(catalogPanel, jButton2);
            jButton2.addActionListener(openInEditorListener);
            catalogPanel.getExplorerManager().addPropertyChangeListener((PropertyChangeListener)openInEditorListener);
            Mnemonics.setLocalizedText((AbstractButton)jButton2, (String)NbBundle.getMessage(CatalogAction.class, (String)"BTN_CatalogPanel_OpenInEditorButton"));
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)catalogPanel, NbBundle.getMessage(CatalogAction.class, (String)"LBL_CatalogPanel_Title"), false, new Object[]{jButton2, jButton}, (Object)jButton, 0, null, null);
            dialogDescriptor.setClosingOptions(null);
            dialogDescriptor.setHelpCtx(null);
            dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            dialog.setVisible(true);
            this.dialogWRef = new WeakReference<Dialog>(dialog);
        } else {
            dialog.toFront();
        }
    }

    protected boolean asynchronous() {
        return true;
    }

    public String getName() {
        return NbBundle.getMessage(CatalogAction.class, (String)"LBL_CatalogAction_Name");
    }

    protected String iconResource() {
        return null;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected void initialize() {
        super.initialize();
        this.putProperty("ShortDescription", NbBundle.getMessage(CatalogAction.class, (String)"HINT_CatalogAction"));
    }

    private static Set<Node> getNodes2Open(Node[] nodeArray) {
        HashSet<Node> hashSet = new HashSet<Node>(nodeArray.length);
        for (int i = 0; i < nodeArray.length; ++i) {
            if (nodeArray[i].isLeaf()) {
                hashSet.add(nodeArray[i]);
                continue;
            }
            hashSet.addAll(CatalogAction.getNodes2Open(nodeArray[i].getChildren().getNodes(true)));
        }
        return hashSet;
    }

    private static class OpenInEditorListener
    implements ActionListener,
    PropertyChangeListener {
        CatalogPanel cp;
        JButton b;

        public OpenInEditorListener(CatalogPanel catalogPanel, JButton jButton) {
            this.cp = catalogPanel;
            this.b = jButton;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Node[] nodeArray = this.cp.getExplorerManager().getSelectedNodes();
            assert (nodeArray != null && nodeArray.length > 0) : "Selected templates cannot be null or empty.";
            Set set = CatalogAction.getNodes2Open(nodeArray);
            assert (!set.isEmpty()) : "Selected templates to open cannot by empty for nodes " + Arrays.asList(nodeArray);
            for (Node node : set) {
                ViewCookie viewCookie = (ViewCookie)node.getLookup().lookup(ViewCookie.class);
                if (viewCookie != null) {
                    viewCookie.view();
                    continue;
                }
                assert (false) : "Node " + node + " has to have a VewCookie.";
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("selectedNodes".equals(propertyChangeEvent.getPropertyName())) {
                Node[] nodeArray = (Node[])propertyChangeEvent.getNewValue();
                boolean bl = nodeArray != null;
                for (int i = 0; bl && i < nodeArray.length; ++i) {
                    Node node = nodeArray[i];
                    ViewCookie viewCookie = (ViewCookie)node.getLookup().lookup(ViewCookie.class);
                    bl = viewCookie != null;
                }
                this.b.setEnabled(bl);
            }
        }
    }
}

