/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.node;

import org.netbeans.api.db.explorer.node.BaseNode;
import org.netbeans.api.db.explorer.node.NodeProvider;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.node.NodeDataLookup;
import org.netbeans.modules.db.explorer.node.NodeRegistry;
import org.netbeans.modules.db.metadata.model.api.Action;
import org.netbeans.modules.db.metadata.model.api.Metadata;
import org.netbeans.modules.db.metadata.model.api.MetadataElementHandle;
import org.netbeans.modules.db.metadata.model.api.MetadataModel;
import org.netbeans.modules.db.metadata.model.api.MetadataModelException;
import org.netbeans.modules.db.metadata.model.api.Parameter;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ProcedureParamNode
extends BaseNode {
    private static final String IN = "org/netbeans/modules/db/resources/paramIn.gif";
    private static final String OUT = "org/netbeans/modules/db/resources/paramOut.gif";
    private static final String INOUT = "org/netbeans/modules/db/resources/paramInOut.gif";
    private static final String FOLDER = "ProcedureParam";
    private String name = "";
    private String icon = "";
    private final MetadataElementHandle<Parameter> paramHandle = (MetadataElementHandle)this.getLookup().lookup(MetadataElementHandle.class);
    private final DatabaseConnection connection = (DatabaseConnection)this.getLookup().lookup(DatabaseConnection.class);

    public static ProcedureParamNode create(NodeDataLookup nodeDataLookup, NodeProvider nodeProvider) {
        ProcedureParamNode procedureParamNode = new ProcedureParamNode(nodeDataLookup, nodeProvider);
        procedureParamNode.setup();
        return procedureParamNode;
    }

    private ProcedureParamNode(NodeDataLookup nodeDataLookup, NodeProvider nodeProvider) {
        super(nodeDataLookup, FOLDER, nodeProvider);
    }

    public synchronized void refresh() {
        this.setupNames();
        super.refresh();
    }

    private void setupNames() {
        boolean bl = !this.connection.getConnector().isDisconnected();
        MetadataModel metadataModel = this.connection.getMetadataModel();
        if (bl && metadataModel != null) {
            try {
                metadataModel.runReadAction((Action)new Action<Metadata>(){

                    public void run(Metadata metadata) {
                        Parameter parameter = (Parameter)ProcedureParamNode.this.paramHandle.resolve(metadata);
                        if (parameter != null) {
                            ProcedureParamNode.this.name = parameter.getName();
                            switch (parameter.getDirection()) {
                                case IN: {
                                    ProcedureParamNode.this.icon = ProcedureParamNode.IN;
                                    break;
                                }
                                case OUT: {
                                    ProcedureParamNode.this.icon = ProcedureParamNode.OUT;
                                    break;
                                }
                                case INOUT: {
                                    ProcedureParamNode.this.icon = ProcedureParamNode.INOUT;
                                }
                            }
                            ProcedureParamNode.this.updateProperties(parameter);
                        }
                    }
                });
            }
            catch (MetadataModelException metadataModelException) {
                NodeRegistry.handleMetadataModelException(((Object)((Object)this)).getClass(), this.connection, metadataModelException, true);
            }
        }
    }

    private void updateProperties(Parameter parameter) {
        PropertySupport.Name name = new PropertySupport.Name((Node)this);
        this.addProperty((Node.Property)name);
        switch (parameter.getDirection()) {
            case IN: {
                this.addProperty("Type", "TypeDescription", String.class, false, NbBundle.getMessage(ProcedureParamNode.class, (String)"In"));
                break;
            }
            case OUT: {
                this.addProperty("Type", "TypeDescription", String.class, false, NbBundle.getMessage(ProcedureParamNode.class, (String)"Out"));
                break;
            }
            case INOUT: {
                this.addProperty("Type", "TypeDescription", String.class, false, NbBundle.getMessage(ProcedureParamNode.class, (String)"InOut"));
            }
        }
        this.addProperty("Datatype", "DatatypeDescription", String.class, false, parameter.getType().toString());
    }

    protected void initialize() {
        this.setupNames();
    }

    public int getPosition() {
        MetadataModel metadataModel = this.connection.getMetadataModel();
        final int[] nArray = new int[1];
        try {
            metadataModel.runReadAction((Action)new Action<Metadata>(){

                public void run(Metadata metadata) {
                    Parameter parameter = (Parameter)ProcedureParamNode.this.paramHandle.resolve(metadata);
                    nArray[0] = parameter.getOrdinalPosition();
                }
            });
        }
        catch (MetadataModelException metadataModelException) {
            NodeRegistry.handleMetadataModelException(((Object)((Object)this)).getClass(), this.connection, metadataModelException, true);
        }
        return nArray[0];
    }

    public String getIconBase() {
        return this.icon;
    }

    public String getName() {
        return this.name;
    }

    public String getShortDescription() {
        return NbBundle.getMessage(ProcedureParamNode.class, (String)"ND_ProcedureParam");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(ProcedureParamNode.class);
    }
}

