/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.metadata;

import java.sql.Connection;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.DbMetaDataListener;
import org.netbeans.modules.db.metadata.model.api.Action;
import org.netbeans.modules.db.metadata.model.api.Metadata;
import org.netbeans.modules.db.metadata.model.api.MetadataModel;
import org.netbeans.modules.db.metadata.model.api.MetadataModelException;
import org.netbeans.modules.db.metadata.model.api.MetadataModels;
import org.netbeans.modules.db.metadata.model.api.Table;
import org.openide.util.Mutex;

public class MetadataModelManager {
    private static final Logger LOGGER = Logger.getLogger(MetadataModelManager.class.getName());
    private static final WeakHashMap<DatabaseConnection, MetadataModel> conn2Model = new WeakHashMap();

    private MetadataModelManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MetadataModel get(DatabaseConnection databaseConnection) {
        Class<MetadataModelManager> clazz = MetadataModelManager.class;
        synchronized (MetadataModelManager.class) {
            Connection connection = MetadataModelManager.checkAndGetConnection(databaseConnection);
            MetadataModel metadataModel = conn2Model.get(databaseConnection);
            if (metadataModel == null) {
                metadataModel = MetadataModels.createModel((Connection)connection, (String)databaseConnection.getSchema());
                conn2Model.put(databaseConnection, metadataModel);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return metadataModel;
        }
    }

    private static Connection checkAndGetConnection(final DatabaseConnection databaseConnection) {
        Connection connection = databaseConnection.getJDBCConnection();
        if (connection == null) {
            connection = (Connection)Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<Connection>(){

                public Connection run() {
                    ConnectionManager.getDefault().showConnectionDialog(databaseConnection);
                    return databaseConnection.getJDBCConnection();
                }
            });
        }
        return connection;
    }

    private static final class Listener
    implements DbMetaDataListener {
        private static Listener create() {
            return new Listener();
        }

        private Listener() {
        }

        public void tablesChanged(DatabaseConnection databaseConnection) {
            Connection connection = MetadataModelManager.checkAndGetConnection(databaseConnection);
            if (connection == null) {
                return;
            }
            try {
                MetadataModelManager.get(databaseConnection).runReadAction((Action)new Action<Metadata>(){

                    public void run(Metadata metadata) {
                        metadata.refresh();
                    }
                });
            }
            catch (MetadataModelException metadataModelException) {
                LOGGER.log(Level.INFO, metadataModelException.getMessage(), metadataModelException);
            }
        }

        public void tableChanged(DatabaseConnection databaseConnection, final String string) {
            Connection connection = MetadataModelManager.checkAndGetConnection(databaseConnection);
            if (connection == null) {
                return;
            }
            try {
                MetadataModelManager.get(databaseConnection).runReadAction((Action)new Action<Metadata>(){

                    public void run(Metadata metadata) {
                        Table table = metadata.getDefaultSchema().getTable(string);
                        if (table != null) {
                            metadata.getDefaultSchema().getTable(string).refresh();
                        } else {
                            LOGGER.log(Level.INFO, "Table '" + string + "' that was just changed no longer exists");
                        }
                    }
                });
            }
            catch (MetadataModelException metadataModelException) {
                LOGGER.log(Level.INFO, metadataModelException.getMessage(), metadataModelException);
            }
        }
    }
}

