/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.action;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.lib.ddl.DDLException;
import org.netbeans.modules.db.ExceptionListener;
import org.netbeans.modules.db.explorer.ConnectionList;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.DbUtilities;
import org.netbeans.modules.db.explorer.action.BaseAction;
import org.netbeans.modules.db.explorer.dlg.ConnectionDialog;
import org.netbeans.modules.db.explorer.dlg.ConnectionDialogMediator;
import org.netbeans.modules.db.explorer.dlg.NewConnectionPanel;
import org.netbeans.modules.db.explorer.dlg.SchemaPanel;
import org.netbeans.modules.db.explorer.driver.JDBCDriverSupport;
import org.netbeans.modules.db.explorer.node.DriverNode;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ConnectUsingDriverAction
extends BaseAction {
    private static final Logger LOGGER = Logger.getLogger(ConnectUsingDriverAction.class.getName());

    public String getName() {
        return NbBundle.getMessage(ConnectUsingDriverAction.class, (String)"ConnectUsing");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(ConnectUsingDriverAction.class);
    }

    protected boolean enable(Node[] nodeArray) {
        return nodeArray != null && nodeArray.length == 1;
    }

    public void performAction(Node[] nodeArray) {
        Lookup lookup = nodeArray[0].getLookup();
        DriverNode driverNode = (DriverNode)((Object)lookup.lookup(DriverNode.class));
        if (driverNode != null) {
            JDBCDriver jDBCDriver = driverNode.getDatabaseDriver().getJDBCDriver();
            new NewConnectionDialogDisplayer().showDialog(jDBCDriver.getName(), jDBCDriver.getClassName());
        }
    }

    public static final class NewConnectionDialogDisplayer
    extends ConnectionDialogMediator {
        ConnectionDialog dlg;
        boolean advancedPanel = false;
        boolean okPressed = false;
        RequestProcessor.Task activeTask = null;
        private NewConnectionPanel basePanel = null;
        private SchemaPanel schemaPanel = null;
        private DatabaseConnection cinfo = null;

        public void showDialog(String string, String string2) {
            this.showDialog(string, string2, null, null, null);
        }

        public DatabaseConnection showDialog(JDBCDriver jDBCDriver, String string, String string2, String string3) {
            String string4 = jDBCDriver != null ? jDBCDriver.getName() : null;
            String string5 = jDBCDriver != null ? jDBCDriver.getClassName() : null;
            return this.showDialog(string4, string5, string, string2, string3);
        }

        public DatabaseConnection showDialog(String string, String string2, String string3, String string4, String string5) {
            JDBCDriver[] jDBCDriverArray;
            String string6 = null;
            if (null != string3 && null != string2) {
                jDBCDriverArray = JDBCDriverManager.getDefault().getDrivers(string2);
                string6 = string2;
            } else {
                jDBCDriverArray = JDBCDriverManager.getDefault().getDrivers();
            }
            String string7 = null;
            String string8 = null;
            if (string == null || string2 == null) {
                for (int i = 0; i < jDBCDriverArray.length; ++i) {
                    if (!JDBCDriverSupport.isAvailable(jDBCDriverArray[i])) continue;
                    if (string7 == null) {
                        string7 = jDBCDriverArray[i].getName();
                        string8 = jDBCDriverArray[i].getClassName();
                    }
                    if (!"org.apache.derby.jdbc.ClientDriver".equals(jDBCDriverArray[i].getClassName())) continue;
                    string7 = jDBCDriverArray[i].getName();
                    string8 = jDBCDriverArray[i].getClassName();
                    break;
                }
            } else {
                string7 = string;
                string8 = string2;
            }
            this.cinfo = new DatabaseConnection();
            this.cinfo.setDriverName(string7);
            this.cinfo.setDriver(string8);
            if (string4 != null) {
                this.cinfo.setUser(string4);
            }
            if (string5 != null) {
                this.cinfo.setPassword(string5);
            }
            if (null != string3) {
                this.cinfo.setDatabase(string3);
            }
            this.basePanel = new NewConnectionPanel(this, string6, this.cinfo);
            this.schemaPanel = new SchemaPanel(this, this.cinfo);
            PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getPropertyName().equals("argumentChanged")) {
                        NewConnectionDialogDisplayer.this.schemaPanel.setSchemas(new Vector(), "");
                        NewConnectionDialogDisplayer.this.schemaPanel.resetProgress();
                        try {
                            Connection connection = NewConnectionDialogDisplayer.this.cinfo.getConnection();
                            if (DatabaseConnection.isVitalConnection(connection, NewConnectionDialogDisplayer.this.cinfo)) {
                                connection.close();
                            }
                        }
                        catch (SQLException sQLException) {
                            LOGGER.log(Level.FINE, null, sQLException);
                        }
                    }
                }
            };
            this.basePanel.addPropertyChangeListener(propertyChangeListener);
            PropertyChangeListener propertyChangeListener2 = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getPropertyName().equals("connecting")) {
                        NewConnectionDialogDisplayer.this.fireConnectionStarted();
                    } else if (propertyChangeEvent.getPropertyName().equals("failed")) {
                        NewConnectionDialogDisplayer.this.setConnected(false);
                        NewConnectionDialogDisplayer.this.fireConnectionFailed();
                    } else {
                        if (propertyChangeEvent.getPropertyName().equals("connected")) {
                            try {
                                NewConnectionDialogDisplayer.this.cinfo.getConnector().finishConnect(null, NewConnectionDialogDisplayer.this.cinfo, NewConnectionDialogDisplayer.this.cinfo.getConnection());
                            }
                            catch (DatabaseException databaseException) {
                                LOGGER.log(Level.INFO, null, databaseException);
                                DbUtilities.reportError(NbBundle.getMessage(ConnectUsingDriverAction.class, (String)"ERR_UnableToInitializeConnection"), databaseException.getMessage());
                                return;
                            }
                            NewConnectionDialogDisplayer.this.setConnected(true);
                            boolean bl = NewConnectionDialogDisplayer.this.retrieveSchemas(NewConnectionDialogDisplayer.this.schemaPanel, NewConnectionDialogDisplayer.this.cinfo, NewConnectionDialogDisplayer.this.cinfo.getUser());
                            NewConnectionDialogDisplayer.this.fireConnectionFinished();
                            if (bl) {
                                NewConnectionDialogDisplayer.this.cinfo.setSchema(NewConnectionDialogDisplayer.this.schemaPanel.getSchema());
                            } else if (!NewConnectionDialogDisplayer.this.schemaPanel.schemasAvailable()) {
                                try {
                                    ConnectionList.getDefault().add(NewConnectionDialogDisplayer.this.cinfo);
                                }
                                catch (DatabaseException databaseException) {
                                    LOGGER.log(Level.INFO, null, databaseException);
                                    DbUtilities.reportError(NbBundle.getMessage(ConnectUsingDriverAction.class, (String)"ERR_UnableToAddConnection"), databaseException.getMessage());
                                    NewConnectionDialogDisplayer.this.cinfo.setConnection(null);
                                }
                                if (NewConnectionDialogDisplayer.this.dlg != null) {
                                    NewConnectionDialogDisplayer.this.dlg.close();
                                    return;
                                }
                            }
                            NewConnectionDialogDisplayer.this.dlg.setSelectedComponent(NewConnectionDialogDisplayer.this.schemaPanel);
                            return;
                        }
                        NewConnectionDialogDisplayer.this.okPressed = false;
                    }
                }
            };
            ExceptionListener exceptionListener = new ExceptionListener(){

                public void exceptionOccurred(Exception exception) {
                    if (exception instanceof DDLException) {
                        LOGGER.log(Level.INFO, null, exception.getCause());
                    } else {
                        LOGGER.log(Level.INFO, null, exception);
                    }
                    String string = null;
                    if (exception instanceof ClassNotFoundException) {
                        string = MessageFormat.format(NbBundle.getMessage(ConnectUsingDriverAction.class, (String)"EXC_ClassNotFound"), exception.getMessage());
                    } else {
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append(DbUtilities.formatError(NbBundle.getMessage(ConnectUsingDriverAction.class, (String)"ERR_UnableToAddConnection"), exception.getMessage()));
                        if (exception instanceof DDLException && exception.getCause() instanceof SQLException) {
                            for (SQLException sQLException = ((SQLException)exception.getCause()).getNextException(); sQLException != null; sQLException = sQLException.getNextException()) {
                                stringBuffer.append("\n\n" + sQLException.getMessage());
                            }
                        }
                        string = stringBuffer.toString();
                    }
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string, 0));
                }
            };
            this.cinfo.addPropertyChangeListener(propertyChangeListener2);
            this.cinfo.addExceptionListener(exceptionListener);
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (actionEvent.getSource() == DialogDescriptor.OK_OPTION) {
                        NewConnectionDialogDisplayer.this.okPressed = true;
                        NewConnectionDialogDisplayer.this.basePanel.setConnectionInfo();
                        try {
                            if (!DatabaseConnection.isVitalConnection(NewConnectionDialogDisplayer.this.cinfo.getConnection(), NewConnectionDialogDisplayer.this.cinfo)) {
                                NewConnectionDialogDisplayer.this.activeTask = NewConnectionDialogDisplayer.this.cinfo.connectAsync();
                            } else {
                                NewConnectionDialogDisplayer.this.cinfo.setSchema(NewConnectionDialogDisplayer.this.schemaPanel.getSchema());
                                ConnectionList.getDefault().add(NewConnectionDialogDisplayer.this.cinfo);
                                if (NewConnectionDialogDisplayer.this.dlg != null) {
                                    NewConnectionDialogDisplayer.this.cancelActiveTask();
                                    NewConnectionDialogDisplayer.this.dlg.close();
                                }
                            }
                        }
                        catch (DatabaseException databaseException) {
                            LOGGER.log(Level.INFO, null, databaseException);
                            DbUtilities.reportError(NbBundle.getMessage(ConnectUsingDriverAction.class, (String)"ERR_UnableToAddConnection"), databaseException.getMessage());
                            NewConnectionDialogDisplayer.this.closeConnection();
                        }
                        return;
                    }
                    if (actionEvent.getSource() == DialogDescriptor.CANCEL_OPTION && NewConnectionDialogDisplayer.this.dlg != null) {
                        NewConnectionDialogDisplayer.this.cancelActiveTask();
                    }
                }
            };
            ChangeListener changeListener = new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    if (((JTabbedPane)changeEvent.getSource()).getSelectedComponent().equals(NewConnectionDialogDisplayer.this.schemaPanel)) {
                        NewConnectionDialogDisplayer.this.advancedPanel = true;
                        NewConnectionDialogDisplayer.this.basePanel.setConnectionInfo();
                    } else {
                        NewConnectionDialogDisplayer.this.advancedPanel = false;
                    }
                }
            };
            this.dlg = new ConnectionDialog(this, this.basePanel, this.schemaPanel, this.basePanel.getTitle(), new HelpCtx("new_db_save_password"), actionListener, changeListener);
            this.basePanel.setWindow(this.dlg.getWindow());
            this.dlg.setVisible(true);
            this.cinfo.removeExceptionListener(exceptionListener);
            this.cinfo.removePropertyChangeListener(propertyChangeListener2);
            this.cinfo.fireConnectionComplete();
            return ConnectionList.getDefault().getConnection(this.cinfo);
        }

        private void cancelActiveTask() {
            if (this.activeTask != null) {
                this.activeTask.cancel();
                this.activeTask = null;
            }
            this.basePanel.terminateProgress();
            this.schemaPanel.terminateProgress();
        }

        public void closeConnection() {
            Connection connection;
            if (this.cinfo != null && (connection = this.cinfo.getConnection()) != null) {
                try {
                    connection.close();
                    this.cinfo.setConnection(null);
                }
                catch (SQLException sQLException) {
                    this.cinfo.setConnection(null);
                }
            }
            this.setConnected(false);
        }

        protected RequestProcessor.Task retrieveSchemasAsync(SchemaPanel schemaPanel, DatabaseConnection databaseConnection, String string) {
            this.activeTask = super.retrieveSchemasAsync(schemaPanel, databaseConnection, string);
            return this.activeTask;
        }

        protected boolean retrieveSchemas(SchemaPanel schemaPanel, DatabaseConnection databaseConnection, String string) {
            this.fireConnectionStep(NbBundle.getMessage(ConnectUsingDriverAction.class, (String)"ConnectionProgress_Schemas"));
            Vector<String> vector = new Vector<String>();
            try {
                ResultSet resultSet;
                DatabaseMetaData databaseMetaData = databaseConnection.getConnection().getMetaData();
                if (databaseMetaData.supportsSchemasInTableDefinitions() && (resultSet = databaseMetaData.getSchemas()) != null) {
                    while (resultSet.next()) {
                        vector.add(resultSet.getString(1).trim());
                    }
                }
            }
            catch (SQLException sQLException) {
                String string2 = NbBundle.getMessage(ConnectUsingDriverAction.class, (String)"ERR_UnableObtainSchemas", (Object)sQLException.getMessage());
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string2, 0));
            }
            return schemaPanel.setSchemas(vector, string);
        }
    }
}

