/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.filter;

import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.netbeans.modules.tasklist.filter.KeywordsFilter;
import org.netbeans.modules.tasklist.filter.TypesFilter;
import org.netbeans.modules.tasklist.filter.Util;
import org.netbeans.modules.tasklist.impl.ScannerDescriptor;
import org.netbeans.spi.tasklist.FileTaskScanner;
import org.netbeans.spi.tasklist.PushTaskScanner;
import org.netbeans.spi.tasklist.Task;

public class TaskFilter {
    public static final TaskFilter EMPTY = new EmptyTaskFilter();
    private String name;
    private KeywordsFilter keywords;
    private TypesFilter types = new TypesFilter();

    TaskFilter(String string) {
        this.name = string;
    }

    TaskFilter() {
    }

    private TaskFilter(TaskFilter taskFilter) {
        this.name = taskFilter.name;
        this.keywords = null == taskFilter.keywords ? null : (KeywordsFilter)taskFilter.keywords.clone();
        this.types = null == taskFilter.types ? null : taskFilter.types.clone();
    }

    public boolean accept(Task task) {
        return null == this.keywords ? true : this.keywords.accept(task);
    }

    public boolean isEnabled(FileTaskScanner fileTaskScanner) {
        return null == this.types ? true : this.types.isEnabled(ScannerDescriptor.getType(fileTaskScanner));
    }

    public boolean isEnabled(PushTaskScanner pushTaskScanner) {
        return null == this.types ? true : this.types.isEnabled(ScannerDescriptor.getType(pushTaskScanner));
    }

    public boolean isTaskCountLimitReached(int n) {
        return null == this.types ? false : this.types.isTaskCountLimitReached(n);
    }

    public String getName() {
        return this.name;
    }

    void setName(String string) {
        this.name = string;
    }

    KeywordsFilter getKeywordsFilter() {
        return this.keywords;
    }

    void setKeywordsFilter(KeywordsFilter keywordsFilter) {
        this.keywords = keywordsFilter;
    }

    TypesFilter getTypesFilter() {
        return this.types;
    }

    void setTypesFilter(TypesFilter typesFilter) {
        this.types = typesFilter;
    }

    public Object clone() {
        return new TaskFilter(this);
    }

    public String toString() {
        return this.name;
    }

    void load(Preferences preferences, String string) throws BackingStoreException {
        this.name = preferences.get(string + "_name", "Filter");
        if (preferences.getBoolean(string + "_types", false)) {
            this.types = new TypesFilter();
            this.types.load(preferences, string + "_types");
        } else {
            this.types = null;
        }
        if (preferences.getBoolean(string + "_keywords", false)) {
            this.keywords = new KeywordsFilter();
            this.keywords.load(preferences, string + "_keywords");
        } else {
            this.keywords = null;
        }
    }

    void save(Preferences preferences, String string) throws BackingStoreException {
        preferences.put(string + "_name", this.name);
        if (null != this.types) {
            preferences.putBoolean(string + "_types", true);
            this.types.save(preferences, string + "_types");
        } else {
            preferences.putBoolean(string + "_types", false);
        }
        if (null != this.keywords) {
            preferences.putBoolean(string + "_keywords", true);
            this.keywords.save(preferences, string + "_keywords");
        } else {
            preferences.putBoolean(string + "_keywords", false);
        }
    }

    private static class EmptyTaskFilter
    extends TaskFilter {
        public EmptyTaskFilter() {
            super(Util.getString("no-filter"));
        }

        public boolean accept(Task task) {
            return true;
        }

        public boolean isEnabled(FileTaskScanner fileTaskScanner) {
            return true;
        }

        public boolean isEnabled(PushTaskScanner pushTaskScanner) {
            return true;
        }

        public boolean isTaskCountLimitReached(int n) {
            return false;
        }
    }
}

