/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.filter;

import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.netbeans.modules.tasklist.filter.FilterCondition;
import org.netbeans.modules.tasklist.filter.KeywordsFilter;
import org.netbeans.modules.tasklist.filter.TaskProperties;
import org.netbeans.modules.tasklist.filter.TaskProperty;
import org.netbeans.spi.tasklist.Task;

final class AppliedFilterCondition {
    private TaskProperty prop;
    private FilterCondition cond;

    AppliedFilterCondition(TaskProperty taskProperty, FilterCondition filterCondition) {
        this.prop = taskProperty;
        this.cond = filterCondition;
    }

    AppliedFilterCondition() {
    }

    public Object clone() {
        return new AppliedFilterCondition(this.prop, (FilterCondition)this.cond.clone());
    }

    public TaskProperty getProperty() {
        return this.prop;
    }

    public FilterCondition getCondition() {
        return this.cond;
    }

    public boolean isTrue(Task task) {
        return this.cond.isTrue(this.prop.getValue(task));
    }

    public String toString() {
        return this.cond.toString() + " applied to " + this.prop.toString();
    }

    public boolean sameType(AppliedFilterCondition appliedFilterCondition) {
        return this.getCondition().sameType(appliedFilterCondition.getCondition()) && this.getProperty().equals(appliedFilterCondition.getProperty());
    }

    void load(Preferences preferences, String string) throws BackingStoreException {
        this.prop = TaskProperties.getProperty(preferences.get(string + "_propertyId", ""));
        if (null == this.prop) {
            throw new BackingStoreException("Missing propertyId attribute");
        }
        this.cond = KeywordsFilter.createCondition(this.prop);
        this.cond.load(preferences, string);
    }

    void save(Preferences preferences, String string) throws BackingStoreException {
        preferences.put(string + "_propertyId", this.prop.getID());
        this.cond.save(preferences, string);
    }
}

