/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.design.view.widget;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import org.netbeans.api.visual.layout.Layout;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.websvc.design.view.layout.TableLayout;
import org.netbeans.modules.websvc.design.view.widget.ButtonWidget;
import org.netbeans.modules.websvc.design.view.widget.TabWidget;

public class TabbedPaneWidget
extends Widget {
    private static final Color TAB_BORDER_COLOR = new Color(169, 197, 235);
    private static final Color SELECTED_TAB_COLOR = Color.WHITE;
    private static final Color TAB_COLOR = new Color(232, 232, 232);
    private Widget tabs;
    private Widget contentWidget;
    private ButtonWidget selectedTab;
    private Widget selectedTabComponent;

    public TabbedPaneWidget(Scene scene) {
        super(scene);
        this.setLayout(LayoutFactory.createVerticalFlowLayout((LayoutFactory.SerialAlignment)LayoutFactory.SerialAlignment.JUSTIFY, (int)1));
        this.tabs = new Widget(scene);
        this.addChild(this.tabs);
        this.contentWidget = new Widget(scene);
        this.contentWidget.setLayout(LayoutFactory.createOverlayLayout());
        this.contentWidget.setBorder((Border)BorderFactory.createMatteBorder(0, 1, 1, 1, TAB_BORDER_COLOR));
        this.addChild(this.contentWidget);
    }

    public void addTab(TabWidget tabWidget) {
        this.addTab(tabWidget.getTitle(), tabWidget.getIcon(), tabWidget.getComponentWidget());
    }

    public void addTab(String string, Image image, final Widget widget) {
        this.contentWidget.addChild(widget);
        widget.setVisible(false);
        final ButtonWidget buttonWidget = new ButtonWidget(this.getScene(), image, string){

            protected boolean isAimingAllowed() {
                return false;
            }
        };
        buttonWidget.setBorder(new TabBorder(this, buttonWidget));
        buttonWidget.setAction(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (TabbedPaneWidget.this.selectedTabComponent != widget) {
                    if (TabbedPaneWidget.this.selectedTab != null) {
                        TabbedPaneWidget.this.selectedTab.setLabelFont(TabbedPaneWidget.this.getScene().getFont());
                    }
                    TabbedPaneWidget.this.selectedTab = buttonWidget;
                    TabbedPaneWidget.this.selectedTab.setLabelFont(TabbedPaneWidget.this.getScene().getFont().deriveFont(1));
                    if (TabbedPaneWidget.this.selectedTabComponent != null) {
                        TabbedPaneWidget.this.selectedTabComponent.setVisible(false);
                    }
                    TabbedPaneWidget.this.selectedTabComponent = widget;
                    TabbedPaneWidget.this.selectedTabComponent.setVisible(true);
                    TabbedPaneWidget.this.contentWidget.revalidate(true);
                }
            }
        });
        this.tabs.addChild((Widget)buttonWidget);
        this.tabs.setLayout((Layout)new TableLayout(this.tabs.getChildren().size(), 0, 0, 20));
        if (this.selectedTab == null) {
            this.selectedTab = buttonWidget;
            this.selectedTab.setLabelFont(this.getScene().getFont().deriveFont(1));
            this.selectedTabComponent = widget;
            this.selectedTabComponent.setVisible(true);
        }
    }

    private static class TabBorder
    implements org.netbeans.api.visual.border.Border {
        private static final int radius = 2;
        private Insets insets = new Insets(4, 6, 2, 6);
        private final TabbedPaneWidget tabbedPane;
        private final Widget tab;

        public TabBorder(TabbedPaneWidget tabbedPaneWidget, Widget widget) {
            this.tabbedPane = tabbedPaneWidget;
            this.tab = widget;
        }

        public Insets getInsets() {
            return this.insets;
        }

        public void paint(Graphics2D graphics2D, Rectangle rectangle) {
            Paint paint = graphics2D.getPaint();
            Arc2D.Double double_ = new Arc2D.Double((float)(rectangle.x - 2) + 0.5f, (float)(rectangle.y + rectangle.height - 4) + 0.5f, 4.0, 4.0, -90.0, 90.0, 0);
            GeneralPath generalPath = new GeneralPath(double_);
            double_ = new Arc2D.Double((float)(rectangle.x + 2) + 0.5f, (float)rectangle.y + 0.5f, 8.0, 8.0, 180.0, -90.0, 0);
            generalPath.append(double_, true);
            double_ = new Arc2D.Double((float)(rectangle.x + rectangle.width - 12) + 1.0f, (float)rectangle.y + 0.5f, 8.0, 8.0, 90.0, -90.0, 0);
            generalPath.append(double_, true);
            double_ = new Arc2D.Double((float)(rectangle.x + rectangle.width - 4) + 1.0f, (float)(rectangle.y + rectangle.height - 4) + 0.5f, 4.0, 4.0, 180.0, 90.0, 0);
            generalPath.append(double_, true);
            if (this.tabbedPane.selectedTab == this.tab) {
                graphics2D.setPaint(SELECTED_TAB_COLOR);
                graphics2D.fill(generalPath);
            } else {
                graphics2D.setPaint(TAB_COLOR);
                graphics2D.fill(generalPath);
                generalPath.closePath();
            }
            graphics2D.setPaint(TAB_BORDER_COLOR);
            if (this.tab.getState().isFocused()) {
                Stroke stroke = graphics2D.getStroke();
                graphics2D.setStroke(new BasicStroke(1.5f, 0, 1, 0.0f, new float[]{2.0f, 2.0f}, 0.0f));
                graphics2D.drawRect(rectangle.x + 6, rectangle.y + 4, rectangle.width - 12, rectangle.height - 8);
                graphics2D.setStroke(stroke);
            }
            graphics2D.draw(generalPath);
            graphics2D.setPaint(paint);
        }

        public boolean isOpaque() {
            return true;
        }
    }
}

