/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.design.view.widget;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import org.netbeans.api.visual.border.Border;
import org.netbeans.api.visual.widget.Widget;

public class RoundedBorder3D
implements Border {
    private static final Color SHADOW_COLOR = new Color(208, 208, 208);
    private static final Color SELECTED_BORDER_COLOR = new Color(255, 153, 0);
    private Widget widget;
    private int radius;
    private int insetWidth;
    private int insetHeight;
    private Color drawColor;
    private int depth = 3;

    public RoundedBorder3D(Widget widget, int n, int n2, int n3, int n4, Color color) {
        this.widget = widget;
        this.radius = n;
        this.depth = n2;
        this.insetWidth = n3;
        this.insetHeight = n4;
        this.drawColor = color;
    }

    public Insets getInsets() {
        return new Insets(this.insetHeight, this.insetWidth, this.insetHeight + this.depth, this.insetWidth + this.depth);
    }

    public void paint(Graphics2D graphics2D, Rectangle rectangle) {
        Paint paint = graphics2D.getPaint();
        RoundRectangle2D.Double double_ = new RoundRectangle2D.Double((float)rectangle.x + 0.5f, (float)rectangle.y + 0.5f, rectangle.width - this.depth - 1, rectangle.height - this.depth - 1, this.radius, this.radius);
        if (this.drawColor != null) {
            RoundRectangle2D.Double double_2 = new RoundRectangle2D.Double((float)(rectangle.x + this.depth) + 0.5f, (float)(rectangle.y + this.depth) + 0.5f, rectangle.width - this.depth - 1, rectangle.height - this.depth - 1, this.radius, this.radius);
            Area area = new Area(double_2);
            area.subtract(new Area(double_));
            graphics2D.setPaint(SHADOW_COLOR);
            graphics2D.fill(area);
            graphics2D.setPaint(this.widget.getState().isSelected() ? SELECTED_BORDER_COLOR : this.drawColor);
            Stroke stroke = graphics2D.getStroke();
            if (this.widget.getState().isFocused()) {
                graphics2D.setStroke(new BasicStroke(1.0f, 0, 1, 0.0f, new float[]{2.0f, 2.0f}, 0.0f));
            }
            graphics2D.draw(double_);
            graphics2D.setStroke(stroke);
        }
        graphics2D.setPaint(paint);
    }

    public boolean isOpaque() {
        return true;
    }
}

