/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.design.view.widget;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public class EditorPaneWidget
extends Widget {
    private JEditorPane editorPane;
    private JScrollPane scrollPane;
    private boolean componentAdded;
    private float origoinalFontSize = 0.0f;
    private ComponentSceneListener validateListener;
    private ComponentComponentListener componentListener;

    public EditorPaneWidget(Scene scene, String string, String string2) {
        super(scene);
        this.editorPane = new JEditorPane(string2, string);
        this.scrollPane = new JScrollPane(this.editorPane);
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.editorPane.setVisible(false);
        this.scrollPane.setVisible(false);
        this.componentAdded = false;
        this.origoinalFontSize = this.editorPane.getFont().getSize2D();
        this.editorPane.setMaximumSize(new Dimension(0, (int)this.origoinalFontSize * 6));
        this.componentListener = new ComponentComponentListener();
    }

    public void setEditable(boolean bl) {
        this.editorPane.setEditable(bl);
    }

    public boolean isEditable() {
        return this.editorPane.isEditable();
    }

    public String getText() {
        return this.editorPane.getText();
    }

    protected void notifyAdded() {
        this.editorPane.setVisible(true);
        this.scrollPane.setVisible(true);
        if (this.validateListener == null) {
            this.validateListener = new ComponentSceneListener();
            this.getScene().addSceneListener((Scene.SceneListener)this.validateListener);
        }
    }

    protected void notifyRemoved() {
        this.editorPane.setVisible(false);
        this.scrollPane.setVisible(false);
        if (this.validateListener != null) {
            this.getScene().removeSceneListener((Scene.SceneListener)this.validateListener);
            this.validateListener = null;
        }
    }

    protected final Rectangle calculateClientArea() {
        return new Rectangle(this.editorPane.getPreferredSize());
    }

    protected final void paintWidget() {
        if (!this.componentAdded) {
            this.getScene().getView().add(this.scrollPane);
            this.componentAdded = true;
        }
        this.scrollPane.setBounds(this.getScene().convertSceneToView(this.convertLocalToScene(this.getClientArea())));
        this.editorPane.setFont(this.editorPane.getFont().deriveFont((float)this.getScene().getZoomFactor() * this.origoinalFontSize));
        this.editorPane.repaint();
    }

    private final class ComponentComponentListener
    implements ComponentListener {
        private ComponentComponentListener() {
        }

        public void componentResized(ComponentEvent componentEvent) {
            EditorPaneWidget.this.revalidate();
        }

        public void componentMoved(ComponentEvent componentEvent) {
            EditorPaneWidget.this.revalidate();
        }

        public void componentShown(ComponentEvent componentEvent) {
        }

        public void componentHidden(ComponentEvent componentEvent) {
        }
    }

    private final class ComponentSceneListener
    implements Scene.SceneListener {
        private ComponentSceneListener() {
        }

        public void sceneRepaint() {
        }

        public void sceneValidating() {
            if (EditorPaneWidget.this.componentAdded) {
                EditorPaneWidget.this.getScene().getView().remove(EditorPaneWidget.this.scrollPane);
                EditorPaneWidget.this.componentAdded = false;
                EditorPaneWidget.this.scrollPane.removeComponentListener(EditorPaneWidget.this.componentListener);
            }
        }

        public void sceneValidated() {
            if (EditorPaneWidget.this.componentAdded) {
                EditorPaneWidget.this.scrollPane.addComponentListener(EditorPaneWidget.this.componentListener);
            }
        }
    }
}

