/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.design.view.widget;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import org.netbeans.api.visual.border.BorderFactory;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.model.ObjectScene;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.SeparatorWidget;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.websvc.design.view.widget.ExpandableWidget;
import org.netbeans.modules.websvc.design.view.widget.ExpanderWidget;
import org.netbeans.modules.websvc.design.view.widget.RoundedBorder3D;

public abstract class AbstractTitledWidget
extends Widget
implements ExpandableWidget {
    public static final Color BORDER_COLOR = new Color(169, 197, 235);
    public static final Color TITLE_COLOR = new Color(184, 215, 255);
    public static final Color TITLE_COLOR_BRIGHT = new Color(241, 245, 252);
    public static final Color TITLE_COLOR_PARAMETER = new Color(235, 255, 255);
    public static final Color TITLE_COLOR_OUTPUT = new Color(240, 240, 240);
    public static final Color TITLE_COLOR_FAULT = new Color(245, 227, 225);
    public static final Color TITLE_COLOR_DESC = new Color(240, 240, 240);
    public static final Color BORDER_COLOR_BLACK = Color.BLACK;
    public static final int RADIUS = 12;
    private Color borderColor = BORDER_COLOR;
    private int radius = 12;
    private int hgap = 12;
    private int cgap = 12;
    private int depth = this.radius / 3;
    private boolean expanded;
    private transient Widget headerWidget;
    private transient Widget seperatorWidget;
    private transient Widget contentWidget;
    private transient ExpanderWidget expander;

    public AbstractTitledWidget(ObjectScene objectScene, int n, Color color) {
        this(objectScene, n, n, n, color);
    }

    public AbstractTitledWidget(ObjectScene objectScene, int n, int n2, int n3, Color color) {
        super((Scene)objectScene);
        this.radius = n;
        this.borderColor = color;
        this.hgap = n2;
        this.cgap = n3;
        this.depth = n / 3;
        this.setLayout(LayoutFactory.createVerticalFlowLayout((LayoutFactory.SerialAlignment)LayoutFactory.SerialAlignment.JUSTIFY, (int)0));
        this.setBorder(new RoundedBorder3D(this, n, this.depth, 0, 0, this.borderColor));
        this.headerWidget = new Widget(this.getScene());
        this.headerWidget.setBorder(BorderFactory.createEmptyBorder((int)n2, (int)(n2 / 2)));
        this.headerWidget.setLayout(LayoutFactory.createHorizontalFlowLayout((LayoutFactory.SerialAlignment)LayoutFactory.SerialAlignment.CENTER, (int)n2));
        this.addChild(this.headerWidget);
        this.seperatorWidget = new SeparatorWidget(this.getScene(), SeparatorWidget.Orientation.HORIZONTAL);
        this.seperatorWidget.setForeground(this.borderColor);
        if (this.isExpandable()) {
            this.contentWidget = this.createContentWidget();
            this.expanded = ExpanderWidget.isExpanded(this, true);
            if (this.expanded) {
                this.expandWidget();
            } else {
                this.collapseWidget();
            }
            this.expander = new ExpanderWidget(this.getScene(), this, this.expanded);
        }
        this.getActions().addAction(objectScene.createSelectAction());
    }

    protected Widget getContentWidget() {
        return this.contentWidget;
    }

    protected final Widget createContentWidget() {
        Widget widget = new Widget(this.getScene());
        widget.setLayout(LayoutFactory.createVerticalFlowLayout((LayoutFactory.SerialAlignment)LayoutFactory.SerialAlignment.JUSTIFY, (int)this.cgap));
        widget.setBorder(BorderFactory.createEmptyBorder((int)this.cgap));
        return widget;
    }

    protected final Widget createHeaderWidget() {
        Widget widget = new Widget(this.getScene());
        widget.setLayout(LayoutFactory.createVerticalFlowLayout((LayoutFactory.SerialAlignment)LayoutFactory.SerialAlignment.JUSTIFY, (int)this.radius));
        return widget;
    }

    protected Widget getHeaderWidget() {
        return this.headerWidget;
    }

    protected ExpanderWidget getExpanderWidget() {
        return this.expander;
    }

    protected final void paintWidget() {
        Rectangle rectangle = this.getClientArea();
        Graphics2D graphics2D = this.getGraphics();
        Paint paint = graphics2D.getPaint();
        RoundRectangle2D.Double double_ = new RoundRectangle2D.Double((float)rectangle.x + 0.75f, (float)rectangle.y + 0.75f, (float)rectangle.width - 1.5f, (float)rectangle.height - 1.5f, this.radius, this.radius);
        if (this.isExpanded()) {
            int n = this.headerWidget.getBounds().height;
            Area area = new Area(double_);
            area.subtract(new Area(new Rectangle(rectangle.x, rectangle.y + n, rectangle.width, rectangle.height)));
            graphics2D.setPaint(this.getTitlePaint(area.getBounds()));
            graphics2D.fill(area);
            if (this.isOpaque()) {
                Area area2 = new Area(double_);
                area2.subtract(area);
                graphics2D.setPaint(this.getBackground());
                graphics2D.fill(area2);
            }
        } else {
            graphics2D.setPaint(this.getTitlePaint(rectangle));
            graphics2D.fill(double_);
        }
        graphics2D.setPaint(paint);
    }

    protected Paint getTitlePaint(Rectangle rectangle) {
        return new GradientPaint(rectangle.x, rectangle.y, TITLE_COLOR_BRIGHT, rectangle.x, rectangle.y + rectangle.height, TITLE_COLOR);
    }

    protected void collapseWidget() {
        if (this.seperatorWidget.getParentWidget() != null) {
            this.removeChild(this.seperatorWidget);
        }
        if (this.getContentWidget().getParentWidget() != null) {
            this.removeChild(this.getContentWidget());
        }
    }

    protected void expandWidget() {
        if (this.seperatorWidget.getParentWidget() == null) {
            this.addChild(this.seperatorWidget);
        }
        if (this.getContentWidget().getParentWidget() == null) {
            this.addChild(this.getContentWidget());
        }
    }

    public Object hashKey() {
        return null;
    }

    public void setExpanded(boolean bl) {
        if (!this.isExpandable()) {
            return;
        }
        if (this.expanded != bl) {
            this.expanded = bl;
            this.revalidate(true);
            if (bl) {
                this.expandWidget();
            } else {
                this.collapseWidget();
            }
            this.getScene().validate();
            this.expander.setSelected(bl);
        }
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    protected boolean isExpandable() {
        return true;
    }

    protected void notifyAdded() {
        super.notifyAdded();
        Object object = this.hashKey();
        if (object != null) {
            this.getObjectScene().addObject(object, new Widget[]{this});
        }
    }

    protected void notifyRemoved() {
        super.notifyRemoved();
        Object object = this.hashKey();
        if (object != null && this.getObjectScene().isObject(object)) {
            this.getObjectScene().removeObject(object);
        }
    }

    protected void notifyStateChanged(ObjectState objectState, ObjectState objectState2) {
        if (objectState.isSelected() != objectState2.isSelected()) {
            this.revalidate(true);
        }
    }

    protected ObjectScene getObjectScene() {
        return (ObjectScene)super.getScene();
    }
}

