/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.design.multiview;

import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Properties;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.core.spi.multiview.MultiViewDescription;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.design.multiview.PreviewMultiViewElement;
import org.openide.ErrorManager;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.DataEditorSupport;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class PreviewMultiViewDesc
implements MultiViewDescription,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String PREFERRED_ID = "webservice-wsdlpreview";
    private DataObject dataObject;
    private FileObject fo;
    private String serviceName;
    private String implementationClass;

    public PreviewMultiViewDesc() {
    }

    public PreviewMultiViewDesc(DataObject dataObject) {
        this.dataObject = dataObject;
    }

    public PreviewMultiViewDesc(DataObject dataObject, Service service, FileObject fileObject) {
        this.dataObject = dataObject;
        this.fo = fileObject;
        if (service != null) {
            this.serviceName = service.getName();
            this.implementationClass = service.getImplementationClass();
        }
    }

    public PreviewMultiViewDesc(DataObject dataObject, Service service) {
        this.dataObject = dataObject;
        if (service != null) {
            this.serviceName = service.getName();
            this.implementationClass = service.getImplementationClass();
        }
    }

    public String preferredID() {
        return PREFERRED_ID;
    }

    public int getPersistenceType() {
        return 2;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(PreviewMultiViewDesc.class, (String)"LBL_wsdlPreview_name");
    }

    public Image getIcon() {
        if (this.dataObject != null) {
            return this.dataObject.getNodeDelegate().getIcon(1);
        }
        Image image = ImageUtilities.loadImage((String)"org/netbeans/modules/websvc/design/view/resources/fault.png", (boolean)false);
        return image;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(PreviewMultiViewDesc.class);
    }

    public MultiViewElement createElement() {
        if (this.implementationClass == null) {
            if (this.dataObject == null) {
                return new PreviewMultiViewElement();
            }
            return new PreviewMultiViewElement((DataEditorSupport)this.dataObject.getLookup().lookup(DataEditorSupport.class));
        }
        DataObject dataObject = this.createPreviewForJava();
        if (dataObject == null || dataObject.getLookup().lookup(DataEditorSupport.class) == null) {
            return new PreviewMultiViewElement();
        }
        DataEditorSupport dataEditorSupport = (DataEditorSupport)dataObject.getLookup().lookup(DataEditorSupport.class);
        return new PreviewMultiViewElement(dataEditorSupport);
    }

    public DataObject createPreviewForJava() {
        DataObject dataObject = null;
        if (this.dataObject != null) {
            FileObject fileObject = this.dataObject.getPrimaryFile();
            String string = System.getProperty("java.io.tmpdir");
            FileObject fileObject2 = null;
            final Properties properties = new Properties();
            properties.setProperty("build.generated.dir", string);
            Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
            JavaSource javaSource = JavaSource.forFileObject((FileObject)this.getFileObject(project));
            FindMethodTask findMethodTask = new FindMethodTask();
            try {
                javaSource.runUserActionTask((Task)findMethodTask, true);
                if (findMethodTask.found) {
                    final FileObject fileObject3 = project.getProjectDirectory().getFileObject("build.xml");
                    RequestProcessor.getDefault().post(new Runnable(){

                        public void run() {
                            try {
                                ExecutorTask executorTask = ActionUtils.runTarget((FileObject)fileObject3, (String[])new String[]{"wsgen-" + PreviewMultiViewDesc.this.serviceName}, (Properties)properties);
                                executorTask.waitFinished();
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                ErrorManager.getDefault().notify((Throwable)illegalArgumentException);
                            }
                            catch (IOException iOException) {
                                ErrorManager.getDefault().notify((Throwable)iOException);
                            }
                        }
                    });
                    File file = new File(string);
                    FileUtil.refreshFor((File[])new File[]{file});
                    String string2 = "wsgen/service/resources/";
                    String string3 = "Service";
                    String string4 = string + string2 + this.serviceName + string3 + ".wsdl";
                    File file2 = new File(string4);
                    if (file2 == null) {
                        file2 = new File(string + string2 + this.serviceName + ".wsdl");
                    }
                    fileObject2 = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file2));
                }
                if (fileObject2 != null) {
                    try {
                        dataObject = DataObject.find(fileObject2);
                    }
                    catch (DataObjectNotFoundException dataObjectNotFoundException) {
                        Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
                    }
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return dataObject;
    }

    public FileObject getFileObject(Project project) {
        SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        String string = this.implementationClass.replace('.', '/') + ".java";
        for (SourceGroup sourceGroup : sourceGroupArray) {
            FileObject fileObject = sourceGroup.getRootFolder().getFileObject(string);
            if (fileObject == null) continue;
            return fileObject;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class FindMethodTask
    implements CancellableTask<CompilationController> {
        public boolean found = false;

        FindMethodTask() {
        }

        public void cancel() {
        }

        public void run(CompilationController compilationController) throws Exception {
            TypeElement typeElement = compilationController.getElements().getTypeElement(PreviewMultiViewDesc.this.implementationClass);
            if (typeElement != null) {
                for (Element element : typeElement.getEnclosedElements()) {
                    if (element.getKind() != ElementKind.METHOD) continue;
                    this.found = true;
                }
            }
        }
    }
}

