/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.debugger.jpda;

import com.sun.jdi.Bootstrap;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.ListeningConnector;
import java.io.IOException;
import java.util.Map;
import org.netbeans.api.debugger.jpda.AbstractDICookie;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ListeningDICookie
extends AbstractDICookie {
    public static final String ID = "netbeans-jpda-ListeningDICookie";
    private ListeningConnector listeningConnector;
    private Map<String, ? extends Connector.Argument> args;
    private boolean isListening = false;

    private ListeningDICookie(ListeningConnector listeningConnector, Map<String, ? extends Connector.Argument> map) {
        this.listeningConnector = listeningConnector;
        this.args = map;
    }

    public static ListeningDICookie create(ListeningConnector listeningConnector, Map<String, ? extends Connector.Argument> map) {
        return new ListeningDICookie(listeningConnector, map);
    }

    public static ListeningDICookie create(int n) {
        return new ListeningDICookie(ListeningDICookie.findListeningConnector("socket"), ListeningDICookie.getArgs(ListeningDICookie.findListeningConnector("socket"), n));
    }

    public static ListeningDICookie create(String string) {
        return new ListeningDICookie(ListeningDICookie.findListeningConnector("socket"), ListeningDICookie.getArgs(ListeningDICookie.findListeningConnector("socket"), string));
    }

    private static ListeningConnector findListeningConnector(String string) {
        for (ListeningConnector listeningConnector : Bootstrap.virtualMachineManager().listeningConnectors()) {
            if (listeningConnector.transport() == null || listeningConnector.transport().name().toLowerCase().indexOf(string) <= -1) continue;
            return listeningConnector;
        }
        return null;
    }

    private static Map<String, ? extends Connector.Argument> getArgs(ListeningConnector listeningConnector, int n) {
        Map<String, Connector.Argument> map = listeningConnector.defaultArguments();
        map.get("port").setValue("" + n);
        return map;
    }

    private static Map<String, ? extends Connector.Argument> getArgs(ListeningConnector listeningConnector, String string) {
        Map<String, Connector.Argument> map = listeningConnector.defaultArguments();
        map.get("name").setValue(string);
        return map;
    }

    public ListeningConnector getListeningConnector() {
        return this.listeningConnector;
    }

    public Map<String, ? extends Connector.Argument> getArgs() {
        return this.args;
    }

    public int getPortNumber() {
        Connector.Argument argument = this.args.get("port");
        if (argument == null) {
            return -1;
        }
        String string = argument.value();
        if (string == null || string.length() == 0) {
            try {
                String string2 = this.listeningConnector.startListening(this.args);
                this.isListening = true;
                int n = string2.indexOf(58);
                String string3 = null;
                if (n >= 0) {
                    string3 = string2.substring(0, n);
                    string2 = string2.substring(n + 1);
                }
                argument.setValue(string2);
                string = string2;
            }
            catch (IOException iOException) {
            }
            catch (IllegalConnectorArgumentsException illegalConnectorArgumentsException) {
                // empty catch block
            }
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public String getSharedMemoryName() {
        Connector.Argument argument = this.args.get("name");
        if (argument == null) {
            return null;
        }
        return argument.value();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VirtualMachine getVirtualMachine() throws IOException, IllegalConnectorArgumentsException {
        try {
            if (!this.isListening) {
                try {
                    this.listeningConnector.startListening(this.args);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            VirtualMachine virtualMachine = this.listeningConnector.accept(this.args);
            return virtualMachine;
        }
        finally {
            try {
                this.listeningConnector.stopListening(this.args);
            }
            catch (Exception exception) {}
        }
    }
}

