/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.manager;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.websvc.jaxwsmodelapi.WSService;
import org.netbeans.modules.websvc.jaxwsmodelapi.wsdlmodel.WsdlModel;
import org.netbeans.modules.websvc.jaxwsmodelapi.wsdlmodel.WsdlModelProvider;
import org.netbeans.modules.websvc.manager.WebServicePersistenceManager;
import org.netbeans.modules.websvc.manager.api.WebServiceDescriptor;
import org.netbeans.modules.websvc.manager.codegen.Wsdl2Java;
import org.netbeans.modules.websvc.manager.model.WebServiceData;
import org.netbeans.modules.websvc.manager.model.WebServiceGroup;
import org.netbeans.modules.websvc.manager.model.WebServiceListModel;
import org.netbeans.modules.websvc.manager.spi.WebServiceManagerExt;
import org.netbeans.modules.websvc.saas.spi.websvcmgr.WsdlServiceProxyDescriptor;
import org.netbeans.modules.websvc.saas.util.WsdlUtil;
import org.netbeans.modules.xml.retriever.Retriever;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class WebServiceManager {
    private static WebServiceManager wsMgr;
    public static String WEBSVC_HOME;
    private int mutatorCount;

    private WebServiceManager() {
    }

    public static WebServiceManager getInstance() {
        if (wsMgr == null) {
            wsMgr = new WebServiceManager();
        }
        return wsMgr;
    }

    public void addWebService(WebServiceData webServiceData) throws IOException {
        this.addWebService(webServiceData, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWebService(WebServiceData webServiceData, boolean bl) throws IOException {
        block26: {
            try {
                File file;
                this.incrementMutatorCount();
                WebServiceListModel webServiceListModel = WebServiceListModel.getInstance();
                if (webServiceData.getState().equals((Object)WebServiceData.State.WSDL_UNRETRIEVED) || webServiceData.getState().equals((Object)WebServiceData.State.WSDL_RETRIEVING) && !webServiceData.isResolved()) {
                    webServiceData.setState(WebServiceData.State.WSDL_RETRIEVING);
                    file = null;
                    try {
                        file = WebServiceManager.copyWsdlResources(webServiceData.getOriginalWsdlUrl());
                    }
                    catch (IOException iOException) {
                        webServiceData.setState(WebServiceData.State.WSDL_UNRETRIEVED);
                        throw iOException;
                    }
                    File file2 = new File(WEBSVC_HOME, WsdlUtil.getCatalogForWsdl((String)webServiceData.getOriginalWsdlUrl()));
                    webServiceData.setWsdlFile(file.getAbsolutePath());
                    webServiceData.setCatalog(file2.getAbsolutePath());
                    webServiceData.setState(WebServiceData.State.WSDL_RETRIEVED);
                }
                assert (webServiceData.getWsdlFile() != null);
                file = this.getWsdlModel(webServiceData);
                boolean bl2 = webServiceListModel.webServiceExists(webServiceData);
                if (file == null) {
                    webServiceData.setResolved(false);
                    this.removeWebService(webServiceData, true, false);
                    return;
                }
                if (file.getServices().isEmpty()) {
                    this.removeWebService(webServiceData);
                    String string = NbBundle.getMessage(WebServiceManager.class, (String)"WS_NO_METHODS_ERROR");
                    NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                    return;
                }
                if (bl2) {
                    boolean bl3 = false;
                    for (WSService wSService : file.getServices()) {
                        if (!wSService.getName().equals(webServiceData.getName())) continue;
                        bl3 = true;
                        webServiceData.setWsdlService(wSService);
                        webServiceData.setResolved(true);
                    }
                    if (!bl3) {
                        WSService wSService = (WSService)file.getServices().get(0);
                        webServiceData.setWsdlService(wSService);
                        webServiceData.setName(wSService.getName());
                        webServiceData.setResolved(true);
                    }
                    webServiceListModel.getWebServiceGroup(webServiceData.getGroupId()).modify(webServiceData.getId());
                    try {
                        if (bl && !webServiceData.getState().equals((Object)WebServiceData.State.WSDL_SERVICE_COMPILED)) {
                            WebServiceManager.compileService(webServiceData);
                        }
                        break block26;
                    }
                    finally {
                        if (webServiceData.getState().equals((Object)WebServiceData.State.WSDL_SERVICE_COMPILE_FAILED)) {
                            webServiceData.setResolved(false);
                        }
                    }
                }
                boolean bl4 = true;
                for (WSService wSService : file.getServices()) {
                    WebServiceData webServiceData2;
                    if (bl4) {
                        bl4 = false;
                        webServiceData2 = webServiceData;
                    } else {
                        webServiceData2 = new WebServiceData(webServiceData.getWsdlFile(), webServiceData.getOriginalWsdlUrl(), webServiceData.getGroupId());
                    }
                    webServiceData2.setWsdlService(wSService);
                    webServiceData2.setResolved(true);
                    webServiceData2.setName(wSService.getName());
                    webServiceListModel.addWebService(webServiceData2);
                    WebServiceGroup webServiceGroup = webServiceListModel.getWebServiceGroup(webServiceData2.getGroupId());
                    if (webServiceGroup != null) {
                        webServiceGroup.add(webServiceData2.getId());
                    }
                    try {
                        if (!bl || webServiceData2.getState().equals((Object)WebServiceData.State.WSDL_SERVICE_COMPILED)) continue;
                        WebServiceManager.compileService(webServiceData2);
                    }
                    finally {
                        if (!webServiceData2.getState().equals((Object)WebServiceData.State.WSDL_SERVICE_COMPILE_FAILED)) continue;
                        this.removeWebService(webServiceData2);
                    }
                }
            }
            finally {
                this.save();
            }
        }
    }

    public WsdlModel getWsdlModel(WebServiceData webServiceData) throws IOException {
        Object object;
        Object object2;
        String string;
        Object object32;
        File file = new File(webServiceData.getWsdlFile());
        URL uRL = file.toURI().toURL();
        WsdlModelProvider wsdlModelProvider = null;
        Collection collection = Lookup.getDefault().lookupAll(WsdlModelProvider.class);
        if (collection != null) {
            for (Object object32 : collection) {
                if (!object32.canAccept(uRL)) continue;
                wsdlModelProvider = object32;
                break;
            }
        }
        WsdlModel wsdlModel = null;
        object32 = null;
        if (wsdlModelProvider != null) {
            string = webServiceData.getPackageName();
            if (string == null || string.trim().length() == 0) {
                string = wsdlModelProvider.getEffectivePackageName();
            }
            object2 = new File(webServiceData.getCatalog());
            object = ((File)object2).toURI().toURL();
            try {
                wsdlModel = wsdlModelProvider.getWsdlModel(uRL, string, (URL)object);
            }
            catch (Exception exception) {
                object32 = exception.getCause();
            }
        }
        if (wsdlModel == null) {
            webServiceData.setResolved(false);
            this.removeWebService(webServiceData, true, false);
            string = NbBundle.getMessage(WebServiceManager.class, (String)"WS_MODELER_ERROR");
            if (object32 != null) {
                object2 = object32.getLocalizedMessage();
                object = object32.getClass().getName() + " - " + (String)object2;
                string = string + "\n\n" + (String)object;
                Exceptions.printStackTrace((Throwable)Exceptions.attachLocalizedMessage((Throwable)object32, (String)string));
            } else {
                object32 = new IllegalStateException(string);
                Exceptions.printStackTrace((Throwable)object32);
            }
        }
        return wsdlModel;
    }

    public void refreshWebService(WebServiceData webServiceData) throws IOException {
        this.removeWebService(webServiceData, false, true);
        webServiceData.setWsdlFile(null);
        webServiceData.setState(WebServiceData.State.WSDL_UNRETRIEVED);
        webServiceData.setCatalog(null);
        webServiceData.setWsdlService(null);
        webServiceData.setJaxRpcDescriptorPath(null);
        webServiceData.setJaxRpcDescriptor(null);
        webServiceData.setJaxWsDescriptor(null);
        webServiceData.setJaxWsDescriptorPath(null);
        this.addWebService(webServiceData, true);
    }

    public void resetWebService(WebServiceData webServiceData) {
        this.removeWebService(webServiceData, false, true);
        webServiceData.setWsdlFile(null);
        webServiceData.setState(WebServiceData.State.WSDL_UNRETRIEVED);
        webServiceData.setCatalog(null);
        webServiceData.setWsdlService(null);
        webServiceData.setJaxRpcDescriptorPath(null);
        webServiceData.setJaxRpcDescriptor(null);
        webServiceData.setJaxWsDescriptor(null);
        webServiceData.setJaxWsDescriptorPath(null);
    }

    public WebServiceData addWebService(String string, String string2, String string3) throws IOException {
        WebServiceData webServiceData = new WebServiceData(string, string3);
        webServiceData.setPackageName(string2);
        webServiceData.setResolved(false);
        this.addWebService(webServiceData, true);
        return webServiceData;
    }

    public void removeWebService(WebServiceData webServiceData) {
        this.removeWebService(webServiceData, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeWebService(WebServiceData webServiceData, boolean bl, boolean bl2) {
        try {
            Object object2;
            this.incrementMutatorCount();
            if (bl) {
                WebServiceListModel.getInstance().removeWebService(webServiceData.getId());
            }
            Collection collection = Lookup.getDefault().lookupAll(WebServiceManagerExt.class);
            WebServiceDescriptor webServiceDescriptor = webServiceData.getJaxRpcDescriptor();
            WebServiceDescriptor webServiceDescriptor2 = webServiceData.getJaxWsDescriptor();
            for (Object object2 : collection) {
                if (webServiceDescriptor != null) {
                    object2.wsServiceRemovedExt(webServiceDescriptor);
                }
                if (webServiceDescriptor2 == null) continue;
                object2.wsServiceRemovedExt(webServiceDescriptor2);
            }
            this.deleteWsArtifacts(webServiceDescriptor);
            this.deleteWsArtifacts(webServiceDescriptor2);
            if (webServiceData.getName() != null) {
                new File(WEBSVC_HOME, webServiceData.getName()).delete();
            }
            if (webServiceData.getWsdlFile() == null) {
                return;
            }
            if (!bl2) {
                return;
            }
            WebServiceListModel webServiceListModel = WebServiceListModel.getInstance();
            object2 = webServiceListModel.getWebServiceSet().iterator();
            while (object2.hasNext()) {
                WebServiceData webServiceData2 = (WebServiceData)object2.next();
                if (webServiceData2 == webServiceData || !webServiceData.getWsdlFile().equals(webServiceData2.getWsdlFile())) continue;
                bl2 = false;
                break;
            }
            if (bl2) {
                WebServiceManager.rmDir(new File(webServiceData.getWsdlFile()));
                if (webServiceData.getCatalog() != null && ((File)(object2 = new File(webServiceData.getCatalog()))).exists()) {
                    WebServiceManager.rmDir(((File)object2).getParentFile());
                }
            }
        }
        finally {
            this.save();
        }
    }

    private void deleteWsArtifacts(WebServiceDescriptor webServiceDescriptor) {
        if (webServiceDescriptor == null) {
            return;
        }
        File file = webServiceDescriptor.getXmlDescriptorFile().getParentFile();
        assert (file != null);
        for (WsdlServiceProxyDescriptor.JarEntry jarEntry : webServiceDescriptor.getJars()) {
            File file2 = new File(file, jarEntry.getName());
            file2.delete();
        }
        webServiceDescriptor.getXmlDescriptorFile().delete();
        file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void rmDir(File file) {
        if (file == null) {
            return;
        }
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject != null) {
            FileLock fileLock = null;
            try {
                fileLock = fileObject.lock();
                fileObject.delete(fileLock);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            finally {
                if (fileLock != null) {
                    fileLock.releaseLock();
                }
            }
        }
    }

    static File copyWsdlResources(String string) throws IOException {
        File file = new File(WEBSVC_HOME);
        File file2 = new File(file, WsdlUtil.getCatalogForWsdl((String)string));
        File file3 = file2.getParentFile();
        boolean bl = false;
        file3 = file2.getParentFile();
        try {
            FileObject fileObject = FileUtil.createFolder((File)file3);
            URI uRI = file2.toURI();
            URI uRI2 = new URL(string).toURI();
            Retriever retriever = Retriever.getDefault();
            FileObject fileObject2 = retriever.retrieveResource(fileObject, uRI, uRI2);
            if (fileObject2 == null) {
                throw new IOException(NbBundle.getMessage(WebServiceManager.class, (String)"WSDL_COPY_ERROR"));
            }
            FileObject fileObject3 = FileUtil.createFolder((File)new File(WEBSVC_HOME));
            File file4 = FileUtil.toFile((FileObject)fileObject2);
            bl = true;
            File file5 = file4;
            return file5;
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IOException(uRISyntaxException.getLocalizedMessage());
        }
        finally {
            if (file2.exists() && !bl) {
                WebServiceManager.rmDir(file2.getParentFile());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void compileService(WebServiceData webServiceData) {
        boolean bl = false;
        try {
            WebServiceDescriptor webServiceDescriptor;
            if (WebServiceListModel.getInstance().getWebService(webServiceData.getId()) == null || webServiceData.getState().equals((Object)WebServiceData.State.WSDL_SERVICE_COMPILED) || webServiceData.getState().equals((Object)WebServiceData.State.WSDL_SERVICE_COMPILING)) {
                return;
            }
            webServiceData.setState(WebServiceData.State.WSDL_SERVICE_COMPILING);
            bl = true;
            Collection collection = Lookup.getDefault().lookupAll(WebServiceManagerExt.class);
            WSService wSService = webServiceData.getWsdlService();
            Wsdl2Java wsdl2Java = new Wsdl2Java(webServiceData);
            boolean bl2 = wsdl2Java.createProxyJars();
            if (!bl2) {
                return;
            }
            URL uRL = new File(webServiceData.getWsdlFile()).toURI().toURL();
            String string = webServiceData.getEffectivePackageName();
            if (webServiceData.isJaxRpcEnabled()) {
                webServiceDescriptor = new WebServiceDescriptor(webServiceData.getName(), string, 0, uRL, new File(WEBSVC_HOME, webServiceData.getJaxRpcDescriptorPath()), wSService);
                webServiceDescriptor.addJar(webServiceData.getName() + ".jar", "proxy");
                webServiceDescriptor.addJar(webServiceData.getName() + "-src.jar", "source");
                webServiceData.setJaxRpcDescriptor(webServiceDescriptor);
            }
            if (webServiceData.isJaxWsEnabled()) {
                webServiceDescriptor = new WebServiceDescriptor(webServiceData.getName(), string, 1, uRL, new File(WEBSVC_HOME, webServiceData.getJaxWsDescriptorPath()), wSService);
                webServiceDescriptor.addJar(webServiceData.getName() + ".jar", "proxy");
                webServiceDescriptor.addJar(webServiceData.getName() + "-src.jar", "source");
                webServiceData.setJaxWsDescriptor(webServiceDescriptor);
            }
            boolean bl3 = false;
            boolean bl4 = false;
            for (WebServiceManagerExt webServiceManagerExt : collection) {
                if (webServiceData.getJaxRpcDescriptor() != null && webServiceManagerExt.wsServiceAddedExt(webServiceData.getJaxRpcDescriptor())) {
                    bl4 = true;
                }
                if (webServiceData.getJaxWsDescriptor() == null || !webServiceManagerExt.wsServiceAddedExt(webServiceData.getJaxWsDescriptor())) continue;
                bl3 = true;
            }
            if (!bl3 && !bl4) {
                WebServiceManager.getInstance().removeWebService(webServiceData);
            } else if (!bl3 && webServiceData.getJaxWsDescriptor() != null) {
                WebServiceManager.getInstance().deleteWsArtifacts(webServiceData.getJaxWsDescriptor());
                webServiceData.setJaxWsDescriptor(null);
                webServiceData.setJaxWsDescriptorPath(null);
                webServiceData.setJaxWsEnabled(false);
            } else if (!bl4 && webServiceData.getJaxRpcDescriptor() != null) {
                WebServiceManager.getInstance().deleteWsArtifacts(webServiceData.getJaxRpcDescriptor());
                webServiceData.setJaxRpcDescriptor(null);
                webServiceData.setJaxRpcDescriptorPath(null);
                webServiceData.setJaxRpcEnabled(false);
            }
            if (bl3 || bl4) {
                webServiceData.setState(WebServiceData.State.WSDL_SERVICE_COMPILED);
                webServiceData.setCompiled(true);
            }
        }
        catch (IOException iOException) {
            Logger.global.log(Level.INFO, iOException.getLocalizedMessage(), iOException);
        }
        finally {
            if (!webServiceData.getState().equals((Object)WebServiceData.State.WSDL_SERVICE_COMPILED) && bl) {
                webServiceData.setState(WebServiceData.State.WSDL_SERVICE_COMPILE_FAILED);
            } else {
                WebServiceManager.saveDescriptor(webServiceData);
            }
        }
    }

    private synchronized void incrementMutatorCount() {
        ++this.mutatorCount;
    }

    private synchronized void save() {
        if (--this.mutatorCount <= 0 && WebServiceListModel.getInstance().isDirty()) {
            new WebServicePersistenceManager().save();
            WebServiceListModel.getInstance().setDirty(false);
        }
    }

    private static void saveDescriptor(WebServiceData webServiceData) {
        WebServicePersistenceManager webServicePersistenceManager = new WebServicePersistenceManager();
        try {
            WebServiceDescriptor webServiceDescriptor = webServiceData.getJaxWsDescriptor();
            if (webServiceDescriptor instanceof WebServiceDescriptor) {
                webServicePersistenceManager.saveDescriptor(webServiceDescriptor);
            }
            if ((webServiceDescriptor = webServiceData.getJaxRpcDescriptor()) instanceof WebServiceDescriptor) {
                webServicePersistenceManager.saveDescriptor(webServiceDescriptor);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        WEBSVC_HOME = WebServiceDescriptor.WEBSVC_HOME;
    }
}

