/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelui.trace;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.EnumSet;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Action;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmProgressAdapter;
import org.netbeans.modules.cnd.api.model.CsmProgressListener;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.modelimpl.trace.TraceXRef;
import org.netbeans.modules.cnd.modelui.trace.TestProjectActionBase;
import org.netbeans.modules.cnd.modelui.trace.TestReparseAction;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestProjectReferencesAction
extends TestProjectActionBase {
    private static boolean running = false;
    private final boolean allReferences;
    private final boolean analyzeStatistics;
    private final Boolean reportUnresolved;
    private int numThreads = 1;

    public static Action getSmartCompletionAnalyzerAction() {
        return (Action)SharedClassObject.findObject(SmartCompletionAnalyzerAction.class, (boolean)true);
    }

    public static Action getTestReparseAction() {
        return (Action)SharedClassObject.findObject(TestReparseAction.class, (boolean)true);
    }

    public static Action getDirectUsageReferencesAction() {
        return (Action)SharedClassObject.findObject(DirectUsageAction.class, (boolean)true);
    }

    public static Action getAllReferencesAction() {
        return (Action)SharedClassObject.findObject(AllUsagesAction.class, (boolean)true);
    }

    public static Action getAllReferencesPerformanceAction() {
        return (Action)SharedClassObject.findObject(AllUsagesPerformanceAction.class, (boolean)true);
    }

    protected TestProjectReferencesAction(boolean bl, boolean bl2, Boolean bl3) {
        this.allReferences = bl;
        this.analyzeStatistics = bl2;
        this.reportUnresolved = bl3;
        this.numThreads = bl3 == Boolean.FALSE ? Runtime.getRuntime().availableProcessors() : 1;
    }

    public String getName() {
        String string = this.analyzeStatistics ? "CTL_TestProjectSmartCCDirectUsageReferencesAction" : (this.reportUnresolved != null ? (this.reportUnresolved != false ? "CTL_TestProjectReferencesAction" : "CTL_TestProjectReferencesPerformanceAction") : "CTL_TestProjectDirectUsageReferencesAction");
        return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)string);
    }

    @Override
    protected void performAction(Collection<CsmProject> collection) {
        if (this.reportUnresolved == Boolean.FALSE) {
            NotifyDescriptor.InputLine inputLine = new NotifyDescriptor.InputLine("Threads #:", "Test References", 2, 3);
            inputLine.setInputText(Integer.toString(this.numThreads));
            Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)inputLine);
            try {
                this.numThreads = Integer.parseInt(inputLine.getInputText());
            }
            catch (NumberFormatException numberFormatException) {
                this.numThreads = 1;
            }
            if (object == NotifyDescriptor.CANCEL_OPTION) {
                return;
            }
        }
        if (collection != null) {
            for (Object object : collection) {
                this.testProject((CsmProject)object);
            }
        }
    }

    private void testProject(CsmProject csmProject) {
        String string = (this.allReferences ? "All " : "Direct usage ") + "xRef - " + csmProject.getName() + (this.analyzeStatistics ? " Statistics" : "");
        InputOutput inputOutput = IOProvider.getDefault().getIO(string, false);
        inputOutput.select();
        final AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        final ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)string, (Cancellable)new Cancellable(){

            public boolean cancel() {
                atomicBoolean.set(true);
                return true;
            }
        });
        progressHandle.start();
        final OutputWriter outputWriter = inputOutput.getOut();
        final OutputWriter outputWriter2 = inputOutput.getErr();
        final long[] lArray = new long[2];
        lArray[0] = System.currentTimeMillis();
        EnumSet<CsmReferenceKind> enumSet = this.allReferences ? CsmReferenceKind.ANY_REFERENCE_IN_ACTIVE_CODE : EnumSet.of(CsmReferenceKind.DIRECT_USAGE);
        TraceXRef.traceProjectRefsStatistics((CsmProject)csmProject, (TraceXRef.StatisticsParameters)new TraceXRef.StatisticsParameters(enumSet, this.analyzeStatistics, this.reportUnresolved == null ? true : this.reportUnresolved, this.numThreads), (PrintWriter)outputWriter, (OutputWriter)outputWriter2, (CsmProgressListener)new CsmProgressAdapter(){
            private volatile int handled = 0;

            public void projectFilesCounted(CsmProject csmProject, int n) {
                outputWriter2.flush();
                outputWriter.println("Project " + csmProject.getName() + " has " + n + " files");
                outputWriter.flush();
                progressHandle.switchToDeterminate(n);
            }

            public synchronized void fileParsingStarted(CsmFile csmFile) {
                progressHandle.progress("Analyzing " + csmFile.getName(), ++this.handled);
            }

            public void projectParsingFinished(CsmProject csmProject) {
                lArray[1] = System.currentTimeMillis();
            }
        }, (AtomicBoolean)atomicBoolean);
        progressHandle.finish();
        outputWriter.println("Analyzing " + csmProject.getName() + " took " + (lArray[1] - lArray[0]) + "ms");
        outputWriter2.flush();
        outputWriter.flush();
    }

    static final class AllUsagesPerformanceAction
    extends TestProjectReferencesAction {
        AllUsagesPerformanceAction() {
            super(true, false, Boolean.FALSE);
        }
    }

    static final class AllUsagesAction
    extends TestProjectReferencesAction {
        AllUsagesAction() {
            super(true, false, Boolean.TRUE);
        }
    }

    static final class DirectUsageAction
    extends TestProjectReferencesAction {
        DirectUsageAction() {
            super(false, false, null);
        }
    }

    static final class SmartCompletionAnalyzerAction
    extends TestProjectReferencesAction {
        SmartCompletionAnalyzerAction() {
            super(false, true, null);
        }
    }
}

