/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.languages.LanguageDefinitionNotFoundException;
import org.netbeans.api.languages.ParseException;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.Language;
import org.netbeans.modules.languages.LanguageImpl;
import org.netbeans.modules.languages.NBSLanguageReader;
import org.netbeans.modules.languages.ParserManagerImpl;
import org.netbeans.modules.languages.Utils;
import org.netbeans.modules.languages.features.ActionCreator;
import org.netbeans.modules.languages.features.ColorsManager;
import org.netbeans.modules.languages.features.LocalizationSupport;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.util.RequestProcessor;

public class LanguagesManager
extends org.netbeans.api.languages.LanguagesManager {
    private static LanguagesManager languagesManager;
    private Language parsingLanguage = Language.create("parsing...");
    private Map<String, Language> mimeTypeToLanguage = new HashMap<String, Language>();
    private Set<FileObject> listeningOn = new HashSet<FileObject>();
    private Listener listener;

    public static LanguagesManager getDefault() {
        if (languagesManager == null) {
            languagesManager = new LanguagesManager();
        }
        return languagesManager;
    }

    public boolean isSupported(String string) {
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        return fileSystem.findResource("Editors/" + string + "/language.nbs") != null;
    }

    public boolean createDataObjectFor(String string) {
        if (!this.isSupported(string)) {
            return false;
        }
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        FileObject fileObject = fileSystem.findResource("Editors/" + string);
        if (fileObject == null) {
            return false;
        }
        Boolean bl = (Boolean)fileObject.getAttribute("createDataObject");
        if (bl == null) {
            return true;
        }
        return bl;
    }

    public static String normalizeMimeType(String string) {
        if (string.startsWith("test")) {
            int n = string.indexOf(95);
            if (n < 0) {
                return string;
            }
            string = string.substring(n + 1);
        }
        return string;
    }

    public synchronized Language getLanguage(String string) throws LanguageDefinitionNotFoundException {
        if (!this.mimeTypeToLanguage.containsKey(string = LanguagesManager.normalizeMimeType(string))) {
            this.mimeTypeToLanguage.put(string, this.parsingLanguage);
            FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
            FileObject fileObject = fileSystem.findResource("Editors/" + string + "/language.nbs");
            if (fileObject == null) {
                this.mimeTypeToLanguage.remove(string);
                throw new LanguageDefinitionNotFoundException("Language definition for " + string + " not found.");
            }
            this.addListener(fileObject);
            try {
                NBSLanguageReader nBSLanguageReader = NBSLanguageReader.create(fileObject, string);
                final LanguageImpl languageImpl = new LanguageImpl(string, nBSLanguageReader);
                languageImpl.addPropertyChangeListener(new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        LanguagesManager.initLanguage(languageImpl);
                        languageImpl.removePropertyChangeListener(this);
                    }
                });
                final String string2 = string;
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        try {
                            languageImpl.read();
                        }
                        catch (ParseException parseException) {
                            Utils.message("Editors/" + string2 + "/language.nbs: " + parseException.getMessage());
                        }
                        catch (IOException iOException) {
                            Utils.message("Editors/" + string2 + "/language.nbs: " + iOException.getMessage());
                        }
                    }
                }, 2000);
                this.mimeTypeToLanguage.put(string, languageImpl);
            }
            catch (IOException iOException) {
                this.mimeTypeToLanguage.put(string, Language.create(string));
                Utils.message("Editors/" + string + "/language.nbs: " + iOException.getMessage());
            }
        }
        if (this.parsingLanguage == this.mimeTypeToLanguage.get(string)) {
            throw new IllegalArgumentException();
        }
        return this.mimeTypeToLanguage.get(string);
    }

    public void addLanguage(Language language) {
        this.mimeTypeToLanguage.put(language.getMimeType(), language);
    }

    private void languageChanged(String string) {
        Language language = this.mimeTypeToLanguage.get(string);
        if (language != null && language instanceof LanguageImpl) {
            try {
                FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
                FileObject fileObject = fileSystem.findResource("Editors/" + string + "/language.nbs");
                if (fileObject == null) {
                    this.mimeTypeToLanguage.remove(string);
                    throw new LanguageDefinitionNotFoundException("Language definition for " + string + " not found.");
                }
                NBSLanguageReader nBSLanguageReader = NBSLanguageReader.create(fileObject, string);
                ((LanguageImpl)language).read(nBSLanguageReader);
            }
            catch (ParseException parseException) {
                Utils.message("Editors/" + string + "/language.nbs: " + parseException.getMessage());
            }
            catch (IOException iOException) {
                Utils.message("Editors/" + string + "/language.nbs: " + iOException.getMessage());
            }
        }
        ParserManagerImpl.refreshHack();
    }

    private void addListener(FileObject fileObject) {
        if (!this.listeningOn.contains(fileObject)) {
            if (this.listener == null) {
                this.listener = new Listener();
            }
            fileObject.addFileChangeListener((FileChangeListener)this.listener);
            this.listeningOn.add(fileObject);
        }
    }

    private static void initLanguage(final Language language) {
        try {
            final FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
            final FileObject fileObject = fileSystem.findResource("Editors/" + language.getMimeType());
            fileSystem.runAtomicAction(new FileSystem.AtomicAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    block11: {
                        try {
                            String string;
                            if (fileObject.getFileObject("SideBar/org-netbeans-modules-languages-features-CodeFoldingSideBarFactory.instance") == null && language.getFeatureList().getFeatures("FOLD").size() > 0) {
                                FileUtil.createData((FileObject)fileObject, (String)"FoldManager/org-netbeans-modules-languages-features-LanguagesFoldManager$Factory.instance");
                                FileUtil.createData((FileObject)fileObject, (String)"SideBar/org-netbeans-modules-languages-features-CodeFoldingSideBarFactory.instance").setAttribute("position", (Object)1000);
                            }
                            if (fileObject.getFileObject("UpToDateStatusProvider/org-netbeans-modules-languages-features-UpToDateStatusProviderFactoryImpl.instance") == null) {
                                FileUtil.createData((FileObject)fileObject, (String)"UpToDateStatusProvider/org-netbeans-modules-languages-features-UpToDateStatusProviderFactoryImpl.instance");
                            }
                            LanguagesManager.initPopupMenu(fileObject, language);
                            if (language.getFeatureList().getFeatures("NAVIGATOR").size() > 0 && fileSystem.findResource(string = "Navigator/Panels/" + language.getMimeType() + "/org-netbeans-modules-languages-features-LanguagesNavigator.instance") == null) {
                                FileUtil.createData((FileObject)fileSystem.getRoot(), (String)string);
                            }
                            FileUtil.createData((FileObject)fileObject, (String)"ToolTips/org-netbeans-modules-languages-features-ToolTipAnnotation.instance");
                            if (language.getFeatureList().getFeature("COMMENT_LINE") == null) break block11;
                            string = FileUtil.createFolder((FileObject)fileObject, (String)"Toolbars/Default");
                            LanguagesManager.createSeparator((FileObject)string, "Separator-before-comment", 30000);
                            FileUtil.createData((FileObject)string, (String)"comment").setAttribute("position", (Object)31000);
                            FileUtil.createData((FileObject)string, (String)"uncomment").setAttribute("position", (Object)32000);
                            if (fileObject.getFileObject("Keybindings/NetBeans/Defaults/keybindings.xml") != null) break block11;
                            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("org/netbeans/modules/languages/resources/DefaultKeyBindings.xml");
                            try {
                                FileObject fileObject2 = FileUtil.createData((FileObject)fileObject, (String)"Keybindings/NetBeans/Defaults/keybindings.xml");
                                OutputStream outputStream = fileObject2.getOutputStream();
                                try {
                                    FileUtil.copy((InputStream)inputStream, (OutputStream)outputStream);
                                }
                                finally {
                                    outputStream.close();
                                }
                            }
                            finally {
                                inputStream.close();
                            }
                        }
                        catch (IOException iOException) {
                            Utils.notify(iOException);
                        }
                    }
                }
            });
        }
        catch (IOException iOException) {
            Utils.notify(iOException);
        }
        ColorsManager.initColorings(language);
    }

    private static void initPopupMenu(FileObject fileObject, Language language) throws IOException {
        List<Feature> list = language.getFeatureList().getFeatures("ACTION");
        int n = LanguagesManager.findPositionOfDefaultPopupAction("org-netbeans-modules-editor-NbSelectInPopupAction.instance", 1000);
        int n2 = (LanguagesManager.findPositionOfDefaultPopupAction("org-openide-actions-CutAction.instance", 2000) - n) / (list.size() + 3);
        FileObject fileObject2 = FileUtil.createFolder((FileObject)fileObject, (String)"Popup");
        int n3 = n + n2;
        LanguagesManager.createSeparator(fileObject2, "SeparatorAfterSelectInPopupAction", n3);
        boolean bl = false;
        bl = true;
        FileUtil.createData((FileObject)fileObject2, (String)"org-netbeans-modules-languages-features-GoToDeclarationAction.instance").setAttribute("position", (Object)(n3 += n2));
        if (language.getFeatureList().getFeatures("INDENT").size() > 0) {
            bl = true;
            FileUtil.createData((FileObject)fileObject2, (String)"format").setAttribute("position", (Object)(n3 += n2));
        }
        for (Feature feature : list) {
            if (feature.getBoolean("explorer", false)) continue;
            bl = true;
            n3 += n2;
            String string = feature.getSelector().getAsString();
            String string2 = LocalizationSupport.localize(language, (String)feature.getValue("name"));
            String string3 = feature.getMethodName("performer");
            String string4 = feature.getMethodName("enabled");
            boolean bl2 = feature.getBoolean("separator_before", false);
            boolean bl3 = feature.getBoolean("separator_after", false);
            FileObject fileObject3 = FileUtil.createData((FileObject)fileObject2, (String)(string + ".instance"));
            fileObject3.setAttribute("instanceCreate", (Object)new ActionCreator(new Object[]{string2, string3, string4}));
            fileObject3.setAttribute("instanceClass", (Object)"org.netbeans.modules.languages.features.GenericAction");
            fileObject3.setAttribute("position", (Object)n3);
            if (bl2) {
                LanguagesManager.createSeparator(fileObject2, string + "_separator_before", n3 - n2 / 3);
            }
            if (!bl3) continue;
            LanguagesManager.createSeparator(fileObject2, string + "_separator_after", n3 + n2 / 3);
        }
        if (bl) {
            LanguagesManager.createSeparator(fileObject2, "SeparatorBeforeCut", n3 + n2);
        }
        if (language.getFeatureList().getFeatures("FOLD").size() > 0) {
            FileUtil.createData((FileObject)fileObject2, (String)"generate-fold-popup").setAttribute("position", (Object)(LanguagesManager.findPositionOfDefaultPopupAction("org-openide-actions-PasteAction.instance", 3000) + 50));
        }
    }

    private static int findPositionOfDefaultPopupAction(String string, int n) {
        Object object;
        FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource("Editors/Popup/" + string);
        if (fileObject != null && (object = fileObject.getAttribute("position")) instanceof Integer) {
            return (Integer)object;
        }
        return n;
    }

    private static void createSeparator(FileObject fileObject, String string, int n) throws IOException {
        FileObject fileObject2 = FileUtil.createData((FileObject)fileObject, (String)(string + ".instance"));
        fileObject2.setAttribute("instanceClass", (Object)"javax.swing.JSeparator");
        fileObject2.setAttribute("position", (Object)n);
    }

    private class Listener
    implements FileChangeListener {
        private Listener() {
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        }

        public void fileChanged(FileEvent fileEvent) {
            FileObject fileObject = fileEvent.getFile();
            String string = fileObject.getParent().getParent().getName() + '/' + fileObject.getParent().getName();
            LanguagesManager.this.languageChanged(string);
        }

        public void fileDataCreated(FileEvent fileEvent) {
        }

        public void fileDeleted(FileEvent fileEvent) {
            FileObject fileObject = fileEvent.getFile();
            String string = fileObject.getParent().getName();
            LanguagesManager.this.languageChanged(string);
        }

        public void fileFolderCreated(FileEvent fileEvent) {
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
        }
    }
}

