/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.wizards.shortcut;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.apache.tools.ant.module.wizards.shortcut.CustomizeScriptPanel;
import org.apache.tools.ant.module.wizards.shortcut.IntroPanel;
import org.apache.tools.ant.module.wizards.shortcut.SelectFolderPanel;
import org.apache.tools.ant.module.wizards.shortcut.SelectKeyboardShortcutPanel;
import org.apache.tools.ant.module.wizards.shortcut.ShortcutWizard;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ShortcutIterator
implements WizardDescriptor.Iterator<ShortcutWizard> {
    private transient int index;
    private transient List<WizardDescriptor.Panel<ShortcutWizard>> panels;
    private transient ShortcutWizard wiz;
    private transient ChangeSupport cs = new ChangeSupport((Object)this);

    ShortcutIterator() {
    }

    private List<WizardDescriptor.Panel<ShortcutWizard>> createPanels() {
        ArrayList<WizardDescriptor.Panel<ShortcutWizard>> arrayList = new ArrayList<WizardDescriptor.Panel<ShortcutWizard>>();
        arrayList.add(new IntroPanel.IntroWizardPanel());
        arrayList.add(new SelectFolderPanel.SelectFolderWizardPanel(NbBundle.getMessage(ShortcutIterator.class, (String)"SI_LBL_select_menu_to_add_to"), NbBundle.getMessage(ShortcutIterator.class, (String)"SI_TEXT_menu_locn"), NbBundle.getMessage(ShortcutIterator.class, (String)"SI_LBL_display_name_for_menu"), DataFolder.findFolder((FileObject)FileUtil.getConfigFile((String)"Menu")), true, "wizdata.folder.menu"));
        arrayList.add(new SelectFolderPanel.SelectFolderWizardPanel(NbBundle.getMessage(ShortcutIterator.class, (String)"SI_LBL_select_toolbar"), NbBundle.getMessage(ShortcutIterator.class, (String)"SI_TEXT_toolbar_locn"), NbBundle.getMessage(ShortcutIterator.class, (String)"SI_LBL_display_name_for_toolbar"), DataFolder.findFolder((FileObject)FileUtil.getConfigFile((String)"Toolbars")), false, "wizdata.folder.tool"));
        arrayList.add(new SelectKeyboardShortcutPanel.SelectKeyboardShortcutWizardPanel());
        arrayList.add(new CustomizeScriptPanel.CustomizeScriptWizardPanel());
        return arrayList;
    }

    private String[] createSteps() {
        return new String[]{NbBundle.getMessage(ShortcutIterator.class, (String)"SI_LBL_choose_options"), NbBundle.getMessage(ShortcutIterator.class, (String)"SI_LBL_add_to_menu"), NbBundle.getMessage(ShortcutIterator.class, (String)"SI_LBL_add_to_toolbar"), NbBundle.getMessage(ShortcutIterator.class, (String)"SI_LBL_make_keyboard_shortcut"), NbBundle.getMessage(ShortcutIterator.class, (String)"SI_LBL_cust_script")};
    }

    void initialize(ShortcutWizard shortcutWizard) {
        this.wiz = shortcutWizard;
        this.index = 0;
        this.panels = this.createPanels();
        ((IntroPanel.IntroWizardPanel)this.panels.get(0)).initialize(shortcutWizard);
        String[] stringArray = this.createSteps();
        for (int i = 0; i < this.panels.size(); ++i) {
            Component component = this.panels.get(i).getComponent();
            if (stringArray[i] == null) {
                stringArray[i] = component.getName();
            }
            if (!(component instanceof JComponent)) continue;
            JComponent jComponent = (JComponent)component;
            jComponent.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jComponent.putClientProperty("WizardPanel_contentData", stringArray);
        }
    }

    public String name() {
        return NbBundle.getMessage(ShortcutIterator.class, (String)"TITLE_x_of_y", (Object)(this.index + 1), (Object)this.panels.size());
    }

    boolean showing(String string) {
        Boolean bl = (Boolean)this.wiz.getProperty(string);
        return bl == null || bl != false;
    }

    private boolean showing(int n) throws NoSuchElementException {
        switch (n) {
            case 0: {
                return true;
            }
            case 1: {
                return this.showing("wizdata.show.menu");
            }
            case 2: {
                return this.showing("wizdata.show.tool");
            }
            case 3: {
                return this.showing("wizdata.show.keyb");
            }
            case 4: {
                return this.showing("wizdata.show.cust");
            }
        }
        throw new NoSuchElementException();
    }

    public boolean hasNext() {
        for (int i = this.index + 1; i < this.panels.size(); ++i) {
            if (!this.showing(i)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
        while (!this.showing(this.index)) {
            ++this.index;
        }
        if (this.index == 1) {
            this.fireChangeEvent();
        }
    }

    public void previousPanel() throws NoSuchElementException {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
        while (!this.showing(this.index)) {
            --this.index;
        }
    }

    public WizardDescriptor.Panel<ShortcutWizard> current() {
        return this.panels.get(this.index);
    }

    public final void addChangeListener(ChangeListener changeListener) {
        this.cs.addChangeListener(changeListener);
    }

    public final void removeChangeListener(ChangeListener changeListener) {
        this.cs.removeChangeListener(changeListener);
    }

    protected final void fireChangeEvent() {
        this.cs.fireChange();
    }
}

