/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutdesign;

import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.netbeans.modules.form.layoutdesign.LayoutComponent;
import org.netbeans.modules.form.layoutdesign.LayoutConstants;
import org.netbeans.modules.form.layoutdesign.LayoutEvent;
import org.netbeans.modules.form.layoutdesign.LayoutInterval;
import org.netbeans.modules.form.layoutdesign.LayoutPersistenceManager;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutModel
implements LayoutConstants {
    private Map<String, LayoutComponent> idToComponents = new HashMap<String, LayoutComponent>();
    private ArrayList<Listener> listeners;
    private boolean recordingChanges = true;
    private boolean undoRedoInProgress;
    private int changeMark;
    private int oldestMark;
    private int changeCountHardLimit = 10000;
    private Map<Integer, LayoutEvent> undoMap = new HashMap<Integer, LayoutEvent>(500);
    private Map<Integer, LayoutEvent> redoMap = new HashMap<Integer, LayoutEvent>(100);
    private LayoutUndoableEdit lastUndoableEdit;
    private boolean corrected;
    private Map<Integer, List<String>> linkSizeGroupsH = new HashMap<Integer, List<String>>();
    private Map<Integer, List<String>> linkSizeGroupsV = new HashMap<Integer, List<String>>();
    private int maxLinkGroupId = 0;

    public LayoutComponent getLayoutComponent(String string) {
        return this.idToComponents.get(string);
    }

    public void addRootComponent(LayoutComponent layoutComponent) {
        this.addComponent(layoutComponent, null, -1);
    }

    public void removeComponent(String string, boolean bl) {
        LayoutComponent layoutComponent = this.getLayoutComponent(string);
        if (layoutComponent != null) {
            this.removeComponentAndIntervals(layoutComponent, bl);
        }
    }

    public boolean changeComponentToContainer(String string) {
        LayoutComponent layoutComponent = this.getLayoutComponent(string);
        if (layoutComponent != null) {
            this.setLayoutContainer(layoutComponent, true);
            return true;
        }
        return false;
    }

    public boolean changeContainerToComponent(String string) {
        LayoutComponent layoutComponent = this.getLayoutComponent(string);
        if (layoutComponent == null) {
            return false;
        }
        for (int i = layoutComponent.getSubComponentCount() - 1; i >= 0; --i) {
            LayoutComponent layoutComponent2 = layoutComponent.getSubComponent(i);
            if (layoutComponent2.isLayoutContainer()) {
                this.removeComponentAndIntervals(layoutComponent2, false);
                continue;
            }
            this.removeComponent(layoutComponent2, true);
        }
        this.setLayoutContainer(layoutComponent, false);
        if (layoutComponent.getParent() == null) {
            this.removeComponent(layoutComponent, true);
        }
        return true;
    }

    void registerComponent(LayoutComponent layoutComponent, boolean bl) {
        this.registerComponentImpl(layoutComponent);
        if (bl && layoutComponent.isLayoutContainer()) {
            for (LayoutComponent layoutComponent2 : layoutComponent.getSubcomponents()) {
                this.registerComponent(layoutComponent2, bl);
            }
        }
    }

    void registerComponentImpl(LayoutComponent layoutComponent) {
        LayoutComponent layoutComponent2 = this.idToComponents.put(layoutComponent.getId(), layoutComponent);
        if (layoutComponent2 != layoutComponent) {
            LayoutEvent.Component component = new LayoutEvent.Component(this, 11);
            component.setComponent(layoutComponent);
            this.addChange(component);
            this.fireEvent(component);
        }
    }

    void unregisterComponent(LayoutComponent layoutComponent, boolean bl) {
        if (bl && layoutComponent.isLayoutContainer()) {
            for (LayoutComponent layoutComponent2 : layoutComponent.getSubcomponents()) {
                this.unregisterComponent(layoutComponent2, bl);
            }
        }
        this.removeComponentFromLinkSizedGroup(layoutComponent, 0);
        this.removeComponentFromLinkSizedGroup(layoutComponent, 1);
        this.unregisterComponentImpl(layoutComponent);
    }

    void unregisterComponentImpl(LayoutComponent layoutComponent) {
        LayoutComponent layoutComponent2 = this.idToComponents.remove(layoutComponent.getId());
        if (layoutComponent2 != null) {
            LayoutEvent.Component component = new LayoutEvent.Component(this, 12);
            component.setComponent(layoutComponent);
            this.addChange(component);
            this.fireEvent(component);
        }
    }

    void changeComponentId(LayoutComponent layoutComponent, String string) {
        this.unregisterComponentImpl(layoutComponent);
        layoutComponent.setId(string);
        this.registerComponentImpl(layoutComponent);
    }

    void replaceComponent(LayoutComponent layoutComponent, LayoutComponent layoutComponent2) {
        assert (layoutComponent2.getParent() == null);
        for (int i = 0; i < 2; ++i) {
            LayoutInterval layoutInterval = layoutComponent.getLayoutInterval(i);
            LayoutInterval layoutInterval2 = layoutComponent2.getLayoutInterval(i);
            assert (layoutInterval2.getParent() == null);
            this.setIntervalAlignment(layoutInterval2, layoutInterval.getRawAlignment());
            this.setIntervalSize(layoutInterval2, layoutInterval.getMinimumSize(), layoutInterval.getPreferredSize(), layoutInterval.getMaximumSize());
            LayoutInterval layoutInterval3 = layoutInterval.getParent();
            if (layoutInterval3 == null) continue;
            int n = this.removeInterval(layoutInterval);
            this.addInterval(layoutInterval2, layoutInterval3, n);
        }
        LayoutComponent layoutComponent3 = layoutComponent.getParent();
        if (layoutComponent3 != null) {
            int n = this.removeComponentImpl(layoutComponent);
            this.addComponentImpl(layoutComponent2, layoutComponent3, n);
        }
        this.unregisterComponentImpl(layoutComponent);
        this.registerComponentImpl(layoutComponent2);
    }

    Iterator getAllComponents() {
        return this.idToComponents.values().iterator();
    }

    void addComponent(LayoutComponent layoutComponent, LayoutComponent layoutComponent2, int n) {
        this.addComponentImpl(layoutComponent, layoutComponent2, n);
        this.registerComponent(layoutComponent, true);
    }

    void addComponentImpl(LayoutComponent layoutComponent, LayoutComponent layoutComponent2, int n) {
        assert (layoutComponent.getParent() == null);
        if (layoutComponent2 != null) {
            assert (this.getLayoutComponent(layoutComponent2.getId()) == layoutComponent2);
            n = layoutComponent2.addComponent(layoutComponent, n);
        } else assert (layoutComponent.isLayoutContainer());
        LayoutEvent.Component component = new LayoutEvent.Component(this, 1);
        component.setComponent(layoutComponent, layoutComponent2, n);
        this.addChange(component);
        this.fireEvent(component);
    }

    void removeComponent(LayoutComponent layoutComponent, boolean bl) {
        this.removeComponentImpl(layoutComponent);
        if (bl && this.getLayoutComponent(layoutComponent.getId()) != null) {
            this.unregisterComponent(layoutComponent, true);
        }
    }

    int removeComponentImpl(LayoutComponent layoutComponent) {
        LayoutComponent layoutComponent2 = layoutComponent.getParent();
        if (layoutComponent2 == null) {
            return -1;
        }
        int n = layoutComponent2.removeComponent(layoutComponent);
        LayoutEvent.Component component = new LayoutEvent.Component(this, 2);
        component.setComponent(layoutComponent, layoutComponent2, n);
        this.addChange(component);
        this.fireEvent(component);
        return n;
    }

    void removeComponentAndIntervals(LayoutComponent layoutComponent, boolean bl) {
        if (layoutComponent.getParent() != null) {
            for (int i = 0; i < 2; ++i) {
                LayoutInterval layoutInterval = layoutComponent.getLayoutInterval(i);
                if (layoutInterval.getParent() == null) continue;
                this.removeInterval(layoutInterval);
            }
        }
        this.removeComponent(layoutComponent, bl);
    }

    LayoutInterval[] addNewLayoutRoots(LayoutComponent layoutComponent) {
        LayoutInterval[] layoutIntervalArray = layoutComponent.addNewLayoutRoots();
        LayoutEvent.Component component = new LayoutEvent.Component(this, 14);
        component.setLayoutRoots(layoutComponent, layoutIntervalArray, -1);
        this.addChange(component);
        return layoutIntervalArray;
    }

    LayoutInterval[] removeLayoutRoots(LayoutComponent layoutComponent, LayoutInterval layoutInterval) {
        LayoutInterval[] layoutIntervalArray = layoutComponent.getLayoutRoots(layoutInterval);
        if (layoutIntervalArray != null) {
            int n = layoutComponent.removeLayoutRoots(layoutIntervalArray);
            LayoutEvent.Component component = new LayoutEvent.Component(this, 15);
            component.setLayoutRoots(layoutComponent, layoutIntervalArray, n);
            this.addChange(component);
        }
        return layoutIntervalArray;
    }

    void addInterval(LayoutInterval layoutInterval, LayoutInterval layoutInterval2, int n) {
        assert (layoutInterval.getParent() == null);
        n = layoutInterval2.add(layoutInterval, n);
        LayoutEvent.Interval interval = new LayoutEvent.Interval(this, 3);
        interval.setInterval(layoutInterval, layoutInterval2, n);
        this.addChange(interval);
        this.fireEvent(interval);
    }

    int removeInterval(LayoutInterval layoutInterval) {
        LayoutInterval layoutInterval2 = layoutInterval.getParent();
        int n = layoutInterval2.remove(layoutInterval);
        LayoutEvent.Interval interval = new LayoutEvent.Interval(this, 4);
        interval.setInterval(layoutInterval, layoutInterval2, n);
        this.addChange(interval);
        this.fireEvent(interval);
        return n;
    }

    LayoutInterval removeInterval(LayoutInterval layoutInterval, int n) {
        LayoutInterval layoutInterval2 = layoutInterval.remove(n);
        LayoutEvent.Interval interval = new LayoutEvent.Interval(this, 4);
        interval.setInterval(layoutInterval2, layoutInterval, n);
        this.addChange(interval);
        this.fireEvent(interval);
        return layoutInterval2;
    }

    void changeIntervalAttribute(LayoutInterval layoutInterval, int n, boolean bl) {
        int n2 = layoutInterval.getAttributes();
        if (bl) {
            layoutInterval.setAttribute(n);
        } else {
            layoutInterval.unsetAttribute(n);
        }
        int n3 = layoutInterval.getAttributes();
        LayoutEvent.Interval interval = new LayoutEvent.Interval(this, 8);
        interval.setAttributes(layoutInterval, n2, n3);
        this.addChange(interval);
    }

    void setIntervalAlignment(LayoutInterval layoutInterval, int n) {
        int n2 = layoutInterval.getRawAlignment();
        layoutInterval.setAlignment(n);
        LayoutEvent.Interval interval = new LayoutEvent.Interval(this, 5);
        interval.setAlignment(layoutInterval, n2, n);
        this.addChange(interval);
    }

    void setGroupAlignment(LayoutInterval layoutInterval, int n) {
        int n2 = layoutInterval.getGroupAlignment();
        if (n == n2) {
            return;
        }
        layoutInterval.setGroupAlignment(n);
        LayoutEvent.Interval interval = new LayoutEvent.Interval(this, 6);
        interval.setAlignment(layoutInterval, n2, n);
        this.addChange(interval);
    }

    void setLayoutContainer(LayoutComponent layoutComponent, boolean bl) {
        boolean bl2 = layoutComponent.isLayoutContainer();
        if (bl2 != bl) {
            List<LayoutInterval[]> list = layoutComponent.getLayoutRoots();
            layoutComponent.setLayoutContainer(bl, null);
            LayoutEvent.Component component = new LayoutEvent.Component(this, 10);
            component.setContainer(layoutComponent, list);
            this.addChange(component);
        }
    }

    public void setIntervalSize(LayoutInterval layoutInterval, int n, int n2, int n3) {
        Object object;
        int n4 = layoutInterval.getMinimumSize();
        int n5 = layoutInterval.getPreferredSize();
        int n6 = layoutInterval.getMaximumSize();
        if (n == n4 && n2 == n5 && n3 == n6) {
            return;
        }
        layoutInterval.setSizes(n, n2, n3);
        if (layoutInterval.isComponent()) {
            boolean bl;
            object = layoutInterval.getComponent();
            boolean bl2 = bl = layoutInterval == ((LayoutComponent)object).getLayoutInterval(0);
            if (n4 != n) {
                ((LayoutComponent)object).firePropertyChange(bl ? "horizontalMinSize" : "verticalMinSize", new Integer(n4), new Integer(n));
            }
            if (n5 != n2) {
                ((LayoutComponent)object).firePropertyChange(bl ? "horizontalPrefSize" : "verticalPrefSize", new Integer(n5), new Integer(n2));
            }
            if (n6 != n3) {
                ((LayoutComponent)object).firePropertyChange(bl ? "horizontalMaxSize" : "verticalMaxSize", new Integer(n6), new Integer(n3));
            }
        }
        object = new LayoutEvent.Interval(this, 7);
        ((LayoutEvent.Interval)object).setSize(layoutInterval, n4, n5, n6, n, n2, n3);
        this.addChange((LayoutEvent)object);
    }

    public void setPaddingType(LayoutInterval layoutInterval, LayoutConstants.PaddingType paddingType) {
        LayoutConstants.PaddingType paddingType2 = layoutInterval.getPaddingType();
        if (paddingType2 != paddingType) {
            layoutInterval.setPaddingType(paddingType);
            LayoutEvent.Interval interval = new LayoutEvent.Interval(this, 13);
            interval.setPaddingType(layoutInterval, paddingType2, paddingType);
            this.addChange(interval);
        }
    }

    public void copyContainerLayout(LayoutModel layoutModel, String string, Map<String, String> map, String string2) {
        LayoutComponent layoutComponent = layoutModel.getLayoutComponent(string);
        LayoutComponent layoutComponent2 = this.getLayoutComponent(string2);
        if (layoutComponent2 == null) {
            layoutComponent2 = new LayoutComponent(string2, true);
            this.addRootComponent(layoutComponent2);
        } else if (!layoutComponent2.isLayoutContainer()) {
            this.changeComponentToContainer(string2);
        }
        this.copyContainerLayout(layoutComponent, map, layoutComponent2);
    }

    void copyContainerLayout(LayoutComponent layoutComponent, Map<String, String> map, LayoutComponent layoutComponent2) {
        for (LayoutComponent object : layoutComponent.getSubcomponents()) {
            LayoutInterval[] layoutIntervalArray = map.get(object.getId());
            LayoutComponent layoutComponent3 = this.getLayoutComponent((String)layoutIntervalArray);
            if (layoutComponent3 == null) {
                layoutComponent3 = new LayoutComponent((String)layoutIntervalArray, object.isLayoutContainer());
            }
            if (layoutComponent3.getParent() != null) continue;
            this.addComponent(layoutComponent3, layoutComponent2, -1);
        }
        int n = 0;
        for (LayoutInterval[] layoutIntervalArray : layoutComponent.getLayoutRoots()) {
            if (n == layoutComponent2.getLayoutRootCount()) {
                this.addNewLayoutRoots(layoutComponent2);
            }
            for (int i = 0; i < 2; ++i) {
                this.copySubIntervals(layoutIntervalArray[i], layoutComponent2.getLayoutRoot(n, i), map);
            }
            ++n;
        }
    }

    private void copySubIntervals(LayoutInterval layoutInterval, LayoutInterval layoutInterval2, Map map) {
        Iterator<LayoutInterval> iterator = layoutInterval.getSubIntervals();
        while (iterator.hasNext()) {
            Object object;
            LayoutInterval layoutInterval3 = iterator.next();
            LayoutInterval layoutInterval4 = null;
            if (layoutInterval3.isComponent()) {
                object = (String)map.get(layoutInterval3.getComponent().getId());
                LayoutComponent layoutComponent = this.getLayoutComponent((String)object);
                int n = layoutInterval3 == layoutInterval3.getComponent().getLayoutInterval(0) ? 0 : 1;
                layoutInterval4 = layoutComponent.getLayoutInterval(n);
            }
            object = LayoutInterval.cloneInterval(layoutInterval3, layoutInterval4);
            if (layoutInterval3.isGroup()) {
                this.copySubIntervals(layoutInterval3, (LayoutInterval)object, map);
            }
            this.addInterval((LayoutInterval)object, layoutInterval2, -1);
        }
    }

    void moveContainerLayout(LayoutComponent layoutComponent, LayoutComponent layoutComponent2) {
        Object object;
        if (!layoutComponent.isLayoutContainer() || !layoutComponent2.isLayoutContainer() || layoutComponent2.getSubComponentCount() > 0) {
            throw new IllegalArgumentException();
        }
        while (layoutComponent.getSubComponentCount() > 0) {
            object = layoutComponent.getSubComponent(0);
            this.removeComponent((LayoutComponent)object, false);
            this.addComponent((LayoutComponent)object, layoutComponent2, -1);
        }
        object = layoutComponent.getLayoutRoots();
        layoutComponent.setLayoutRoots(null);
        LayoutEvent.Component component = new LayoutEvent.Component(this, 16);
        component.setLayoutRoots(layoutComponent, (List<LayoutInterval[]>)object, null);
        this.addChange(component);
        layoutComponent2.setLayoutRoots((List<LayoutInterval[]>)object);
        component = new LayoutEvent.Component(this, 16);
        component.setLayoutRoots(layoutComponent2, null, (List<LayoutInterval[]>)object);
        this.addChange(component);
    }

    static LayoutInterval[] createIntervalsFromBounds(Map<LayoutComponent, Rectangle> map) {
        RegionInfo regionInfo = new RegionInfo(map);
        regionInfo.calculateIntervals();
        LayoutInterval[] layoutIntervalArray = new LayoutInterval[2];
        for (int i = 0; i < 2; ++i) {
            layoutIntervalArray[i] = regionInfo.getInterval(i);
        }
        return layoutIntervalArray;
    }

    void addListener(Listener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        } else {
            this.listeners.remove(listener);
        }
        this.listeners.add(listener);
    }

    void removeListener(Listener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    private void fireEvent(LayoutEvent layoutEvent) {
        if (this.listeners != null && this.listeners.size() > 0) {
            Iterator iterator = ((List)this.listeners.clone()).iterator();
            while (iterator.hasNext()) {
                ((Listener)iterator.next()).layoutChanged(layoutEvent);
            }
        }
    }

    public boolean isChangeRecording() {
        return this.recordingChanges;
    }

    public void setChangeRecording(boolean bl) {
        this.recordingChanges = bl;
    }

    boolean isUndoRedoInProgress() {
        return this.undoRedoInProgress;
    }

    public Object getChangeMark() {
        return new Integer(this.changeMark);
    }

    public void endUndoableEdit() {
        if (this.lastUndoableEdit != null) {
            this.lastUndoableEdit.endMark = this.getChangeMark();
            this.lastUndoableEdit = null;
        }
    }

    public boolean isUndoableEditInProgress() {
        return this.lastUndoableEdit != null;
    }

    public UndoableEdit getUndoableEdit() {
        if (this.recordingChanges && !this.undoRedoInProgress) {
            LayoutUndoableEdit layoutUndoableEdit = new LayoutUndoableEdit();
            layoutUndoableEdit.startMark = this.getChangeMark();
            this.endUndoableEdit();
            this.lastUndoableEdit = layoutUndoableEdit;
            return layoutUndoableEdit;
        }
        return null;
    }

    private void addChange(LayoutEvent layoutEvent) {
        if (this.recordingChanges && !this.undoRedoInProgress) {
            this.redoMap.clear();
            if (this.undoMap.size() == 0) {
                this.oldestMark = this.changeMark;
            }
            this.undoMap.put(new Integer(this.changeMark++), layoutEvent);
            while (this.undoMap.size() > this.changeCountHardLimit) {
                this.undoMap.remove(new Integer(this.oldestMark++));
            }
        }
    }

    boolean undo(Object object, Object object2) {
        assert (!this.undoRedoInProgress);
        if (!this.undoMap.containsKey(object)) {
            return false;
        }
        int n = (Integer)object;
        int n2 = (Integer)object2;
        this.undoRedoInProgress = true;
        while (n2 > n) {
            Integer n3;
            LayoutEvent layoutEvent;
            if ((layoutEvent = this.undoMap.remove(n3 = new Integer(--n2))) == null) continue;
            layoutEvent.undo();
            this.redoMap.put(n3, layoutEvent);
        }
        this.undoRedoInProgress = false;
        return true;
    }

    boolean redo(Object object, Object object2) {
        assert (!this.undoRedoInProgress);
        if (!this.redoMap.containsKey(object)) {
            return false;
        }
        int n = (Integer)object;
        int n2 = (Integer)object2;
        this.undoRedoInProgress = true;
        while (n < n2) {
            Integer n3;
            LayoutEvent layoutEvent;
            if ((layoutEvent = this.redoMap.remove(n3 = new Integer(n++))) == null) continue;
            layoutEvent.redo();
            this.undoMap.put(n3, layoutEvent);
        }
        this.undoRedoInProgress = false;
        return true;
    }

    void releaseChanges(Object object, Object object2) {
        int n = (Integer)object2;
        for (int i = ((Integer)object).intValue(); i < n; ++i) {
            Integer n2 = new Integer(i);
            this.undoMap.remove(n2);
            this.redoMap.remove(n2);
        }
    }

    public String dump(Map<String, String> map) {
        return this.dump(map, null, true);
    }

    public String dump(final Map<String, String> map, String string, boolean bl) {
        Map.Entry<String, LayoutComponent> entry2;
        TreeSet<LayoutComponent> treeSet = new TreeSet<LayoutComponent>(new Comparator<LayoutComponent>(){

            @Override
            public int compare(LayoutComponent layoutComponent, LayoutComponent layoutComponent2) {
                if (layoutComponent == layoutComponent2) {
                    return 0;
                }
                if (layoutComponent.isParentOf(layoutComponent2)) {
                    return -1;
                }
                if (layoutComponent2.isParentOf(layoutComponent)) {
                    return 1;
                }
                LayoutComponent layoutComponent3 = LayoutComponent.getCommonParent(layoutComponent, layoutComponent2);
                while (layoutComponent.getParent() != layoutComponent3) {
                    layoutComponent = layoutComponent.getParent();
                }
                while (layoutComponent2.getParent() != layoutComponent3) {
                    layoutComponent2 = layoutComponent2.getParent();
                }
                if (layoutComponent3 != null) {
                    return layoutComponent3.indexOf(layoutComponent) < layoutComponent3.indexOf(layoutComponent2) ? -1 : 1;
                }
                String string = layoutComponent.getId();
                String string2 = layoutComponent2.getId();
                if (map != null) {
                    string = (String)map.get(string);
                    string2 = (String)map.get(string2);
                    if (string == null) {
                        return -1;
                    }
                    if (string2 == null) {
                        return 1;
                    }
                }
                return string.compareTo(string2);
            }
        });
        LayoutComponent layoutComponent = string != null ? this.getLayoutComponent(string) : null;
        for (Map.Entry<String, LayoutComponent> entry2 : this.idToComponents.entrySet()) {
            LayoutComponent layoutComponent2 = (LayoutComponent)entry2.getValue();
            if (!layoutComponent2.isLayoutContainer() || layoutComponent != null && layoutComponent2 != layoutComponent && (!bl || !layoutComponent.isParentOf(layoutComponent2))) continue;
            treeSet.add(layoutComponent2);
        }
        entry2 = new StringBuilder();
        ((StringBuilder)((Object)entry2)).append("<LayoutModel>\n");
        for (LayoutComponent layoutComponent3 : treeSet) {
            String string2 = layoutComponent3.getId();
            if (map != null) {
                string2 = map.get(string2);
            }
            if (string2 != null) {
                ((StringBuilder)((Object)entry2)).append("  <Root id=\"" + string2 + "\">\n");
            } else {
                ((StringBuilder)((Object)entry2)).append("  <Root>\n");
            }
            ((StringBuilder)((Object)entry2)).append(this.saveContainerLayout(layoutComponent3, map, 2, true));
            ((StringBuilder)((Object)entry2)).append("  </Root>\n");
        }
        ((StringBuilder)((Object)entry2)).append("</LayoutModel>\n");
        return ((StringBuilder)((Object)entry2)).toString();
    }

    public String dump(LayoutInterval layoutInterval, int n) {
        return LayoutPersistenceManager.dumpInterval(this, layoutInterval, n, 2);
    }

    public String saveContainerLayout(LayoutComponent layoutComponent, Map<String, String> map, int n, boolean bl) {
        return LayoutPersistenceManager.saveContainer(this, layoutComponent, map, n, bl);
    }

    public void loadContainerLayout(String string, NodeList nodeList, Map<String, String> map) throws IOException {
        LayoutPersistenceManager.loadContainer(this, string, nodeList, map);
    }

    public boolean wasCorrected() {
        return this.corrected;
    }

    void setCorrected() {
        this.corrected = true;
    }

    void addComponentToLinkSizedGroup(int n, String string, int n2) {
        Integer n3;
        Map<Integer, List<String>> map;
        List<String> list;
        if (-1 == n) {
            return;
        }
        if (this.maxLinkGroupId < n) {
            this.maxLinkGroupId = n;
        }
        if ((list = (map = n2 == 0 ? this.linkSizeGroupsH : this.linkSizeGroupsV).get(n3 = new Integer(n))) != null && (list.contains(string) || !this.sameContainer(string, list.get(0)))) {
            return;
        }
        this.addComponentToLinkSizedGroupImpl(n, string, n2);
    }

    void addComponentToLinkSizedGroupImpl(int n, String string, int n2) {
        Integer n3;
        LayoutComponent layoutComponent = this.getLayoutComponent(string);
        Map<Integer, List<String>> map = n2 == 0 ? this.linkSizeGroupsH : this.linkSizeGroupsV;
        List<String> list = map.get(n3 = new Integer(n));
        if (list != null) {
            list.add(layoutComponent.getId());
        } else {
            list = new ArrayList<String>();
            list.add(layoutComponent.getId());
            map.put(n3, list);
        }
        int n4 = layoutComponent.getLinkSizeId(n2);
        layoutComponent.setLinkSizeId(n, n2);
        LayoutEvent.Component component = new LayoutEvent.Component(this, 9);
        component.setLinkSizeGroup(layoutComponent, n4, n, n2);
        this.addChange(component);
        this.fireEvent(component);
    }

    private boolean sameContainer(String string, String string2) {
        LayoutComponent layoutComponent = this.getLayoutComponent(string);
        LayoutComponent layoutComponent2 = this.getLayoutComponent(string2);
        return layoutComponent.getParent().equals(layoutComponent2.getParent());
    }

    void removeComponentFromLinkSizedGroup(LayoutComponent layoutComponent, int n) {
        if (layoutComponent == null) {
            return;
        }
        int n2 = layoutComponent.getLinkSizeId(n);
        if (n2 != -1) {
            Object object;
            Map<Integer, List<String>> map = n == 0 ? this.linkSizeGroupsH : this.linkSizeGroupsV;
            Integer n3 = new Integer(n2);
            List<String> list = map.get(n3);
            list.remove(layoutComponent.getId());
            layoutComponent.setLinkSizeId(-1, n);
            if (list.size() == 1) {
                object = this.getLayoutComponent(list.get(0));
                int n4 = ((LayoutComponent)object).getLinkSizeId(n);
                ((LayoutComponent)object).setLinkSizeId(-1, n);
                map.remove(n3);
                LayoutEvent.Component component = new LayoutEvent.Component(this, 9);
                component.setLinkSizeGroup((LayoutComponent)object, n4, -1, n);
                this.addChange(component);
                this.fireEvent(component);
            }
            if (list.size() == 0) {
                map.remove(n3);
            }
            object = new LayoutEvent.Component(this, 9);
            ((LayoutEvent.Component)object).setLinkSizeGroup(layoutComponent, n2, -1, n);
            this.addChange((LayoutEvent)object);
            this.fireEvent((LayoutEvent)object);
        }
    }

    public int areComponentsLinkSized(List<String> list, int n) {
        if (list.size() == 1) {
            String string = list.get(0);
            boolean bl = this.getLayoutComponent(string).isLinkSized(n);
            return bl ? 1 : 0;
        }
        Iterator<String> iterator = list.iterator();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        while (iterator.hasNext()) {
            String string = iterator.next();
            LayoutComponent layoutComponent = this.getLayoutComponent(string);
            Integer n2 = new Integer(layoutComponent.getLinkSizeId(n));
            if (!arrayList.contains(n2)) {
                arrayList.add(n2);
            }
            if (arrayList.size() <= 2) continue;
            return -1;
        }
        if (arrayList.size() == 1) {
            if (arrayList.contains(new Integer(-1))) {
                return 0;
            }
            return 1;
        }
        if (arrayList.contains(new Integer(-1))) {
            return 0;
        }
        return -1;
    }

    Map<Integer, List<String>> getLinkSizeGroups(int n) {
        if (0 == n) {
            return this.linkSizeGroupsH;
        }
        if (1 == n) {
            return this.linkSizeGroupsV;
        }
        return null;
    }

    public void unsetSameSize(List list, int n) {
        for (String string : list) {
            LayoutComponent layoutComponent = this.getLayoutComponent(string);
            this.removeComponentFromLinkSizedGroup(layoutComponent, n);
        }
    }

    public void setSameSize(List list, int n) {
        Iterator iterator = list.iterator();
        int n2 = this.findGroupId(list, n);
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            LayoutComponent layoutComponent = this.getLayoutComponent(string);
            this.addComponentToLinkSizedGroup(n2, layoutComponent.getId(), n);
        }
    }

    private int findGroupId(List list, int n) {
        for (String string : list) {
            LayoutComponent layoutComponent = this.getLayoutComponent(string);
            if (!layoutComponent.isLinkSized(n)) continue;
            return layoutComponent.getLinkSizeId(n);
        }
        return ++this.maxLinkGroupId;
    }

    private class LayoutUndoableEdit
    extends AbstractUndoableEdit {
        private Object startMark;
        private Object endMark;

        private LayoutUndoableEdit() {
        }

        public void undo() throws CannotUndoException {
            super.undo();
            if (this.endMark == null) {
                assert (LayoutModel.this.lastUndoableEdit == this);
                this.endMark = LayoutModel.this.getChangeMark();
                LayoutModel.this.lastUndoableEdit = null;
            }
            LayoutModel.this.undo(this.startMark, this.endMark);
        }

        public void redo() throws CannotRedoException {
            super.redo();
            LayoutModel.this.redo(this.startMark, this.endMark);
        }

        public String getUndoPresentationName() {
            return "";
        }

        public String getRedoPresentationName() {
            return "";
        }

        public void die() {
            LayoutModel.this.releaseChanges(this.startMark, this.endMark != null ? this.endMark : LayoutModel.this.getChangeMark());
        }
    }

    static interface Listener {
        public void layoutChanged(LayoutEvent var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RegionInfo {
        private LayoutInterval horizontal = null;
        private LayoutInterval vertical = null;
        private Map<LayoutComponent, Rectangle> compToBounds;
        private int minx;
        private int maxx;
        private int miny;
        private int maxy;
        private int dimension;

        public RegionInfo(Map<LayoutComponent, Rectangle> map) {
            this.compToBounds = map;
            this.dimension = -1;
            this.miny = 0;
            this.minx = 0;
            this.updateRegionBounds();
        }

        private RegionInfo(Map<LayoutComponent, Rectangle> map, int n) {
            this.compToBounds = map;
            this.dimension = n;
            this.miny = Short.MAX_VALUE;
            this.minx = Short.MAX_VALUE;
            this.updateRegionBounds();
        }

        private void updateRegionBounds() {
            this.maxx = Short.MIN_VALUE;
            this.maxy = Short.MIN_VALUE;
            for (Rectangle rectangle : this.compToBounds.values()) {
                this.minx = Math.min(this.minx, rectangle.x);
                this.miny = Math.min(this.miny, rectangle.y);
                this.maxx = Math.max(this.maxx, rectangle.x + rectangle.width);
                this.maxy = Math.max(this.maxy, rectangle.y + rectangle.height);
            }
        }

        /*
         * WARNING - void declaration
         */
        public void calculateIntervals() {
            Object object;
            if (this.compToBounds.size() == 1) {
                Map.Entry<LayoutComponent, Rectangle> entry = this.compToBounds.entrySet().iterator().next();
                LayoutComponent layoutComponent = entry.getKey();
                Rectangle rectangle = entry.getValue();
                this.horizontal = layoutComponent.getLayoutInterval(0);
                this.horizontal = this.prefixByGap(this.horizontal, rectangle.x - this.minx);
                this.vertical = layoutComponent.getLayoutInterval(1);
                this.vertical = this.prefixByGap(this.vertical, rectangle.y - this.miny);
                return;
            }
            int n = -1;
            List<Map<LayoutComponent, Rectangle>> list = null;
            HashMap<LayoutComponent, Rectangle> hashMap = null;
            do {
                Iterator<Map<LayoutComponent, Rectangle>> iterator;
                boolean bl;
                boolean bl2 = bl = this.dimension == -1 && n == 0 || this.dimension != -1 && n != -1;
                if (bl) {
                    n = -1;
                }
                if (this.dimension == -1) {
                    switch (n) {
                        case -1: {
                            n = 1;
                            break;
                        }
                        case 1: {
                            n = 0;
                            break;
                        }
                        case 0: {
                            bl = true;
                        }
                    }
                } else {
                    n = this.dimension;
                }
                if (bl) {
                    iterator = this.compToBounds.entrySet().iterator().next();
                    LayoutComponent object2 = (LayoutComponent)iterator.getKey();
                    object = (Rectangle)iterator.getValue();
                    if (hashMap == null) {
                        hashMap = new HashMap<LayoutComponent, Rectangle>();
                    }
                    hashMap.put(object2, (Rectangle)object);
                    this.compToBounds.remove(object2);
                }
                iterator = this.createPossibleCuts(n);
                list = this.cutIntoParts((Set<Integer>)((Object)iterator), n);
            } while (!this.compToBounds.isEmpty() && list.isEmpty());
            this.dimension = n;
            LinkedList<Object> linkedList = new LinkedList<Object>();
            for (Map<LayoutComponent, Rectangle> map : list) {
                object = new RegionInfo(map, this.dimension == 0 ? 1 : 0);
                ((RegionInfo)object).calculateIntervals();
                linkedList.add(object);
            }
            this.mergeSubRegions(linkedList, this.dimension);
            if (hashMap != null) {
                void var6_14;
                boolean bl = false;
                while (var6_14 <= true) {
                    Object object2 = object = var6_14 == false ? this.horizontal : this.vertical;
                    if (!((LayoutInterval)object).isParallel()) {
                        LayoutInterval layoutInterval = new LayoutInterval(103);
                        layoutInterval.add((LayoutInterval)object, -1);
                        if (var6_14 == false) {
                            this.horizontal = layoutInterval;
                        } else {
                            this.vertical = layoutInterval;
                        }
                        object = layoutInterval;
                    }
                    for (Map.Entry entry : hashMap.entrySet()) {
                        LayoutComponent layoutComponent = (LayoutComponent)entry.getKey();
                        Rectangle rectangle = (Rectangle)entry.getValue();
                        LayoutInterval layoutInterval = layoutComponent.getLayoutInterval((int)var6_14);
                        int n2 = var6_14 == false ? rectangle.x - this.minx : rectangle.y - this.miny;
                        layoutInterval = this.prefixByGap(layoutInterval, n2);
                        ((LayoutInterval)object).add(layoutInterval, -1);
                    }
                    ++var6_14;
                }
            }
        }

        private SortedSet<Integer> createPossibleCuts(int n) {
            TreeSet<Integer> treeSet = new TreeSet<Integer>();
            for (Rectangle rectangle : this.compToBounds.values()) {
                int n2 = n == 0 ? rectangle.x : rectangle.y;
                treeSet.add(new Integer(n2));
            }
            treeSet.add(new Integer(n == 0 ? this.maxx : this.maxy));
            return treeSet;
        }

        private List<Map<LayoutComponent, Rectangle>> cutIntoParts(Set<Integer> set, int n) {
            LinkedList<Map<LayoutComponent, Rectangle>> linkedList = new LinkedList<Map<LayoutComponent, Rectangle>>();
            for (Integer n2 : set) {
                int n3 = n2;
                boolean bl = true;
                HashMap<LayoutComponent, Rectangle> hashMap = new HashMap<LayoutComponent, Rectangle>();
                HashMap<LayoutComponent, Rectangle> hashMap2 = new HashMap<LayoutComponent, Rectangle>();
                Iterator<Map.Entry<LayoutComponent, Rectangle>> iterator = this.compToBounds.entrySet().iterator();
                while (bl && iterator.hasNext()) {
                    Map.Entry<LayoutComponent, Rectangle> entry = iterator.next();
                    LayoutComponent layoutComponent = entry.getKey();
                    Rectangle rectangle = entry.getValue();
                    int n4 = n == 0 ? rectangle.x : rectangle.y;
                    int n5 = n4 + (n == 0 ? rectangle.width : rectangle.height);
                    if (n4 >= n3) {
                        hashMap2.put(layoutComponent, rectangle);
                        continue;
                    }
                    if (n5 <= n3) {
                        hashMap.put(layoutComponent, rectangle);
                        continue;
                    }
                    bl = false;
                }
                if (!bl || hashMap.isEmpty() || linkedList.isEmpty() && hashMap.size() == this.compToBounds.size()) continue;
                this.compToBounds.keySet().removeAll(hashMap.keySet());
                linkedList.add(hashMap);
            }
            return linkedList;
        }

        private void mergeSubRegions(List list, int n) {
            if (list.size() == 0) {
                this.horizontal = new LayoutInterval(103);
                this.vertical = new LayoutInterval(103);
                return;
            }
            LayoutInterval layoutInterval = new LayoutInterval(102);
            LayoutInterval layoutInterval2 = new LayoutInterval(103);
            int n2 = n == 0 ? this.minx : this.miny;
            for (RegionInfo regionInfo : list) {
                int n3;
                int n4;
                LayoutInterval layoutInterval3;
                LayoutInterval layoutInterval4;
                if (n == 0) {
                    layoutInterval4 = regionInfo.horizontal;
                    layoutInterval3 = regionInfo.vertical;
                    n4 = regionInfo.miny - this.miny;
                    n3 = regionInfo.minx - n2;
                    n2 = regionInfo.maxx;
                } else {
                    layoutInterval4 = regionInfo.vertical;
                    layoutInterval3 = regionInfo.horizontal;
                    n4 = regionInfo.minx - this.minx;
                    n3 = regionInfo.miny - n2;
                    n2 = regionInfo.maxy;
                }
                if (n3 > 0) {
                    LayoutInterval layoutInterval5 = new LayoutInterval(101);
                    layoutInterval5.setSize(n3);
                    layoutInterval.add(layoutInterval5, -1);
                }
                layoutInterval.add(layoutInterval4, -1);
                layoutInterval3 = this.prefixByGap(layoutInterval3, n4);
                layoutInterval2.add(layoutInterval3, -1);
            }
            if (n == 0) {
                this.horizontal = layoutInterval;
                this.vertical = layoutInterval2;
            } else {
                this.horizontal = layoutInterval2;
                this.vertical = layoutInterval;
            }
        }

        private LayoutInterval prefixByGap(LayoutInterval layoutInterval, int n) {
            if (n > 0) {
                LayoutInterval layoutInterval2 = new LayoutInterval(101);
                layoutInterval2.setSize(n);
                if (layoutInterval.isSequential()) {
                    layoutInterval.add(layoutInterval2, 0);
                } else {
                    LayoutInterval layoutInterval3 = new LayoutInterval(102);
                    layoutInterval3.add(layoutInterval2, -1);
                    layoutInterval3.add(layoutInterval, -1);
                    layoutInterval = layoutInterval3;
                }
            }
            return layoutInterval;
        }

        public LayoutInterval getInterval(int n) {
            return n == 0 ? this.horizontal : this.vertical;
        }
    }
}

